*     JLdL 29Jan12.
*     
*     Copyright (C) 2007-2012 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine calculates and draws the integral curve of the
*     _ vector field that represents the function, starting from the
*     _ current pointer position; depending on the type of event
*     _ that triggered it, the function will draw an integral curve
*     _ going forward (42), one going backward (43), or both (41);
*     _ in the case of event 23 the routine will draw the complete
*     _ integral curve as in event 41, but will also calculate the
*     _ line integral over it, using it as the integration contour
*     _ and calculating the integral in its positive direction; the
*     _ routine deals with true singularities, as well as with other
*     _ numerical overflows, by marking them with red circles; it
*     _ also deals with null vector, that is, the roots of the
*     _ function, by marking them with green circles.
*     
      SUBROUTINE DRAW_INTEGRAL_CURVE (ievent)
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     Define the direction of integration, starting
*     _ with forward integration.
      dir_int = 1.0
*     
*     For event 23, initialize an accumulator for the integral.
      if (ievent .eq. 23) then
         ri_acc = 0.0
      end if
*     
*     Loop the appropriate number of times, depending
*     _ on the value of the variable "ievent".
      do while (dir_int .gt. -2.0)
*     
*     For event 23, use the same color scheme that is used in the
*     _ routine draw_integration_contour().
         if (ievent .eq. 23) then
*     
*     Choose the color scheme for the contents of this routine
*     _ and for this event.
            call set_color_scheme(ics_cont)
*     
         else
*     
*     Choose the color scheme for the contents of this routine
*     _ and for this event.
            call set_color_scheme(ics_curv)
*     
         end if
*     
*     If we are to integrate backwards only, then
*     _ go to the direction -1.0 right away.
         if (ievent .eq. 43) then
            dir_int = -1.0
         end if
*     
*     Define the initial point.
         rx_ini = px_pos
         ry_ini = py_pos
*     
*     Calculate the vector at the initial point.
         call vector_function
     *        (
     *        rx_ini, ry_ini,
     *        vx_ini, vy_ini,
     *        vm_ini,
     *        sz_flag
     *        )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, then mark the position of the singularity with
*     _ a red circle and quit the outer integration loop.
         if (sz_flag .eq. 1) then
            call draw_single_value
     *           (
     *           rx_ini, ry_ini,
     *           vx_ini, vy_ini,
     *           vm_ini,
     *           sz_flag
     *           )
*     
            exit
*     
*     Check for a null vector; in this case we cannot continue the
*     _ integration, so mark the position of the point with a
*     _ green circle and quit the outer integration loop.
         else if (sz_flag .eq. -1) then
            call draw_single_value
     *           (
     *           rx_ini, ry_ini,
     *           vx_ini, vy_ini,
     *           vm_ini,
     *           sz_flag
     *           )
*     
            exit
*     
         end if
*     
*     Initialize the current point.
         rx_cur = rx_ini
         ry_cur = ry_ini
*     
*     Initialize the current value of the vector function.
         vx_cur = vx_ini
         vy_cur = vy_ini
         vm_cur = vm_ini
*     
*     Take the graphics cursor to that point.
         call g2_move_(id_vd, rx_cur, ry_cur)
*     
*     Start an integration step counter.
         is_cnt = 0
*     
*     Initialize the distance between the current point
*     _ and the initial point.
         p_dist = 0.0
*     
*     Initialize the modulus of the difference of versors; if it becomes
*     _ large, then we have hit a singularity or a source-point, and the
*     _ integration will start oscillating back and forth, so we should
*     _ stop it to avoid a long useless wait for the code to reach the
*     _ maximum allowed number of integration loops and finish.
         un_del = 0.0
*     
*     Loop while the point stays within the window, and while we
*     _ are below a certain maximum number of integration steps.
         do while
     *        (
     *        (rx_cur .gt. xr_min)  .and.
     *        (rx_cur .lt. xr_max)  .and.
     *        (ry_cur .gt. yi_min)  .and.
     *        (ry_cur .lt. yi_max)  .and.
     *        (is_cnt .lt. max_cnt) .and.
     *        (
     *        (is_cnt .lt. 10) .or.
     *        (p_dist .gt. del_int)
     *        )                     .and.
     *        (un_del .lt. 1.0)
     *        )
*     
*     Integration algorithm for the integral curves:
*     _ \vec{r} is the position of a point;
*     _ \hat{v} is the tangent versor at a point;
*     _ _0 labels the current point, _1 the next point;
*     _ \delta is the integration interval;
*     _ _t labels a temporary first-order point.
*     
*     First-order algorithm:
*     
*     _ \vec{r}_1 = \vec{r}_0 + \delta \hat{v}_0
*     
*     Second-order algorithm:
*     
*     _ \vec{r}_t = \vec{r}_0 + \delta \hat{v}_0
*     _ \vec{r}_1 = \vec{r}_t + (1/2) \delta (\hat{v}_t - \hat{v}_0)
*     
*     We are using the second-order algorithm here.
*     
*     Normalize the vector at the current point.
            ux_cur = vx_cur / vm_cur
            uy_cur = vy_cur / vm_cur
*     
*     Calculate the next point to first order, using the current versor.
            rx_tmp = rx_cur + dir_int * del_int * ux_cur
            ry_tmp = ry_cur + dir_int * del_int * uy_cur
*     
*     Calculate the vector at the first-order next point; note that this
*     _ is not the final second-order new point, and hence the value of
*     _ the vector obtained here should not be passed as the value of
*     _ the current vector for the next iteration of the loop.
            call vector_function
     *           (
     *           rx_tmp, ry_tmp,
     *           vx_tmp, vy_tmp,
     *           vm_tmp,
     *           sz_flag
     *           )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, then mark the position of the singularity with
*     _ a red circle and quit the inner integration loop.
            if (sz_flag .eq. 1) then
               call draw_single_value
     *              (
     *              rx_tmp, ry_tmp,
     *              vx_tmp, vy_tmp,
     *              vm_tmp,
     *              sz_flag
     *              )
*     
               exit
*     
*     Check for a null vector; in this case we cannot continue the
*     _ integration, so mark the position of the point with a
*     _ green circle and quit the inner integration loop.
            else if (sz_flag .eq. -1) then
               call draw_single_value
     *              (
     *              rx_tmp, ry_tmp,
     *              vx_tmp, vy_tmp,
     *              vm_tmp,
     *              sz_flag
     *              )
*     
               exit
*     
            end if
*     
*     Normalize the vector at the first-order next point.
            ux_tmp = vx_tmp / vm_tmp
            uy_tmp = vy_tmp / vm_tmp
*     
*     Calculate the difference of the two versors.
            ux_del = ux_tmp - ux_cur
            uy_del = uy_tmp - uy_cur
*     
*     Calculate the next point to second order, using the difference
*     _ of versors as a correction to the first-order next point,
*     _ and thus obtaining the new point.
            rx_new = rx_tmp + 0.5 * dir_int * del_int * ux_del
            ry_new = ry_tmp + 0.5 * dir_int * del_int * uy_del
*     
*     Calculate the vector at the new point.
            call vector_function
     *           (
     *           rx_new, ry_new,
     *           vx_new, vy_new,
     *           vm_new,
     *           sz_flag
     *           )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, then mark the position of the singularity with
*     _ a red circle and quit the inner integration loop.
            if (sz_flag .eq. 1) then
               call draw_single_value
     *              (
     *              rx_new, ry_new,
     *              vx_new, vy_new,
     *              vm_new,
     *              sz_flag
     *              )
*     
               exit
*     
*     Check for a null vector; in this case we cannot continue the
*     _ integration, so mark the position of the point with a
*     _ green circle and quit the inner integration loop.
            else if (sz_flag .eq. -1) then
               call draw_single_value
     *              (
     *              rx_new, ry_new,
     *              vx_new, vy_new,
     *              vm_new,
     *              sz_flag
     *              )
*     
               exit
*     
            end if
*     
*     For event 23, calculate the contribution to the line integral.
            if (ievent .eq. 23) then
*     
*     Calculate the variation of the position.
               rx_del = rx_new - rx_cur
               ry_del = ry_new - ry_cur
*     
*     Evaluate the function at the middle point between the
*     _ new one and the current one, in order to improve
*     _ the evaluation of the integral.
*     
*     Define the middle point.
               rx_mid = 0.5 * (rx_new + rx_cur)
               ry_mid = 0.5 * (ry_new + ry_cur)
*     
*     Evaluate the function at the middle point.
               call vector_function
     *              (
     *              rx_mid, ry_mid,
     *              vx_mid, vy_mid,
     *              vm_mid,
     *              sz_flag
     *              )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, then mark the position of the singularity with
*     _ a red circle and quit the inner integration loop.
               if (sz_flag .eq. 1) then
                  call draw_single_value
     *                 (
     *                 rx_mid, ry_mid,
     *                 vx_mid, vy_mid,
     *                 vm_mid,
     *                 sz_flag
     *                 )
*     
                  exit
*     
*     Check for a null vector; in this case we cannot continue the
*     _ integration, so mark the position of the point with a
*     _ green circle and quit the inner integration loop.
               else if (sz_flag .eq. -1) then
                  call draw_single_value
     *                 (
     *                 rx_mid, ry_mid,
     *                 vx_mid, vy_mid,
     *                 vm_mid,
     *                 sz_flag
     *                 )
*     
                  exit
*     
               end if
*     
*     Calculate a weighted average of the three values, with
*     _ weights given by their fractions of the interval.
               vx_avr = 0.25 * (vx_new + 2.0 * vx_mid + vx_cur)
               vy_avr = 0.25 * (vy_new + 2.0 * vy_mid + vy_cur)
*     
*     Accumulate the line integral, taking into account
*     _ explicitly the direction of integration.
               ri_acc = ri_acc
     *              + dir_int * rx_del * vx_avr
     *              + dir_int * ry_del * vy_avr
*     
            end if
*     
*     Draw a line to the new point.
            call g2_line_to_(id_vd, rx_new, ry_new)
*     
*     Count the integration step.
            is_cnt = is_cnt + 1
*     
*     Calculate the distance from the initial point
            p_dist = sqrt((rx_new - rx_ini)**2 + (ry_new - ry_ini)**2)
*     
*     Calculate the modulus of the difference of versors.
            un_del = sqrt(ux_del**2 + uy_del**2)
*     
*     Pass the new point to the current point.
            rx_cur = rx_new
            ry_cur = ry_new
*     
*     Pass the value of the vector function.
            vx_cur = vx_new
            vy_cur = vy_new
            vm_cur = vm_new
*     
         end do
*     
*     If we have completed a closed contour, then take care
*     _ of its last segment, from the current point back
*     _ to the initial point; however, only do this if
*     _ there is no singularity at the last point.
         if ( (p_dist .le. del_int) .and.
     *        (sz_flag .eq. 0)      ) then
*     
*     For event 23, calculate the last contribution to the line
*     _ integral, in order to complete it.
            if (ievent .eq. 23) then
*     
*     Calculate the variation of the position.
               rx_del = rx_ini - rx_cur
               ry_del = ry_ini - ry_cur
*     
*     Evaluate the function at the middle point between the
*     _ current one and the first one, in order to improve
*     _ the evaluation of the integral.
*     
*     Define the middle point.
               rx_mid = 0.5 * (rx_ini + rx_cur)
               ry_mid = 0.5 * (ry_ini + ry_cur)
*     
*     Evaluate the function at the middle point.
               call vector_function
     *              (
     *              rx_mid, ry_mid,
     *              vx_mid, vy_mid,
     *              vm_mid,
     *              sz_flag
     *              )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, then mark the position of the singularity with
*     _ a red circle and quit the outer integration loop.
               if (sz_flag .eq. 1) then
                  call draw_single_value
     *                 (
     *                 rx_mid, ry_mid,
     *                 vx_mid, vy_mid,
     *                 vm_mid,
     *                 sz_flag
     *                 )
*     
                  exit
*     
*     Check for a null vector; in this case we cannot continue the
*     _ integration, so mark the position of the point with a
*     _ green circle and quit the outer integration loop.
               else if (sz_flag .eq. -1) then
                  call draw_single_value
     *                 (
     *                 rx_mid, ry_mid,
     *                 vx_mid, vy_mid,
     *                 vm_mid,
     *                 sz_flag
     *                 )
*     
                  exit
*     
               end if
*     
*     Calculate a weighted average of the three values, with
*     _ weights given by their fractions of the interval.
               vx_avr = 0.25 * (vx_ini + 2.0 * vx_mid + vx_cur)
               vy_avr = 0.25 * (vy_ini + 2.0 * vy_mid + vy_cur)
*     
*     Accumulate the line integral, taking into account
*     _ explicitly the direction of integration.
               ri_acc = ri_acc
     *              + dir_int * rx_del * vx_avr
     *              + dir_int * ry_del * vy_avr
*     
            end if
*     
*     Draw the last part of the closed contour, from the current
*     _ point back to the initial point.
            call g2_line_to_(id_vd, rx_ini, ry_ini)
*     
         end if
*     
*     Flush the graphics buffers.
         call g2_flush_ctof(id_vd)
*     
*     If we are to integrate in one direction only, then we are done,
*     _ so stop the external loop by setting the direction to -3.0;
*     _ do this also in case we are to integrate in both directions,
*     _ but the first integral already completed a closed contour.
         if ( (ievent .eq. 42) .or.
     *        (ievent .eq. 43) .or.
     *        (
     *        (ievent .eq. 41) .and.
     *        (p_dist .le. del_int)
     *        ) .or.
     *        (
     *        (ievent .eq. 23) .and.
     *        (p_dist .le. del_int)
     *        )
     *        ) then
            dir_int = -3.0
*     
*     Otherwise, decrease the variable "dir_int" to -1.0, in order to
*     _ integrate a second time in the negative direction, or to even
*     _ less than that, in order to stop the outer loop.
         else
            dir_int = dir_int - 2.0
         end if
*     
      end do
*     
*     For event 23, draw the result of the integration on the window.
      if (ievent .eq. 23) then
*     
*     Write the result of the integration on the lower left-hand
*     _ corner of the plotting window, in reversed colors; note
*     _ that, since the size of the font is defined in pixels,
*     _ all dimensions here must also be given in pixels; since
*     _ the sizes and positions are to be given to the graphics
*     _ functions in coordinate units, we must use here the
*     _ inverse coordinate multipliers "xc_div" and "yc_div".
*     
*     Draw the background rectangles for the text, using reversed
*     _ colors, so use the normal colors for the rectangles.
         call set_color_scheme(ics_norm)
*     
*     Draw a background rectangle.
         call g2_filled_rectangle_ctof
     *        (
     *        id_vd,
     *        xr_min,                 yi_min,
     *        xr_min + 69.0 * xc_div, yi_min + 15.0 * yc_div
     *        )
*     
*     Reverse the colors in order to draw the text.
         call set_color_scheme(ics_reve)
*     
*     Draw the floating-point result as a string.
         call g2_float_string_ctof
     *        (
     *        id_vd,
     *        xr_min +  2.0 * xc_div, yi_min +  1.0 * yc_div,
     *        ri_acc,
     *        '%.4f'
     *        )
*     
*     Flush the graphics buffers.
         call g2_flush_ctof(id_vd)
*     
      end if
*     
      return
*     
      END
