*     JLdL 03Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine opens an output file in EPS format, which will hold
*     _ a copy of the current graphic contents of the plotting window;
*     _ given the data read in from the front-end program, it opens
*     _ the file with an appropriate clipping region; it also defines
*     _ standard default colors on it, defines a coordinate system on
*     _ it, chooses the size of the text font for it and associates
*     _ it to the existing virtual device.
*     
      SUBROUTINE OPEN_OUTPUT_FILE
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     A character variable for the output file name.
      character*128 output_fname
*     
*     Define the output file name; we must define the string
*     _ with the trailing NULL, including it by hand.
      output_fname = 'complex-functions.eps'//char(0)
*     
*     Open a physical EPS device, which is in fact an EPS file.
      id_fd = g2_open_epsf_clip_ctof
     *     (
     *     output_fname,
     *     ix_siz,       iy_siz
     *     )
*     
*     Define the 27 standard g2 colors.
      call g2_allocate_basic_colors_ctof(id_fd)
*     
*     Set the background to white.
*     
*     _ NOTE: this does NOT seem to work.
*     
      call g2_set_background_ctof(id_fd, ibc_white)
*     
*     Set the coordinate system.
      call g2_set_coordinate_system_ctof
     *     (
     *     id_fd,
     *     xc_org, yc_org,
     *     xc_mul, yc_mul
     *     )
*     
*     Unset the autoflush mode for the device.
      call g2_set_auto_flush_ctof(id_fd, 0)
*     
*     Set the font size.
      call g2_set_font_size_ctof(id_fd, fnt_siz)
*     
*     Associate the physical device to the virtual device.
      call g2_attach_ctof(id_vd, id_fd)
*     
      return
*     
      END
