*     JLdL 18Oct07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine waits for the temporary data-transfer file written
*     _ by the front-end program to appear and, when it does appear,
*     _ opens it with file descriptor 1; the file name defined in
*     _ the front-end program is 'complex-functions-params.tmp'.
*     
      SUBROUTINE WAIT_TO_OPEN
*     
*     Loop and monitor an open-error variable, in order to wait
*     _ for the temporary data-transfer file to appear.
      ioerr = 1
      do while (ioerr .ne. 0)
*     
*     Try to open an already existing file, storing the open status
*     _ in the variable ioerr; if the file is not there or the open
*     _ fails for any other reason, just continue looping in order
*     _ to try again.
         open(unit=1,
     *        file='complex-functions-params.tmp',
     *        status='old',
     *        iostat=ioerr)
*     
*     If the open fails, then sleep-wait for 0.01 second,
*     _ in order to avoid idly overloading the system.
         if (ioerr .ne. 0) then
            call musleep_ctof(10000)
         end if
*     
      end do
*     
      return
*     
      END
