*     JLdL 11Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine draws the values of the function at the grid
*     _ points, or at random points.
*     
      SUBROUTINE DRAW_GRID_VALUES
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     Choose the color scheme for the contents of this routine.
      call set_color_scheme(ics_norm)
*     
*     Case of cartesian coordinates.
      if (i_cscp .eq. 1) then
*     
*     Calculate the limits of the integer coordinates.
         ix_min = int(xr_min / gr_siz) - 1
         ix_max = int(xr_max / gr_siz) + 1
         iy_min = int(yi_min / gr_siz) - 1
         iy_max = int(yi_max / gr_siz) + 1
*     
*     Loop over the grid.
         do iy = iy_min, iy_max
            do ix = ix_min, ix_max
*     
*     Calculate the position of the point.
               x_pos = float(ix) * gr_siz
               y_pos = float(iy) * gr_siz
*     
*     Evaluate the function.
               call vector_function
     *              (
     *              x_pos, y_pos,
     *              x_val, y_val,
     *              v_mod,
     *              sz_flag
     *              )
*     
*     Plot the function.
               call draw_single_value
     *              (
     *              x_pos, y_pos,
     *              x_val, y_val,
     *              v_mod,
     *              sz_flag
     *              )
*     
            end do
*     
         end do
*     
*     Case of polar coordinates.
      else if (i_cscp .eq. 2) then
*     
*     Calculate the maximum possible value of the
*     _ radial coordinate.
         x_max = max(abs(xr_min), abs(xr_max))
         y_max = max(abs(yi_min), abs(yi_max))
         r_max = sqrt(x_max**2 + y_max**2)
*     
*     Calculate the limit of the corresponding
*     _ integer coordinate.
         num_r = int(r_max / gr_siz) + 1
*     
*     Loop over the radial direction.
         do ir = 0, num_r
*     
*     Calculate the radial position of the point.
            r_pos = float(ir) * gr_siz
*     
*     Calculate the maximum possible value o the
*     _ angular coordinate (the arc).
            a_max = twopi * r_pos
*     
*     Calculate the limit of the corresponding
*     _ integer coordinate.
            num_a = 1+ int(a_max / gr_siz)
*     
*     Divide the complete arc into equal parts.
            del_a = twopi / float(num_a)
*     
*     Loop over the angular direction.
            do ia = 1, num_a
*     
*     Calculate the angular position of the point.
               a_pos = float(ia) * del_a
*     
*     Calculate the position of the point.
               x_pos = r_pos * cos(a_pos)
               y_pos = r_pos * sin(a_pos)
*     
*     Check the position of the point; only plot the
*     _ function if it is within the window.
               if ( (x_pos .ge. xr_min - 1.0) .and.
     *              (x_pos .le. xr_max + 1.0) .and.
     *              (y_pos .ge. yi_min - 1.0) .and.
     *              (y_pos .le. yi_max + 1.0) ) then
*     
*     Evaluate the function.
                  call vector_function
     *                 (
     *                 x_pos, y_pos,
     *                 x_val, y_val,
     *                 v_mod,
     *                 sz_flag
     *                 )
*     
*     Plot the function.
                  call draw_single_value
     *                 (
     *                 x_pos, y_pos,
     *                 x_val, y_val,
     *                 v_mod,
     *                 sz_flag
     *                 )
*     
               end if
*     
            end do
*     
         end do
*     
*     Case of random grid points.
      else if (i_cscp .eq. 3) then
*     
*     Calculate the number of points if the grid was
*     _ cartesian, then double it.
         dx_max = xr_max - xr_min
         dy_max = yi_max - yi_min
         max_dx = int(dx_max / gr_siz)
         max_dy = int(dy_max / gr_siz)
         n_rand = 2 * max_dx * max_dy
*     
*     Initialize a random seed.
         call urandom_ctof(nseed)
*     
*     Loop over the random points.
         do i_rand = 1, n_rand
*     
*     Calculate a random position within the range
*     _ of the coordinates.
            x_pos = xr_min + ranr(nseed) * dx_max
            y_pos = yi_min + ranr(nseed) * dy_max
*     
*     Evaluate the function.
            call vector_function
     *           (
     *           x_pos, y_pos,
     *           x_val, y_val,
     *           v_mod,
     *           sz_flag
     *           )
*     
*     Plot the function.
            call draw_single_value
     *           (
     *           x_pos, y_pos,
     *           x_val, y_val,
     *           v_mod,
     *           sz_flag
     *           )
*     
         end do
*     
      end if
*     
      return
*     
      END
