/* JLdL 29Jan12.
 *
 * Copyright (C) 2007-2012 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use of the glibc function usleep(usecs),
 * _ which causes the process to sleep for usecs microseconds, from
 * _ Fortran programs.
 *
 * This is to be called from Fortran as an integer function, that is,
 * _ as "nstatus=musleep_ctof(musecs)"; you may also call it as a
 * _ subroutine (a void function), so long as you do not declare the
 * _ type of the function within the Fortran program, that is, in
 * _ that case you may call it as "call musleep_ctof(musecs)".
 */
#include <unistd.h>
int musleep_ctof__(int *musecs)
{
  return usleep(*musecs);
}
/*
 * Compatibility function for gfortran.
 */
int musleep_ctof_(int *musecs)
{
  musleep_ctof__(musecs);
}
