*     JLdL 30Jan14.
*     
*     Copyright (C) 2007-2014 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This program reads a sequence of numbers from stdin, then
*     _ calculates their average and dispersion and writes them
*     _ to stdout.
*     
      PROGRAM AVERDIS
*     
*     Double precision everything.
      implicit double precision (a-h,o-z)
*     
*     The maximum number of numbers that this
*     _ program can deal with, plus one.
      parameter(nmax=10001)
*     
*     Storage for the numbers, in real form.
      dimension rnum(nmax)
*     
*     Read the numbers from stdin; this must be a single
*     _ column of single integer or real numbers.
      do inum=1,nmax
         read(*,*,iostat=ioerr) rnum(inum)
         if (ioerr.ne.0) exit
      end do
*     
*     There must have been an end-of-file read error.
      if (ioerr.ne.-1) then
*     
*     Write an error message and abort.
         if (ioerr.eq.0) then
            write(*,*) 'averdis: ERROR: too many numbers'
         else
            write(*,*) 'averdis: ERROR: input read error'
         end if
*     
         stop
*     
      end if
*     
*     Determine the number of numbers read in.
      nnum=inum-1
*     
*     Add all the numbers.
*     
*     Initialize an accumulator.
      sum=0.0d0
*     
*     Loop over the numbers.
      do inum=1,nnum
         sum=sum+rnum(inum)
      end do
*     
*     Calculate the average.
      ravr=sum/dble(nnum)
*     
*     Accumulate the squared differences.
*     
*     Initialize an accumulator.
      sum=0.0d0
*     
*     Loop over the numbers.
      do inum=1,nnum
         sum=sum+(ravr-rnum(inum))**2
      end do
*     
*     Calculate the dispersion.
      disp=dsqrt(sum/dble(nnum))
*     
*     If the numbers are integers, write them out as such;
*     _ otherwise, write them out as a real numbers.
      navr=int(ravr)
      ndis=int(disp)
      if (dble(navr).eq.ravr) then
         if (dble(ndis).eq.disp) then
            write(*,*) navr,'  +/-',ndis
         else
            write(*,*) navr,'  +/-',disp
         end if
      else
         if (dble(ndis).eq.disp) then
            write(*,*) ravr,'  +/-',ndis
         else
            write(*,*) ravr,'  +/-',disp
         end if
      end if
*     
      END
