/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.tests;

import gr.zeus.ui.table.AutoResizeTableColumns;
import gr.zeus.ui.table.ProgressBarCellRenderer;
import gr.zeus.ui.table.TableSorter;
import gr.zeus.ui.table.TableSorterIcons;
import gr.zeus.util.DateHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class JTableTester
extends JFrame {
    private static final String[] COLUMN_NAMES = new String[]{"DATE", "INTEGER", "FIRSTNAME", "LASTNAME", "FLOAT", "BOOLEAN", "PROGRESS"};
    private DefaultTableModel m_tableModel = new DefaultTableModel(null, COLUMN_NAMES){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }
    };
    private TableSorter m_tableSorter = new TableSorter(this.m_tableModel);
    private JButton button;
    private JCheckBox checkBox;
    private JTextField dateTextField;
    private JTextField firstnameTextField;
    private JTextField floatTextField;
    private JTextField intTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JTextField lastnameTextField;
    private JTable m_table;
    private JSpinner percentSpinner;

    public JTableTester() {
        this.initComponents();
        this.m_table.setModel(this.m_tableModel);
        Icon[] ups = new Icon[]{TableSorterIcons.UP5_ICON, TableSorterIcons.UP7_ICON, TableSorterIcons.UP6_ICON, TableSorterIcons.UP4_ICON, TableSorterIcons.UP3_ICON, TableSorterIcons.UP2_ICON, TableSorterIcons.UP1_ICON};
        Icon[] downs = new Icon[]{TableSorterIcons.DOWN5_ICON, TableSorterIcons.DOWN7_ICON, TableSorterIcons.DOWN6_ICON, TableSorterIcons.DOWN4_ICON, TableSorterIcons.DOWN3_ICON, TableSorterIcons.DOWN2_ICON, TableSorterIcons.DOWN1_ICON};
        this.m_tableSorter.setCustomIcons(ups, downs);
        this.m_tableSorter.setTableHeader(this.m_table.getTableHeader());
        this.m_table.setModel(this.m_tableSorter);
        AutoResizeTableColumns resizer = new AutoResizeTableColumns(this.m_table, this.m_tableModel, 32, true, true, new boolean[this.m_table.getColumnCount()]);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            Object[][] values = new Object[][]{{sdf.parse("29/11/2004"), new Integer(999), "Gregory", "Kotsaftis", new Float(999.99f), Boolean.FALSE, new Integer(90)}, {sdf.parse("14/06/2003"), new Integer(888), "Litsa", "Katsoni", new Float(888.88f), Boolean.TRUE, new Integer(80)}, {sdf.parse("20/07/2001"), new Integer(9), "George", "Mavrakis", new Float(109.3f), Boolean.TRUE, new Integer(25)}, {sdf.parse("30/10/1999"), new Integer(190), "Kostas", "Filippaios", new Float(23.27f), Boolean.FALSE, new Integer(50)}, {sdf.parse("02/02/2002"), new Integer(1258), "John", "Papadopoulos", new Float(109.3f), Boolean.TRUE, new Integer(100)}, {sdf.parse("15/12/1985"), new Integer(910), "Spyros", "Papadolpoulos", new Float(410.08f), Boolean.FALSE, new Integer(75)}, {sdf.parse("6/04/2000"), new Integer(5), "Makis", "Triantafyllopoulos", new Float(10.0f), Boolean.TRUE, new Integer(100)}};
            this.m_tableModel.setDataVector(values, COLUMN_NAMES);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Hashtable<Integer, Color> limitColors = new Hashtable<Integer, Color>();
        limitColors.put(new Integer(0), Color.green);
        limitColors.put(new Integer(60), Color.yellow);
        limitColors.put(new Integer(80), Color.red);
        TableColumnModel model = this.m_table.getColumnModel();
        model.getColumn(6).setCellRenderer(new ProgressBarCellRenderer(true, false, 0, 100, limitColors, this.m_table.getBackground()));
    }

    private void add_row() {
        try {
            Date d = DateHelper.parseDate(this.dateTextField.getText().trim(), "dd/MM/yyyy");
            Integer i = new Integer(this.intTextField.getText().trim());
            String firstname = this.firstnameTextField.getText().trim();
            String lastname = this.lastnameTextField.getText().trim();
            Float f = new Float(this.floatTextField.getText().trim());
            Boolean b = new Boolean(this.checkBox.isSelected());
            Integer percent = (Integer)this.percentSpinner.getValue();
            this.m_tableModel.addRow(new Object[]{d, i, firstname, lastname, f, b, percent});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.m_table = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.dateTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.intTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.firstnameTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.lastnameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.floatTextField = new JTextField();
        this.checkBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.percentSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 10));
        this.button = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Tester for JTable sorting, resizing and more...");
        this.m_table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5", "Title 6", "Title 7"}));
        this.m_table.setToolTipText("Press down and hold CTRL or SHIFT while selecting multiple columns' headers for sorting.");
        jScrollPane1.setViewportView(this.m_table);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        this.jPanel1.setMinimumSize(new Dimension(500, 60));
        this.jPanel1.setPreferredSize(new Dimension(500, 60));
        this.jPanel1.setLayout(null);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("dd/MM/yyyy");
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(10, 10, 70, 20);
        this.jPanel1.add(this.dateTextField);
        this.dateTextField.setBounds(10, 30, 70, 21);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("int");
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(90, 10, 30, 20);
        this.jPanel1.add(this.intTextField);
        this.intTextField.setBounds(90, 30, 30, 21);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("firstname");
        this.jPanel1.add(this.jLabel3);
        this.jLabel3.setBounds(130, 10, 90, 20);
        this.jPanel1.add(this.firstnameTextField);
        this.firstnameTextField.setBounds(130, 30, 90, 21);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("lastname");
        this.jPanel1.add(this.jLabel4);
        this.jLabel4.setBounds(230, 10, 90, 20);
        this.jPanel1.add(this.lastnameTextField);
        this.lastnameTextField.setBounds(230, 30, 90, 21);
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("float");
        this.jPanel1.add(this.jLabel5);
        this.jLabel5.setBounds(330, 10, 30, 20);
        this.jPanel1.add(this.floatTextField);
        this.floatTextField.setBounds(330, 30, 30, 21);
        this.jPanel1.add(this.checkBox);
        this.checkBox.setBounds(370, 30, 20, 17);
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("percent");
        this.jPanel1.add(this.jLabel6);
        this.jLabel6.setBounds(400, 10, 40, 20);
        this.jPanel1.add(this.percentSpinner);
        this.percentSpinner.setBounds(400, 30, 40, 21);
        this.button.setText("+");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTableTester.this.buttonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.button);
        this.button.setBounds(450, 10, 40, 40);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void buttonActionPerformed(ActionEvent evt) {
        this.add_row();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JTableTester().setVisible(true);
            }
        });
    }
}

