#include "vulkan_names.h"
    
std::ostream& operator << (std::ostream& os, VkPipelineCacheHeaderVersion e) {
  switch (e) {
    ENUM_NAME(VK_PIPELINE_CACHE_HEADER_VERSION_ONE);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkResult e) {
  switch (e) {
    ENUM_NAME(VK_SUCCESS);
    ENUM_NAME(VK_NOT_READY);
    ENUM_NAME(VK_TIMEOUT);
    ENUM_NAME(VK_EVENT_SET);
    ENUM_NAME(VK_EVENT_RESET);
    ENUM_NAME(VK_INCOMPLETE);
    ENUM_NAME(VK_ERROR_OUT_OF_HOST_MEMORY);
    ENUM_NAME(VK_ERROR_OUT_OF_DEVICE_MEMORY);
    ENUM_NAME(VK_ERROR_INITIALIZATION_FAILED);
    ENUM_NAME(VK_ERROR_DEVICE_LOST);
    ENUM_NAME(VK_ERROR_MEMORY_MAP_FAILED);
    ENUM_NAME(VK_ERROR_LAYER_NOT_PRESENT);
    ENUM_NAME(VK_ERROR_EXTENSION_NOT_PRESENT);
    ENUM_NAME(VK_ERROR_FEATURE_NOT_PRESENT);
    ENUM_NAME(VK_ERROR_INCOMPATIBLE_DRIVER);
    ENUM_NAME(VK_ERROR_TOO_MANY_OBJECTS);
    ENUM_NAME(VK_ERROR_FORMAT_NOT_SUPPORTED);
    ENUM_NAME(VK_ERROR_FRAGMENTED_POOL);
    ENUM_NAME(VK_ERROR_SURFACE_LOST_KHR);
    ENUM_NAME(VK_ERROR_NATIVE_WINDOW_IN_USE_KHR);
    ENUM_NAME(VK_SUBOPTIMAL_KHR);
    ENUM_NAME(VK_ERROR_OUT_OF_DATE_KHR);
    ENUM_NAME(VK_ERROR_INCOMPATIBLE_DISPLAY_KHR);
    ENUM_NAME(VK_ERROR_VALIDATION_FAILED_EXT);
    ENUM_NAME(VK_ERROR_INVALID_SHADER_NV);
    ENUM_NAME(VK_ERROR_OUT_OF_POOL_MEMORY_KHR);
    ENUM_NAME(VK_ERROR_INVALID_EXTERNAL_HANDLE_KHR);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkFormat e) {
  switch (e) {
    ENUM_NAME(VK_FORMAT_UNDEFINED);
    ENUM_NAME(VK_FORMAT_R4G4_UNORM_PACK8);
    ENUM_NAME(VK_FORMAT_R4G4B4A4_UNORM_PACK16);
    ENUM_NAME(VK_FORMAT_B4G4R4A4_UNORM_PACK16);
    ENUM_NAME(VK_FORMAT_R5G6B5_UNORM_PACK16);
    ENUM_NAME(VK_FORMAT_B5G6R5_UNORM_PACK16);
    ENUM_NAME(VK_FORMAT_R5G5B5A1_UNORM_PACK16);
    ENUM_NAME(VK_FORMAT_B5G5R5A1_UNORM_PACK16);
    ENUM_NAME(VK_FORMAT_A1R5G5B5_UNORM_PACK16);
    ENUM_NAME(VK_FORMAT_R8_UNORM);
    ENUM_NAME(VK_FORMAT_R8_SNORM);
    ENUM_NAME(VK_FORMAT_R8_USCALED);
    ENUM_NAME(VK_FORMAT_R8_SSCALED);
    ENUM_NAME(VK_FORMAT_R8_UINT);
    ENUM_NAME(VK_FORMAT_R8_SINT);
    ENUM_NAME(VK_FORMAT_R8_SRGB);
    ENUM_NAME(VK_FORMAT_R8G8_UNORM);
    ENUM_NAME(VK_FORMAT_R8G8_SNORM);
    ENUM_NAME(VK_FORMAT_R8G8_USCALED);
    ENUM_NAME(VK_FORMAT_R8G8_SSCALED);
    ENUM_NAME(VK_FORMAT_R8G8_UINT);
    ENUM_NAME(VK_FORMAT_R8G8_SINT);
    ENUM_NAME(VK_FORMAT_R8G8_SRGB);
    ENUM_NAME(VK_FORMAT_R8G8B8_UNORM);
    ENUM_NAME(VK_FORMAT_R8G8B8_SNORM);
    ENUM_NAME(VK_FORMAT_R8G8B8_USCALED);
    ENUM_NAME(VK_FORMAT_R8G8B8_SSCALED);
    ENUM_NAME(VK_FORMAT_R8G8B8_UINT);
    ENUM_NAME(VK_FORMAT_R8G8B8_SINT);
    ENUM_NAME(VK_FORMAT_R8G8B8_SRGB);
    ENUM_NAME(VK_FORMAT_B8G8R8_UNORM);
    ENUM_NAME(VK_FORMAT_B8G8R8_SNORM);
    ENUM_NAME(VK_FORMAT_B8G8R8_USCALED);
    ENUM_NAME(VK_FORMAT_B8G8R8_SSCALED);
    ENUM_NAME(VK_FORMAT_B8G8R8_UINT);
    ENUM_NAME(VK_FORMAT_B8G8R8_SINT);
    ENUM_NAME(VK_FORMAT_B8G8R8_SRGB);
    ENUM_NAME(VK_FORMAT_R8G8B8A8_UNORM);
    ENUM_NAME(VK_FORMAT_R8G8B8A8_SNORM);
    ENUM_NAME(VK_FORMAT_R8G8B8A8_USCALED);
    ENUM_NAME(VK_FORMAT_R8G8B8A8_SSCALED);
    ENUM_NAME(VK_FORMAT_R8G8B8A8_UINT);
    ENUM_NAME(VK_FORMAT_R8G8B8A8_SINT);
    ENUM_NAME(VK_FORMAT_R8G8B8A8_SRGB);
    ENUM_NAME(VK_FORMAT_B8G8R8A8_UNORM);
    ENUM_NAME(VK_FORMAT_B8G8R8A8_SNORM);
    ENUM_NAME(VK_FORMAT_B8G8R8A8_USCALED);
    ENUM_NAME(VK_FORMAT_B8G8R8A8_SSCALED);
    ENUM_NAME(VK_FORMAT_B8G8R8A8_UINT);
    ENUM_NAME(VK_FORMAT_B8G8R8A8_SINT);
    ENUM_NAME(VK_FORMAT_B8G8R8A8_SRGB);
    ENUM_NAME(VK_FORMAT_A8B8G8R8_UNORM_PACK32);
    ENUM_NAME(VK_FORMAT_A8B8G8R8_SNORM_PACK32);
    ENUM_NAME(VK_FORMAT_A8B8G8R8_USCALED_PACK32);
    ENUM_NAME(VK_FORMAT_A8B8G8R8_SSCALED_PACK32);
    ENUM_NAME(VK_FORMAT_A8B8G8R8_UINT_PACK32);
    ENUM_NAME(VK_FORMAT_A8B8G8R8_SINT_PACK32);
    ENUM_NAME(VK_FORMAT_A8B8G8R8_SRGB_PACK32);
    ENUM_NAME(VK_FORMAT_A2R10G10B10_UNORM_PACK32);
    ENUM_NAME(VK_FORMAT_A2R10G10B10_SNORM_PACK32);
    ENUM_NAME(VK_FORMAT_A2R10G10B10_USCALED_PACK32);
    ENUM_NAME(VK_FORMAT_A2R10G10B10_SSCALED_PACK32);
    ENUM_NAME(VK_FORMAT_A2R10G10B10_UINT_PACK32);
    ENUM_NAME(VK_FORMAT_A2R10G10B10_SINT_PACK32);
    ENUM_NAME(VK_FORMAT_A2B10G10R10_UNORM_PACK32);
    ENUM_NAME(VK_FORMAT_A2B10G10R10_SNORM_PACK32);
    ENUM_NAME(VK_FORMAT_A2B10G10R10_USCALED_PACK32);
    ENUM_NAME(VK_FORMAT_A2B10G10R10_SSCALED_PACK32);
    ENUM_NAME(VK_FORMAT_A2B10G10R10_UINT_PACK32);
    ENUM_NAME(VK_FORMAT_A2B10G10R10_SINT_PACK32);
    ENUM_NAME(VK_FORMAT_R16_UNORM);
    ENUM_NAME(VK_FORMAT_R16_SNORM);
    ENUM_NAME(VK_FORMAT_R16_USCALED);
    ENUM_NAME(VK_FORMAT_R16_SSCALED);
    ENUM_NAME(VK_FORMAT_R16_UINT);
    ENUM_NAME(VK_FORMAT_R16_SINT);
    ENUM_NAME(VK_FORMAT_R16_SFLOAT);
    ENUM_NAME(VK_FORMAT_R16G16_UNORM);
    ENUM_NAME(VK_FORMAT_R16G16_SNORM);
    ENUM_NAME(VK_FORMAT_R16G16_USCALED);
    ENUM_NAME(VK_FORMAT_R16G16_SSCALED);
    ENUM_NAME(VK_FORMAT_R16G16_UINT);
    ENUM_NAME(VK_FORMAT_R16G16_SINT);
    ENUM_NAME(VK_FORMAT_R16G16_SFLOAT);
    ENUM_NAME(VK_FORMAT_R16G16B16_UNORM);
    ENUM_NAME(VK_FORMAT_R16G16B16_SNORM);
    ENUM_NAME(VK_FORMAT_R16G16B16_USCALED);
    ENUM_NAME(VK_FORMAT_R16G16B16_SSCALED);
    ENUM_NAME(VK_FORMAT_R16G16B16_UINT);
    ENUM_NAME(VK_FORMAT_R16G16B16_SINT);
    ENUM_NAME(VK_FORMAT_R16G16B16_SFLOAT);
    ENUM_NAME(VK_FORMAT_R16G16B16A16_UNORM);
    ENUM_NAME(VK_FORMAT_R16G16B16A16_SNORM);
    ENUM_NAME(VK_FORMAT_R16G16B16A16_USCALED);
    ENUM_NAME(VK_FORMAT_R16G16B16A16_SSCALED);
    ENUM_NAME(VK_FORMAT_R16G16B16A16_UINT);
    ENUM_NAME(VK_FORMAT_R16G16B16A16_SINT);
    ENUM_NAME(VK_FORMAT_R16G16B16A16_SFLOAT);
    ENUM_NAME(VK_FORMAT_R32_UINT);
    ENUM_NAME(VK_FORMAT_R32_SINT);
    ENUM_NAME(VK_FORMAT_R32_SFLOAT);
    ENUM_NAME(VK_FORMAT_R32G32_UINT);
    ENUM_NAME(VK_FORMAT_R32G32_SINT);
    ENUM_NAME(VK_FORMAT_R32G32_SFLOAT);
    ENUM_NAME(VK_FORMAT_R32G32B32_UINT);
    ENUM_NAME(VK_FORMAT_R32G32B32_SINT);
    ENUM_NAME(VK_FORMAT_R32G32B32_SFLOAT);
    ENUM_NAME(VK_FORMAT_R32G32B32A32_UINT);
    ENUM_NAME(VK_FORMAT_R32G32B32A32_SINT);
    ENUM_NAME(VK_FORMAT_R32G32B32A32_SFLOAT);
    ENUM_NAME(VK_FORMAT_R64_UINT);
    ENUM_NAME(VK_FORMAT_R64_SINT);
    ENUM_NAME(VK_FORMAT_R64_SFLOAT);
    ENUM_NAME(VK_FORMAT_R64G64_UINT);
    ENUM_NAME(VK_FORMAT_R64G64_SINT);
    ENUM_NAME(VK_FORMAT_R64G64_SFLOAT);
    ENUM_NAME(VK_FORMAT_R64G64B64_UINT);
    ENUM_NAME(VK_FORMAT_R64G64B64_SINT);
    ENUM_NAME(VK_FORMAT_R64G64B64_SFLOAT);
    ENUM_NAME(VK_FORMAT_R64G64B64A64_UINT);
    ENUM_NAME(VK_FORMAT_R64G64B64A64_SINT);
    ENUM_NAME(VK_FORMAT_R64G64B64A64_SFLOAT);
    ENUM_NAME(VK_FORMAT_B10G11R11_UFLOAT_PACK32);
    ENUM_NAME(VK_FORMAT_E5B9G9R9_UFLOAT_PACK32);
    ENUM_NAME(VK_FORMAT_D16_UNORM);
    ENUM_NAME(VK_FORMAT_X8_D24_UNORM_PACK32);
    ENUM_NAME(VK_FORMAT_D32_SFLOAT);
    ENUM_NAME(VK_FORMAT_S8_UINT);
    ENUM_NAME(VK_FORMAT_D16_UNORM_S8_UINT);
    ENUM_NAME(VK_FORMAT_D24_UNORM_S8_UINT);
    ENUM_NAME(VK_FORMAT_D32_SFLOAT_S8_UINT);
    ENUM_NAME(VK_FORMAT_BC1_RGB_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC1_RGB_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_BC1_RGBA_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC1_RGBA_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_BC2_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC2_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_BC3_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC3_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_BC4_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC4_SNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC5_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC5_SNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC6H_UFLOAT_BLOCK);
    ENUM_NAME(VK_FORMAT_BC6H_SFLOAT_BLOCK);
    ENUM_NAME(VK_FORMAT_BC7_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_BC7_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_EAC_R11_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_EAC_R11_SNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_EAC_R11G11_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_EAC_R11G11_SNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_4x4_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_4x4_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_5x4_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_5x4_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_5x5_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_5x5_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_6x5_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_6x5_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_6x6_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_6x6_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_8x5_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_8x5_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_8x6_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_8x6_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_8x8_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_8x8_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_10x5_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_10x5_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_10x6_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_10x6_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_10x8_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_10x8_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_10x10_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_10x10_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_12x10_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_12x10_SRGB_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_12x12_UNORM_BLOCK);
    ENUM_NAME(VK_FORMAT_ASTC_12x12_SRGB_BLOCK);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkImageType e) {
  switch (e) {
    ENUM_NAME(VK_IMAGE_TYPE_1D);
    ENUM_NAME(VK_IMAGE_TYPE_2D);
    ENUM_NAME(VK_IMAGE_TYPE_3D);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkImageTiling e) {
  switch (e) {
    ENUM_NAME(VK_IMAGE_TILING_OPTIMAL);
    ENUM_NAME(VK_IMAGE_TILING_LINEAR);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkImageLayout e) {
  switch (e) {
    ENUM_NAME(VK_IMAGE_LAYOUT_UNDEFINED);
    ENUM_NAME(VK_IMAGE_LAYOUT_GENERAL);
    ENUM_NAME(VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL);
    ENUM_NAME(VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL);
    ENUM_NAME(VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL);
    ENUM_NAME(VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL);
    ENUM_NAME(VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL);
    ENUM_NAME(VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL);
    ENUM_NAME(VK_IMAGE_LAYOUT_PREINITIALIZED);
    ENUM_NAME(VK_IMAGE_LAYOUT_PRESENT_SRC_KHR);
    ENUM_NAME(VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkImageViewType e) {
  switch (e) {
    ENUM_NAME(VK_IMAGE_VIEW_TYPE_1D);
    ENUM_NAME(VK_IMAGE_VIEW_TYPE_2D);
    ENUM_NAME(VK_IMAGE_VIEW_TYPE_3D);
    ENUM_NAME(VK_IMAGE_VIEW_TYPE_CUBE);
    ENUM_NAME(VK_IMAGE_VIEW_TYPE_1D_ARRAY);
    ENUM_NAME(VK_IMAGE_VIEW_TYPE_2D_ARRAY);
    ENUM_NAME(VK_IMAGE_VIEW_TYPE_CUBE_ARRAY);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkPresentModeKHR e) {
  switch (e) {
    ENUM_NAME(VK_PRESENT_MODE_IMMEDIATE_KHR);
    ENUM_NAME(VK_PRESENT_MODE_MAILBOX_KHR);
    ENUM_NAME(VK_PRESENT_MODE_FIFO_KHR);
    ENUM_NAME(VK_PRESENT_MODE_FIFO_RELAXED_KHR);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkColorSpaceKHR e) {
  switch (e) {
    ENUM_NAME(VK_COLOR_SPACE_SRGB_NONLINEAR_KHR);
    ENUM_DEFAULT(e);
  }
  return os;
}


std::ostream& operator << (std::ostream& os, VkOffset2D e) {
  return os << "(" << e.x << "," << e.y << ")";
}


std::ostream& operator << (std::ostream& os, VkOffset3D e) {
  return os << "(" << e.x << "," << e.y << "," << e.z << ")";
}


std::ostream& operator << (std::ostream& os, VkExtent2D e) {
  return os << "(" << e.width << "," << e.height << ")";
}


std::ostream& operator << (std::ostream& os, VkExtent3D e) {
  return os << "(" << e.width << "," << e.height << "," << e.depth << ")";
}
