// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/api/expr/v1alpha1/value.proto

package expr

import (
	bytes "bytes"
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Represents a CEL value.
//
// This is similar to `google.protobuf.Value`, but can represent CEL's full
// range of values.
type Value struct {
	// Required. The valid kinds of values.
	//
	// Types that are valid to be assigned to Kind:
	//	*Value_NullValue
	//	*Value_BoolValue
	//	*Value_Int64Value
	//	*Value_Uint64Value
	//	*Value_DoubleValue
	//	*Value_StringValue
	//	*Value_BytesValue
	//	*Value_EnumValue
	//	*Value_ObjectValue
	//	*Value_MapValue
	//	*Value_ListValue
	//	*Value_TypeValue
	Kind                 isValue_Kind `protobuf_oneof:"kind"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Value) Reset()      { *m = Value{} }
func (*Value) ProtoMessage() {}
func (*Value) Descriptor() ([]byte, []int) {
	return fileDescriptor_24bee359d1e5798a, []int{0}
}
func (m *Value) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Value) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Value.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Value) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Value.Merge(m, src)
}
func (m *Value) XXX_Size() int {
	return m.Size()
}
func (m *Value) XXX_DiscardUnknown() {
	xxx_messageInfo_Value.DiscardUnknown(m)
}

var xxx_messageInfo_Value proto.InternalMessageInfo

type isValue_Kind interface {
	isValue_Kind()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Value_NullValue struct {
	NullValue types.NullValue `protobuf:"varint,1,opt,name=null_value,json=nullValue,proto3,enum=google.protobuf.NullValue,oneof" json:"null_value,omitempty"`
}
type Value_BoolValue struct {
	BoolValue bool `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3,oneof" json:"bool_value,omitempty"`
}
type Value_Int64Value struct {
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof" json:"int64_value,omitempty"`
}
type Value_Uint64Value struct {
	Uint64Value uint64 `protobuf:"varint,4,opt,name=uint64_value,json=uint64Value,proto3,oneof" json:"uint64_value,omitempty"`
}
type Value_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,5,opt,name=double_value,json=doubleValue,proto3,oneof" json:"double_value,omitempty"`
}
type Value_StringValue struct {
	StringValue string `protobuf:"bytes,6,opt,name=string_value,json=stringValue,proto3,oneof" json:"string_value,omitempty"`
}
type Value_BytesValue struct {
	BytesValue []byte `protobuf:"bytes,7,opt,name=bytes_value,json=bytesValue,proto3,oneof" json:"bytes_value,omitempty"`
}
type Value_EnumValue struct {
	EnumValue *EnumValue `protobuf:"bytes,9,opt,name=enum_value,json=enumValue,proto3,oneof" json:"enum_value,omitempty"`
}
type Value_ObjectValue struct {
	ObjectValue *types.Any `protobuf:"bytes,10,opt,name=object_value,json=objectValue,proto3,oneof" json:"object_value,omitempty"`
}
type Value_MapValue struct {
	MapValue *MapValue `protobuf:"bytes,11,opt,name=map_value,json=mapValue,proto3,oneof" json:"map_value,omitempty"`
}
type Value_ListValue struct {
	ListValue *ListValue `protobuf:"bytes,12,opt,name=list_value,json=listValue,proto3,oneof" json:"list_value,omitempty"`
}
type Value_TypeValue struct {
	TypeValue string `protobuf:"bytes,15,opt,name=type_value,json=typeValue,proto3,oneof" json:"type_value,omitempty"`
}

func (*Value_NullValue) isValue_Kind()   {}
func (*Value_BoolValue) isValue_Kind()   {}
func (*Value_Int64Value) isValue_Kind()  {}
func (*Value_Uint64Value) isValue_Kind() {}
func (*Value_DoubleValue) isValue_Kind() {}
func (*Value_StringValue) isValue_Kind() {}
func (*Value_BytesValue) isValue_Kind()  {}
func (*Value_EnumValue) isValue_Kind()   {}
func (*Value_ObjectValue) isValue_Kind() {}
func (*Value_MapValue) isValue_Kind()    {}
func (*Value_ListValue) isValue_Kind()   {}
func (*Value_TypeValue) isValue_Kind()   {}

func (m *Value) GetKind() isValue_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (m *Value) GetNullValue() types.NullValue {
	if x, ok := m.GetKind().(*Value_NullValue); ok {
		return x.NullValue
	}
	return types.NullValue_NULL_VALUE
}

func (m *Value) GetBoolValue() bool {
	if x, ok := m.GetKind().(*Value_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *Value) GetInt64Value() int64 {
	if x, ok := m.GetKind().(*Value_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *Value) GetUint64Value() uint64 {
	if x, ok := m.GetKind().(*Value_Uint64Value); ok {
		return x.Uint64Value
	}
	return 0
}

func (m *Value) GetDoubleValue() float64 {
	if x, ok := m.GetKind().(*Value_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Value) GetStringValue() string {
	if x, ok := m.GetKind().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Value) GetBytesValue() []byte {
	if x, ok := m.GetKind().(*Value_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

func (m *Value) GetEnumValue() *EnumValue {
	if x, ok := m.GetKind().(*Value_EnumValue); ok {
		return x.EnumValue
	}
	return nil
}

func (m *Value) GetObjectValue() *types.Any {
	if x, ok := m.GetKind().(*Value_ObjectValue); ok {
		return x.ObjectValue
	}
	return nil
}

func (m *Value) GetMapValue() *MapValue {
	if x, ok := m.GetKind().(*Value_MapValue); ok {
		return x.MapValue
	}
	return nil
}

func (m *Value) GetListValue() *ListValue {
	if x, ok := m.GetKind().(*Value_ListValue); ok {
		return x.ListValue
	}
	return nil
}

func (m *Value) GetTypeValue() string {
	if x, ok := m.GetKind().(*Value_TypeValue); ok {
		return x.TypeValue
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Value) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Value_NullValue)(nil),
		(*Value_BoolValue)(nil),
		(*Value_Int64Value)(nil),
		(*Value_Uint64Value)(nil),
		(*Value_DoubleValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_BytesValue)(nil),
		(*Value_EnumValue)(nil),
		(*Value_ObjectValue)(nil),
		(*Value_MapValue)(nil),
		(*Value_ListValue)(nil),
		(*Value_TypeValue)(nil),
	}
}

func (*Value) XXX_MessageName() string {
	return "google.api.expr.v1alpha1.Value"
}

// An enum value.
type EnumValue struct {
	// The fully qualified name of the enum type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The value of the enum.
	Value                int32    `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnumValue) Reset()      { *m = EnumValue{} }
func (*EnumValue) ProtoMessage() {}
func (*EnumValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_24bee359d1e5798a, []int{1}
}
func (m *EnumValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnumValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnumValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnumValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnumValue.Merge(m, src)
}
func (m *EnumValue) XXX_Size() int {
	return m.Size()
}
func (m *EnumValue) XXX_DiscardUnknown() {
	xxx_messageInfo_EnumValue.DiscardUnknown(m)
}

var xxx_messageInfo_EnumValue proto.InternalMessageInfo

func (m *EnumValue) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *EnumValue) GetValue() int32 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (*EnumValue) XXX_MessageName() string {
	return "google.api.expr.v1alpha1.EnumValue"
}

// A list.
//
// Wrapped in a message so 'not set' and empty can be differentiated, which is
// required for use in a 'oneof'.
type ListValue struct {
	// The ordered values in the list.
	Values               []*Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListValue) Reset()      { *m = ListValue{} }
func (*ListValue) ProtoMessage() {}
func (*ListValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_24bee359d1e5798a, []int{2}
}
func (m *ListValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListValue.Merge(m, src)
}
func (m *ListValue) XXX_Size() int {
	return m.Size()
}
func (m *ListValue) XXX_DiscardUnknown() {
	xxx_messageInfo_ListValue.DiscardUnknown(m)
}

var xxx_messageInfo_ListValue proto.InternalMessageInfo

func (m *ListValue) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

func (*ListValue) XXX_MessageName() string {
	return "google.api.expr.v1alpha1.ListValue"
}

// A map.
//
// Wrapped in a message so 'not set' and empty can be differentiated, which is
// required for use in a 'oneof'.
type MapValue struct {
	// The set of map entries.
	//
	// CEL has fewer restrictions on keys, so a protobuf map represenation
	// cannot be used.
	Entries              []*MapValue_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MapValue) Reset()      { *m = MapValue{} }
func (*MapValue) ProtoMessage() {}
func (*MapValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_24bee359d1e5798a, []int{3}
}
func (m *MapValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MapValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MapValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MapValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MapValue.Merge(m, src)
}
func (m *MapValue) XXX_Size() int {
	return m.Size()
}
func (m *MapValue) XXX_DiscardUnknown() {
	xxx_messageInfo_MapValue.DiscardUnknown(m)
}

var xxx_messageInfo_MapValue proto.InternalMessageInfo

func (m *MapValue) GetEntries() []*MapValue_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (*MapValue) XXX_MessageName() string {
	return "google.api.expr.v1alpha1.MapValue"
}

// An entry in the map.
type MapValue_Entry struct {
	// The key.
	//
	// Must be unique with in the map.
	// Currently only boolean, int, uint, and string values can be keys.
	Key *Value `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value.
	Value                *Value   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MapValue_Entry) Reset()      { *m = MapValue_Entry{} }
func (*MapValue_Entry) ProtoMessage() {}
func (*MapValue_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_24bee359d1e5798a, []int{3, 0}
}
func (m *MapValue_Entry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MapValue_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MapValue_Entry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MapValue_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MapValue_Entry.Merge(m, src)
}
func (m *MapValue_Entry) XXX_Size() int {
	return m.Size()
}
func (m *MapValue_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_MapValue_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_MapValue_Entry proto.InternalMessageInfo

func (m *MapValue_Entry) GetKey() *Value {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *MapValue_Entry) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (*MapValue_Entry) XXX_MessageName() string {
	return "google.api.expr.v1alpha1.MapValue.Entry"
}
func init() {
	proto.RegisterType((*Value)(nil), "google.api.expr.v1alpha1.Value")
	proto.RegisterType((*EnumValue)(nil), "google.api.expr.v1alpha1.EnumValue")
	proto.RegisterType((*ListValue)(nil), "google.api.expr.v1alpha1.ListValue")
	proto.RegisterType((*MapValue)(nil), "google.api.expr.v1alpha1.MapValue")
	proto.RegisterType((*MapValue_Entry)(nil), "google.api.expr.v1alpha1.MapValue.Entry")
}

func init() {
	proto.RegisterFile("google/api/expr/v1alpha1/value.proto", fileDescriptor_24bee359d1e5798a)
}

var fileDescriptor_24bee359d1e5798a = []byte{
	// 541 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0x3d, 0x6f, 0xd3, 0x50,
	0x14, 0x86, 0x73, 0x88, 0x93, 0xd6, 0x27, 0x11, 0x48, 0x57, 0x1d, 0x42, 0x54, 0xb9, 0x26, 0x65,
	0xf0, 0xe4, 0x28, 0x81, 0x82, 0x10, 0x53, 0xa3, 0x56, 0xca, 0x00, 0xa8, 0xf2, 0xc0, 0xc0, 0x82,
	0xec, 0xd4, 0x04, 0x53, 0xe7, 0xda, 0xd8, 0xf7, 0x56, 0x78, 0xe3, 0xe7, 0xf0, 0x37, 0xd8, 0x58,
	0x90, 0x18, 0x19, 0x89, 0x59, 0x18, 0x3b, 0x76, 0x44, 0xf7, 0xcb, 0x14, 0x50, 0xd4, 0x6e, 0x3e,
	0xef, 0x7d, 0xde, 0xf3, 0xe5, 0x83, 0xf7, 0x97, 0x59, 0xb6, 0x4c, 0xe3, 0x71, 0x98, 0x27, 0xe3,
	0xf8, 0x43, 0x5e, 0x8c, 0xcf, 0x27, 0x61, 0x9a, 0xbf, 0x0d, 0x27, 0xe3, 0xf3, 0x30, 0xe5, 0xb1,
	0x9f, 0x17, 0x19, 0xcb, 0xc8, 0x40, 0x51, 0x7e, 0x98, 0x27, 0xbe, 0xa0, 0x7c, 0x43, 0x0d, 0xef,
	0x6a, 0xbf, 0xe4, 0x22, 0xfe, 0x66, 0x1c, 0xd2, 0x4a, 0x99, 0x86, 0xbb, 0xff, 0x3e, 0x95, 0xac,
	0xe0, 0x0b, 0xa6, 0x5e, 0x47, 0x5f, 0x2d, 0xec, 0xbc, 0x14, 0x25, 0xc8, 0x53, 0x44, 0xca, 0xd3,
	0xf4, 0xb5, 0x2c, 0x38, 0x00, 0x17, 0xbc, 0xdb, 0xd3, 0xa1, 0xaf, 0x2b, 0x1a, 0xb3, 0xff, 0x82,
	0xa7, 0xa9, 0xe4, 0xe7, 0xad, 0xc0, 0xa6, 0x26, 0x20, 0x7b, 0x88, 0x51, 0x96, 0x19, 0xf3, 0x2d,
	0x17, 0xbc, 0x6d, 0x01, 0x08, 0x4d, 0x01, 0xf7, 0xb0, 0x97, 0x50, 0xf6, 0xe8, 0xa1, 0x26, 0xda,
	0x2e, 0x78, 0xed, 0x79, 0x2b, 0x40, 0x29, 0x2a, 0x64, 0x1f, 0xfb, 0xfc, 0x2a, 0x63, 0xb9, 0xe0,
	0x59, 0xf3, 0x56, 0xd0, 0xe3, 0x7f, 0x43, 0xa7, 0x19, 0x8f, 0xd2, 0x58, 0x43, 0x1d, 0x17, 0x3c,
	0x10, 0x90, 0x52, 0x1b, 0xa8, 0x64, 0x45, 0x42, 0x97, 0x1a, 0xea, 0xba, 0xe0, 0xd9, 0x02, 0x52,
	0x6a, 0xd3, 0x51, 0x54, 0xb1, 0xb8, 0xd4, 0xcc, 0x96, 0x0b, 0x5e, 0x5f, 0x74, 0x24, 0x45, 0x85,
	0x1c, 0x21, 0xc6, 0x94, 0xaf, 0x34, 0x61, 0xbb, 0xe0, 0xf5, 0xa6, 0xfb, 0xfe, 0xa6, 0x9f, 0xe0,
	0x1f, 0x53, 0xbe, 0x6a, 0x76, 0x13, 0x9b, 0x80, 0x3c, 0xc1, 0x7e, 0x16, 0xbd, 0x8b, 0x17, 0x4c,
	0xe7, 0x41, 0x99, 0x67, 0xe7, 0xbf, 0xd5, 0x1e, 0xd2, 0x4a, 0xf4, 0xa8, 0x58, 0x65, 0x3d, 0x44,
	0x7b, 0x15, 0xe6, 0xda, 0xd7, 0x93, 0xbe, 0xd1, 0xe6, 0xfa, 0xcf, 0xc3, 0xdc, 0x94, 0xdf, 0x5e,
	0xe9, 0x6f, 0x31, 0x43, 0x9a, 0x94, 0xa6, 0x76, 0xff, 0xba, 0x19, 0x9e, 0x25, 0x25, 0x6b, 0x66,
	0x48, 0x4d, 0x20, 0xfe, 0x2f, 0xab, 0x72, 0xb3, 0xf4, 0x3b, 0x7a, 0x9f, 0xb6, 0xd0, 0x24, 0x30,
	0xeb, 0xa2, 0x75, 0x96, 0xd0, 0xd3, 0xd1, 0x01, 0xda, 0xcd, 0x1a, 0x08, 0x41, 0x4b, 0x10, 0xf2,
	0x98, 0xec, 0x40, 0x7e, 0x93, 0x1d, 0xec, 0xfc, 0x39, 0x92, 0x4e, 0xa0, 0x82, 0xd1, 0x11, 0xda,
	0x4d, 0x65, 0xf2, 0x18, 0xbb, 0x52, 0x2d, 0x07, 0xe0, 0xb6, 0xbd, 0xde, 0x74, 0x6f, 0x73, 0xbb,
	0xd2, 0x10, 0x68, 0x7c, 0xf4, 0x19, 0x70, 0xdb, 0x2c, 0x81, 0xcc, 0x70, 0x2b, 0xa6, 0xac, 0x48,
	0x9a, 0x34, 0xde, 0xf5, 0x9b, 0xf3, 0x8f, 0x29, 0x2b, 0xaa, 0xc0, 0x18, 0x87, 0xef, 0xb1, 0x23,
	0x15, 0x32, 0xc1, 0xf6, 0x59, 0x5c, 0xc9, 0x41, 0x6e, 0xd0, 0x8f, 0x60, 0xc9, 0xc1, 0xd5, 0x41,
	0x6f, 0x60, 0x52, 0xf4, 0x2c, 0xfc, 0xbe, 0x76, 0x5a, 0x17, 0x6b, 0x07, 0x2e, 0xd7, 0x0e, 0x7c,
	0xac, 0x1d, 0xf8, 0x54, 0x3b, 0xf0, 0xa5, 0x76, 0xe0, 0x5b, 0xed, 0xc0, 0x8f, 0xda, 0x81, 0x5f,
	0xb5, 0xd3, 0xba, 0x10, 0xda, 0x4f, 0x07, 0x70, 0x77, 0x91, 0xad, 0x36, 0x26, 0x9e, 0xa1, 0xcc,
	0x7c, 0x22, 0x0e, 0xec, 0x04, 0x5e, 0x59, 0xe2, 0xf1, 0x12, 0x20, 0xea, 0xca, 0x93, 0x7b, 0xf0,
	0x3b, 0x00, 0x00, 0xff, 0xff, 0xb0, 0xf9, 0x74, 0x3d, 0x75, 0x04, 0x00, 0x00,
}

func (this *Value) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value)
	if !ok {
		that2, ok := that.(Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Kind == nil {
		if this.Kind != nil {
			return false
		}
	} else if this.Kind == nil {
		return false
	} else if !this.Kind.Equal(that1.Kind) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_NullValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_NullValue)
	if !ok {
		that2, ok := that.(Value_NullValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NullValue != that1.NullValue {
		return false
	}
	return true
}
func (this *Value_BoolValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_BoolValue)
	if !ok {
		that2, ok := that.(Value_BoolValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BoolValue != that1.BoolValue {
		return false
	}
	return true
}
func (this *Value_Int64Value) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_Int64Value)
	if !ok {
		that2, ok := that.(Value_Int64Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Int64Value != that1.Int64Value {
		return false
	}
	return true
}
func (this *Value_Uint64Value) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_Uint64Value)
	if !ok {
		that2, ok := that.(Value_Uint64Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Uint64Value != that1.Uint64Value {
		return false
	}
	return true
}
func (this *Value_DoubleValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_DoubleValue)
	if !ok {
		that2, ok := that.(Value_DoubleValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.DoubleValue != that1.DoubleValue {
		return false
	}
	return true
}
func (this *Value_StringValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_StringValue)
	if !ok {
		that2, ok := that.(Value_StringValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StringValue != that1.StringValue {
		return false
	}
	return true
}
func (this *Value_BytesValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_BytesValue)
	if !ok {
		that2, ok := that.(Value_BytesValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.BytesValue, that1.BytesValue) {
		return false
	}
	return true
}
func (this *Value_EnumValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_EnumValue)
	if !ok {
		that2, ok := that.(Value_EnumValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EnumValue.Equal(that1.EnumValue) {
		return false
	}
	return true
}
func (this *Value_ObjectValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_ObjectValue)
	if !ok {
		that2, ok := that.(Value_ObjectValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ObjectValue.Equal(that1.ObjectValue) {
		return false
	}
	return true
}
func (this *Value_MapValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_MapValue)
	if !ok {
		that2, ok := that.(Value_MapValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MapValue.Equal(that1.MapValue) {
		return false
	}
	return true
}
func (this *Value_ListValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_ListValue)
	if !ok {
		that2, ok := that.(Value_ListValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ListValue.Equal(that1.ListValue) {
		return false
	}
	return true
}
func (this *Value_TypeValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value_TypeValue)
	if !ok {
		that2, ok := that.(Value_TypeValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TypeValue != that1.TypeValue {
		return false
	}
	return true
}
func (this *EnumValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EnumValue)
	if !ok {
		that2, ok := that.(EnumValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ListValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListValue)
	if !ok {
		that2, ok := that.(ListValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if !this.Values[i].Equal(that1.Values[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MapValue) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MapValue)
	if !ok {
		that2, ok := that.(MapValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Entries) != len(that1.Entries) {
		return false
	}
	for i := range this.Entries {
		if !this.Entries[i].Equal(that1.Entries[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MapValue_Entry) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MapValue_Entry)
	if !ok {
		that2, ok := that.(MapValue_Entry)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Key.Equal(that1.Key) {
		return false
	}
	if !this.Value.Equal(that1.Value) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&expr.Value{")
	if this.Kind != nil {
		s = append(s, "Kind: "+fmt.Sprintf("%#v", this.Kind)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_NullValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_NullValue{` +
		`NullValue:` + fmt.Sprintf("%#v", this.NullValue) + `}`}, ", ")
	return s
}
func (this *Value_BoolValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_BoolValue{` +
		`BoolValue:` + fmt.Sprintf("%#v", this.BoolValue) + `}`}, ", ")
	return s
}
func (this *Value_Int64Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_Int64Value{` +
		`Int64Value:` + fmt.Sprintf("%#v", this.Int64Value) + `}`}, ", ")
	return s
}
func (this *Value_Uint64Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_Uint64Value{` +
		`Uint64Value:` + fmt.Sprintf("%#v", this.Uint64Value) + `}`}, ", ")
	return s
}
func (this *Value_DoubleValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_DoubleValue{` +
		`DoubleValue:` + fmt.Sprintf("%#v", this.DoubleValue) + `}`}, ", ")
	return s
}
func (this *Value_StringValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_StringValue{` +
		`StringValue:` + fmt.Sprintf("%#v", this.StringValue) + `}`}, ", ")
	return s
}
func (this *Value_BytesValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_BytesValue{` +
		`BytesValue:` + fmt.Sprintf("%#v", this.BytesValue) + `}`}, ", ")
	return s
}
func (this *Value_EnumValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_EnumValue{` +
		`EnumValue:` + fmt.Sprintf("%#v", this.EnumValue) + `}`}, ", ")
	return s
}
func (this *Value_ObjectValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_ObjectValue{` +
		`ObjectValue:` + fmt.Sprintf("%#v", this.ObjectValue) + `}`}, ", ")
	return s
}
func (this *Value_MapValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_MapValue{` +
		`MapValue:` + fmt.Sprintf("%#v", this.MapValue) + `}`}, ", ")
	return s
}
func (this *Value_ListValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_ListValue{` +
		`ListValue:` + fmt.Sprintf("%#v", this.ListValue) + `}`}, ", ")
	return s
}
func (this *Value_TypeValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&expr.Value_TypeValue{` +
		`TypeValue:` + fmt.Sprintf("%#v", this.TypeValue) + `}`}, ", ")
	return s
}
func (this *EnumValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&expr.EnumValue{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&expr.ListValue{")
	if this.Values != nil {
		s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MapValue) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&expr.MapValue{")
	if this.Entries != nil {
		s = append(s, "Entries: "+fmt.Sprintf("%#v", this.Entries)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MapValue_Entry) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&expr.MapValue_Entry{")
	if this.Key != nil {
		s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringValue(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Kind != nil {
		{
			size := m.Kind.Size()
			i -= size
			if _, err := m.Kind.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Value_NullValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_NullValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintValue(dAtA, i, uint64(m.NullValue))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *Value_BoolValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_BoolValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.BoolValue {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x10
	return len(dAtA) - i, nil
}
func (m *Value_Int64Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_Int64Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintValue(dAtA, i, uint64(m.Int64Value))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *Value_Uint64Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_Uint64Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintValue(dAtA, i, uint64(m.Uint64Value))
	i--
	dAtA[i] = 0x20
	return len(dAtA) - i, nil
}
func (m *Value_DoubleValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_DoubleValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DoubleValue))))
	i--
	dAtA[i] = 0x29
	return len(dAtA) - i, nil
}
func (m *Value_StringValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_StringValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.StringValue)
	copy(dAtA[i:], m.StringValue)
	i = encodeVarintValue(dAtA, i, uint64(len(m.StringValue)))
	i--
	dAtA[i] = 0x32
	return len(dAtA) - i, nil
}
func (m *Value_BytesValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_BytesValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.BytesValue != nil {
		i -= len(m.BytesValue)
		copy(dAtA[i:], m.BytesValue)
		i = encodeVarintValue(dAtA, i, uint64(len(m.BytesValue)))
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Value_EnumValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_EnumValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.EnumValue != nil {
		{
			size, err := m.EnumValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintValue(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *Value_ObjectValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_ObjectValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ObjectValue != nil {
		{
			size, err := m.ObjectValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintValue(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *Value_MapValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_MapValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MapValue != nil {
		{
			size, err := m.MapValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintValue(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *Value_ListValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_ListValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ListValue != nil {
		{
			size, err := m.ListValue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintValue(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	return len(dAtA) - i, nil
}
func (m *Value_TypeValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Value_TypeValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.TypeValue)
	copy(dAtA[i:], m.TypeValue)
	i = encodeVarintValue(dAtA, i, uint64(len(m.TypeValue)))
	i--
	dAtA[i] = 0x7a
	return len(dAtA) - i, nil
}
func (m *EnumValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnumValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnumValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != 0 {
		i = encodeVarintValue(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintValue(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Values[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintValue(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *MapValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MapValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MapValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Entries) > 0 {
		for iNdEx := len(m.Entries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Entries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintValue(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *MapValue_Entry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MapValue_Entry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MapValue_Entry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintValue(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Key != nil {
		{
			size, err := m.Key.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintValue(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintValue(dAtA []byte, offset int, v uint64) int {
	offset -= sovValue(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedValue(r randyValue, easy bool) *Value {
	this := &Value{}
	oneofNumber_Kind := []int32{1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 15}[r.Intn(12)]
	switch oneofNumber_Kind {
	case 1:
		this.Kind = NewPopulatedValue_NullValue(r, easy)
	case 2:
		this.Kind = NewPopulatedValue_BoolValue(r, easy)
	case 3:
		this.Kind = NewPopulatedValue_Int64Value(r, easy)
	case 4:
		this.Kind = NewPopulatedValue_Uint64Value(r, easy)
	case 5:
		this.Kind = NewPopulatedValue_DoubleValue(r, easy)
	case 6:
		this.Kind = NewPopulatedValue_StringValue(r, easy)
	case 7:
		this.Kind = NewPopulatedValue_BytesValue(r, easy)
	case 9:
		this.Kind = NewPopulatedValue_EnumValue(r, easy)
	case 10:
		this.Kind = NewPopulatedValue_ObjectValue(r, easy)
	case 11:
		this.Kind = NewPopulatedValue_MapValue(r, easy)
	case 12:
		this.Kind = NewPopulatedValue_ListValue(r, easy)
	case 15:
		this.Kind = NewPopulatedValue_TypeValue(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedValue(r, 16)
	}
	return this
}

func NewPopulatedValue_NullValue(r randyValue, easy bool) *Value_NullValue {
	this := &Value_NullValue{}
	this.NullValue = types.NullValue([]int32{0}[r.Intn(1)])
	return this
}
func NewPopulatedValue_BoolValue(r randyValue, easy bool) *Value_BoolValue {
	this := &Value_BoolValue{}
	this.BoolValue = bool(bool(r.Intn(2) == 0))
	return this
}
func NewPopulatedValue_Int64Value(r randyValue, easy bool) *Value_Int64Value {
	this := &Value_Int64Value{}
	this.Int64Value = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Int64Value *= -1
	}
	return this
}
func NewPopulatedValue_Uint64Value(r randyValue, easy bool) *Value_Uint64Value {
	this := &Value_Uint64Value{}
	this.Uint64Value = uint64(uint64(r.Uint32()))
	return this
}
func NewPopulatedValue_DoubleValue(r randyValue, easy bool) *Value_DoubleValue {
	this := &Value_DoubleValue{}
	this.DoubleValue = float64(r.Float64())
	if r.Intn(2) == 0 {
		this.DoubleValue *= -1
	}
	return this
}
func NewPopulatedValue_StringValue(r randyValue, easy bool) *Value_StringValue {
	this := &Value_StringValue{}
	this.StringValue = string(randStringValue(r))
	return this
}
func NewPopulatedValue_BytesValue(r randyValue, easy bool) *Value_BytesValue {
	this := &Value_BytesValue{}
	v1 := r.Intn(100)
	this.BytesValue = make([]byte, v1)
	for i := 0; i < v1; i++ {
		this.BytesValue[i] = byte(r.Intn(256))
	}
	return this
}
func NewPopulatedValue_EnumValue(r randyValue, easy bool) *Value_EnumValue {
	this := &Value_EnumValue{}
	this.EnumValue = NewPopulatedEnumValue(r, easy)
	return this
}
func NewPopulatedValue_ObjectValue(r randyValue, easy bool) *Value_ObjectValue {
	this := &Value_ObjectValue{}
	this.ObjectValue = types.NewPopulatedAny(r, easy)
	return this
}
func NewPopulatedValue_MapValue(r randyValue, easy bool) *Value_MapValue {
	this := &Value_MapValue{}
	this.MapValue = NewPopulatedMapValue(r, easy)
	return this
}
func NewPopulatedValue_ListValue(r randyValue, easy bool) *Value_ListValue {
	this := &Value_ListValue{}
	this.ListValue = NewPopulatedListValue(r, easy)
	return this
}
func NewPopulatedValue_TypeValue(r randyValue, easy bool) *Value_TypeValue {
	this := &Value_TypeValue{}
	this.TypeValue = string(randStringValue(r))
	return this
}
func NewPopulatedEnumValue(r randyValue, easy bool) *EnumValue {
	this := &EnumValue{}
	this.Type = string(randStringValue(r))
	this.Value = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Value *= -1
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedValue(r, 3)
	}
	return this
}

func NewPopulatedListValue(r randyValue, easy bool) *ListValue {
	this := &ListValue{}
	if r.Intn(5) == 0 {
		v2 := r.Intn(5)
		this.Values = make([]*Value, v2)
		for i := 0; i < v2; i++ {
			this.Values[i] = NewPopulatedValue(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedValue(r, 2)
	}
	return this
}

func NewPopulatedMapValue(r randyValue, easy bool) *MapValue {
	this := &MapValue{}
	if r.Intn(5) == 0 {
		v3 := r.Intn(5)
		this.Entries = make([]*MapValue_Entry, v3)
		for i := 0; i < v3; i++ {
			this.Entries[i] = NewPopulatedMapValue_Entry(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedValue(r, 2)
	}
	return this
}

func NewPopulatedMapValue_Entry(r randyValue, easy bool) *MapValue_Entry {
	this := &MapValue_Entry{}
	if r.Intn(5) == 0 {
		this.Key = NewPopulatedValue(r, easy)
	}
	if r.Intn(5) == 0 {
		this.Value = NewPopulatedValue(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedValue(r, 3)
	}
	return this
}

type randyValue interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneValue(r randyValue) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringValue(r randyValue) string {
	v4 := r.Intn(100)
	tmps := make([]rune, v4)
	for i := 0; i < v4; i++ {
		tmps[i] = randUTF8RuneValue(r)
	}
	return string(tmps)
}
func randUnrecognizedValue(r randyValue, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldValue(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldValue(dAtA []byte, r randyValue, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateValue(dAtA, uint64(key))
		v5 := r.Int63()
		if r.Intn(2) == 0 {
			v5 *= -1
		}
		dAtA = encodeVarintPopulateValue(dAtA, uint64(v5))
	case 1:
		dAtA = encodeVarintPopulateValue(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateValue(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateValue(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateValue(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateValue(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Kind != nil {
		n += m.Kind.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_NullValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovValue(uint64(m.NullValue))
	return n
}
func (m *Value_BoolValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *Value_Int64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovValue(uint64(m.Int64Value))
	return n
}
func (m *Value_Uint64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovValue(uint64(m.Uint64Value))
	return n
}
func (m *Value_DoubleValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *Value_StringValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StringValue)
	n += 1 + l + sovValue(uint64(l))
	return n
}
func (m *Value_BytesValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BytesValue != nil {
		l = len(m.BytesValue)
		n += 1 + l + sovValue(uint64(l))
	}
	return n
}
func (m *Value_EnumValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EnumValue != nil {
		l = m.EnumValue.Size()
		n += 1 + l + sovValue(uint64(l))
	}
	return n
}
func (m *Value_ObjectValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ObjectValue != nil {
		l = m.ObjectValue.Size()
		n += 1 + l + sovValue(uint64(l))
	}
	return n
}
func (m *Value_MapValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MapValue != nil {
		l = m.MapValue.Size()
		n += 1 + l + sovValue(uint64(l))
	}
	return n
}
func (m *Value_ListValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ListValue != nil {
		l = m.ListValue.Size()
		n += 1 + l + sovValue(uint64(l))
	}
	return n
}
func (m *Value_TypeValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TypeValue)
	n += 1 + l + sovValue(uint64(l))
	return n
}
func (m *EnumValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovValue(uint64(l))
	}
	if m.Value != 0 {
		n += 1 + sovValue(uint64(m.Value))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, e := range m.Values {
			l = e.Size()
			n += 1 + l + sovValue(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MapValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovValue(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MapValue_Entry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = m.Key.Size()
		n += 1 + l + sovValue(uint64(l))
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovValue(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovValue(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozValue(x uint64) (n int) {
	return sovValue(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_NullValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_NullValue{`,
		`NullValue:` + fmt.Sprintf("%v", this.NullValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_BoolValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_BoolValue{`,
		`BoolValue:` + fmt.Sprintf("%v", this.BoolValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Int64Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Int64Value{`,
		`Int64Value:` + fmt.Sprintf("%v", this.Int64Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Uint64Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Uint64Value{`,
		`Uint64Value:` + fmt.Sprintf("%v", this.Uint64Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_DoubleValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_DoubleValue{`,
		`DoubleValue:` + fmt.Sprintf("%v", this.DoubleValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_StringValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_StringValue{`,
		`StringValue:` + fmt.Sprintf("%v", this.StringValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_BytesValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_BytesValue{`,
		`BytesValue:` + fmt.Sprintf("%v", this.BytesValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_EnumValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_EnumValue{`,
		`EnumValue:` + strings.Replace(fmt.Sprintf("%v", this.EnumValue), "EnumValue", "EnumValue", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_ObjectValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_ObjectValue{`,
		`ObjectValue:` + strings.Replace(fmt.Sprintf("%v", this.ObjectValue), "Any", "types.Any", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_MapValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_MapValue{`,
		`MapValue:` + strings.Replace(fmt.Sprintf("%v", this.MapValue), "MapValue", "MapValue", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_ListValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_ListValue{`,
		`ListValue:` + strings.Replace(fmt.Sprintf("%v", this.ListValue), "ListValue", "ListValue", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_TypeValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_TypeValue{`,
		`TypeValue:` + fmt.Sprintf("%v", this.TypeValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *EnumValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&EnumValue{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListValue) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForValues := "[]*Value{"
	for _, f := range this.Values {
		repeatedStringForValues += strings.Replace(f.String(), "Value", "Value", 1) + ","
	}
	repeatedStringForValues += "}"
	s := strings.Join([]string{`&ListValue{`,
		`Values:` + repeatedStringForValues + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MapValue) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForEntries := "[]*MapValue_Entry{"
	for _, f := range this.Entries {
		repeatedStringForEntries += strings.Replace(fmt.Sprintf("%v", f), "MapValue_Entry", "MapValue_Entry", 1) + ","
	}
	repeatedStringForEntries += "}"
	s := strings.Join([]string{`&MapValue{`,
		`Entries:` + repeatedStringForEntries + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MapValue_Entry) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MapValue_Entry{`,
		`Key:` + strings.Replace(this.Key.String(), "Value", "Value", 1) + `,`,
		`Value:` + strings.Replace(this.Value.String(), "Value", "Value", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringValue(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowValue
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NullValue", wireType)
			}
			var v types.NullValue
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= types.NullValue(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Kind = &Value_NullValue{v}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Kind = &Value_BoolValue{b}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Value", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Kind = &Value_Int64Value{v}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uint64Value", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Kind = &Value_Uint64Value{v}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Kind = &Value_DoubleValue{float64(math.Float64frombits(v))}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = &Value_StringValue{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Kind = &Value_BytesValue{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnumValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EnumValue{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Kind = &Value_EnumValue{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Kind = &Value_ObjectValue{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MapValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MapValue{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Kind = &Value_MapValue{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ListValue{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Kind = &Value_ListValue{v}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypeValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = &Value_TypeValue{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipValue(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnumValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowValue
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnumValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnumValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipValue(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowValue
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, &Value{})
			if err := m.Values[len(m.Values)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipValue(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MapValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowValue
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MapValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MapValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, &MapValue_Entry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipValue(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MapValue_Entry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowValue
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Entry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Entry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Key == nil {
				m.Key = &Value{}
			}
			if err := m.Key.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowValue
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthValue
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthValue
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipValue(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthValue
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipValue(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowValue
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowValue
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowValue
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthValue
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupValue
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthValue
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthValue        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowValue          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupValue = fmt.Errorf("proto: unexpected end of group")
)
