------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2004-2009, AdaCore                     --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

private package AWS.Services.Split_Pages.Shared is

   Splitter_Error : exception renames Split_Pages.Splitter_Error;

   function Associated_Vector
     (Table : Templates.Translate_Set;
      Key   : String)
      return Templates.Tag;
   --  Returns the composite tag associated with the given key in Table or
   --  raise Splitter_Error if this key does not exist.

   function Safe_URI (URIs : URI_Table; I : Natural) return String;
   --  Returns URIs (I) or the empty string if I not a valid index

end AWS.Services.Split_Pages.Shared;
