/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines the connection component 
 */


#ifndef LLC_CONN_H
#define LLC_CONN_H

/* 
 * Structure for maintaining rx_frames or happend events that occured
 * during processing a request. log_q(in struct connection_t) is a queue 
 * of this structure. 
*/

typedef struct {
   us8                 desc;
   union {
      frame_t             *frame;
      void                *event;
   }obj;
} rx_object_t;


typedef struct
{
   us8                 state;              /* state of connection */
   us8                 send_i_pdu_flag;    /* YES to allow, NO to disallow */
   mph_t               mp_handle;          /* don't accidentally lose this */
   us32                parent_sap;         /* pointer to parent SAP */
   address_t           local_dl_addr;      /* lsap/mac pair */
   address_t           remote_dl_addr;     /* lsap/mac pair */
   void *              local_dev;          /* device to send to remote */
   us8                 retry_count;        /* number of retries */
   void *              ack_timer;          /* ack to I-PDU/rsp to UI PDU */
   us8                 ack_running;        /* ack timer is running or no */

   us8                   ack_must_be_send;
   us8                   first_pdu_Ns;
   us8                   npta;   
   
   void *                pf_cycle_timer;     
   us8                   pf_cycle_running; /* pf cycle timer is running or no */
   
   void *              reject_sent_timer;  /* REJECT timer */
   us8                 reject_sent_running;/* REJ timer is running or no */
   void *              busy_state_timer;   /* ind busy clr at remote LLC */
   us8                 busy_state_running; /* busy timer is running or no */
   us8                 vS;                 /* seq# next in-seq I-PDU tx'd */
   us8                 vR;                 /* seq# next in-seq I-PDU rx'd */
   us32                n2;                 /* max nbr re-tx's for timeout */
   us32                n1;                 /* max nbr octets in I PDU */
   us8                 k;                  /* tx window size; max = 127 */
   us8                 rw;                 /* rx window size; max = 127 */
   us8                 min_U_pdu_len;      /* 3 (bytes) always */
   us8                 min_I_S_pdu_len;    /* 4 (bytes) always */
   us8                 p_flag;             /* state flags */
   us8                 f_flag;
   us8                 s_flag;
   us8                 data_flag;
   us8                 remote_busy_flag;
   us8                 cause_flag;
   dll_t               avail_events;       /* events available for queuing */
   dll_t               event_q;            /* events entering state mach. */
   dll_t               mac_pdu_q;          /* PDUs ready to send to MAC */
   dll_t               pdu_unack_q;        /* PUDs sent/waiting acknowl */
   dll_t               nwk_pdu_q;          /* network layer primitives q */
   us16                link_no;	           /* network layer link number */
   us8                 X;                  /* a temporary variable */
   us8                 busy;               /* llc is processing a request or no */
   dll_t               log_q;              /* 
					    * frames and events(timers) that 
					    * have recieved during processing 
					    * a request 
					    */
   us8                 ack_pf;             /* 
					    * this flag indicates what is the 
					    * P-bit of acknowledge.
                                            */  
   us8                 failed_data_req;    /* 
					    * recognize that already exist a
                                            * failed data_conn_req (tx_buffer_full 
                                            * or unacceptable state 
					    */
   us8                inc_step;
   us8                dec_step;
   us8                inc_cntr;
   us8                dec_cntr;
   us8                connect_step;
   us8                last_nr;		    /* NR of last pdu recieved */
   int                data_ret_val;         /* 
					     * return value of data_req_handler 
					     * function ( defined in llc_if.h 
					     */
   us32               rx_pdu_hdr;           /* 
					     * used for saving header of
				             * last pdu recieved and caused sending
                                             * FRMR. used for resending FRMR 
					     */
} connection_t;


#ifdef LLC_CONN_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_CONN_C */


/* Access to a connection */
EXTRN us16         conn_initialize (connection_t * conn);
EXTRN us16         conn_service (connection_t * conn, void *event);
EXTRN us16         conn_get_event (connection_t * conn, void ** event);
EXTRN us16         conn_send_event (connection_t * conn, void * event);
EXTRN us16         conn_send_pdu (connection_t * conn, frame_t * pdu);
EXTRN us16         conn_rtn_pdu (connection_t * conn, frame_t * pdu, void *event);
EXTRN us16         conn_return_event (connection_t * conn, void *event);

EXTRN us16         conn_resend_i_pdu_as_cmd (connection_t * conn, us8 nr,
                                                          us8 first_p_bit);
EXTRN us16         conn_resend_i_pdu_as_rsp (connection_t * conn, us8 nr,
                                                          us8 first_f_bit);
EXTRN us16         conn_remove_acked_pdus (connection_t * conn, us8 nr,
                                              us16 * how_many_unacked);
EXTRN us16         find_conn (sap_t * sap, address_t * remote_addr, 
                                                        void ** conn_ptr);
EXTRN us8         data_accept_state (us8 state); 
EXTRN void        build_offset_table (void); 
EXTRN us16        find_offset(us16 state, us16 event_type);
EXTRN void        inc_conn_busy(connection_t *conn);
EXTRN void        dec_conn_busy(connection_t *conn);
#undef EXTRN
#endif /* LC_CONN_H */


