/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_pen(), which defines the foreground color.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_pen_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ i_col: the id of the color.
 */
void g2_pen_ctof__(int *id_ad, int *i_col)
{
  /*
   * Local variables:
   * _ i_id_ad, i_i_col: int variables to acquire the arguments.
   */
  int i_id_ad, i_i_col;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  i_i_col = *i_col;
  /*
   * Call the C function with the required arguments.
   */
  g2_pen(i_id_ad, i_i_col);
}
/*
 * Compatibility function for gfortran.
 */
void g2_pen_ctof_(int *id_ad, int *i_col)
{
  g2_pen_ctof__(id_ad, i_col);
}
