/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_set_dash(), which sets the line type to dashed,
 * _ with N dash elements with given lengths.
 *
 * Note that the array of lengths to be passed as an argument
 * _ should be defined within the calling Fortran program as
 * _ a one-index array, such as
 * _
 * _    dimension dle_len(N)
 *
 * OBSERVATION: note that, although these lengths are in real format,
 * _ they have as their units the number of pixels, not coordinate
 * _ units; this looks like a design flaw, because if the lengths are
 * _ meant to be in pixels, then the variables should be in integer
 * _ format; maybe they are meant to be in coordinate units, but are
 * _ not yet completely implemented.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_set_dash_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the declaration of the calloc() function.
 */
#include <stdlib.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad:   the id of the device;
 * _ n_dle:   the number of dash elements;
 * _ dle_len: pointer to an array of N float numbers,
 * _          containing the lengths of the elements
 * _          in the order black, white, black, ...
 * In order to recover the solid line, call the function
 * _ with n_dle set to zero and dle_len set to NULL.
 */
void g2_set_dash_ctof__(int *id_ad,
			int *n_dle,
			float *dle_len)
{
  /*
   * Local variables:
   * _ i_id_ad, i_n_dle: int variables to acquire the arguments;
   * _ ic: an int counter for the "for" loop;
   * _ d_dle_len: a pointer to an array of N double numbers; since
   * _            we do not want to dimension it statically here,
   * _            we declare it simply as a pointer to double.
   */
  int    i_id_ad, i_n_dle, ic;
  double *d_dle_len;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  i_n_dle = *n_dle;
  /*
   * Dimensioning the array dynamically: now that we have the number
   * _ N of dash elements available, we call the calloc() function in
   * _ order to dimension the d_dle_len array, as an array of N double
   * _ numbers; note how calloc() returns the pointer to the array.
   */
  d_dle_len = calloc(i_n_dle, 8);
  /*
   * Pass the data from the array argument
   * _ to the local double array.
   */
  for (ic = 0; ic < i_n_dle; ic++)
    {
      d_dle_len[ic] = dle_len[ic];
    }
  /*
   * Call the C function with the required arguments.
   */
  g2_set_dash(i_id_ad,
	      i_n_dle,
	      d_dle_len);
}
/*
 * Compatibility function for gfortran.
 */
void g2_set_dash_ctof_(int *id_ad,
		       int *n_dle,
		       float *dle_len)
{
  g2_set_dash_ctof__(id_ad,
		     n_dle,
		     dle_len);
}
