/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_set_font_size(), which sets the font size
 * _ to be used.
 *
 * OBSERVATION: note that, although the font size is in real format,
 * _ it has as its units the number of pixels, not coordinate units;
 * _ the pixel unit seems to refer to a typical 100-dpi X11 screen.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_set_font_size_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ f_siz: the font size to be used.
 */
void g2_set_font_size_ctof__(int *id_ad,
			     float *f_siz)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_f_siz: float variable to acquire the argument;
   * _ d_f_siz: double version of the variable above.
   */
  int    i_id_ad;
  float  f_f_siz;
  double d_f_siz;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_f_siz = *f_siz;
  /*
   * Pass the float datum to the double variable.
   */
  d_f_siz = f_f_siz;
  /*
   * Call the C function with the required arguments.
   */
  g2_set_font_size(i_id_ad,
		   d_f_siz);
}
/*
 * Compatibility function for gfortran.
 */
void g2_set_font_size_ctof_(int *id_ad,
			    float *f_siz)
{
  g2_set_font_size_ctof__(id_ad,
			  f_siz);
}
