#!/bin/sh
# JLdL 04Oct07.
# The next line restarts using wish \
exec wish "$0" "$@" 
#
# This is a simple Tcl/Tk program, written as a learning
# _ and development device, with examples of some of the
# _ most useful commands and structures.
#
# Tcl is a programming language, the Tool Command Language;
# _ Tk is a X11 graphical toolkit which provides the Motif
# _ look-and-feel and is implemented using Tcl.
#
# The following Tcl functions are used here:
# _ update:		flush all Tcl buffers;
# _ set:		set a Tcl variable;
# _ exec:		execute an external program;
# _ exit:		terminate the Tcl process;
# _ while:		conditional loop;
# _ vwait:		wait for a variable to be updated;
# _ open:		open a file and define a descriptor;
# _ puts:		write to a file or to stdout;
# _ close:		close a file descriptor.
#
# The following Tk functions are used here:
# _ wm:			contact the window manager;
# _ place:		place a widget within the window;
# _ radiobutton:	build a radio-type widget;
# _ button:		build a button-type widget;
# _ spinbox:		build a spinbox-type widget;
# _ menubutton:		build a menu-type widget;
# _ menu:		define menu entries;
# _ label:		build a label-type widget;
# _ entry:		build an entry-type widget.
#
# The variable EventVar in this program is used for detecting
# _ changes within the major X11 event loop, so as to permit
# _ the refreshing of the output file; this is done by the
# _ infinite while loop at the end of this file; the variable
# _ does not have to be initialized, since any write action
# _ to it will fire the loop, even if the value of the
# _ variable is not actually changed.
#
# Fix the geometry of the main window; "wm" is a Tk function;
# _ the top-level window is represented by "." here; "update"
# _ is a Tcl function; note that two or more commands can be
# _ written in the same line with the usual ";" shell syntax.
wm geometry . 146x303+500+200 ; update
#
# Define a set of radius buttons, with names as "."-separated
# _ paths after the first "."; the set is defined by the use
# _ of the same variable for all of them.
#
# Set a default value for the variable;
# _ "set" is a Tcl function.
set RadioVar 0
#
# Define the buttons; "radiobutton" is a Tk function.
radiobutton .rad0 -text 0 -value 0 -variable RadioVar
radiobutton .rad1 -text 1 -value 1 -variable RadioVar
radiobutton .rad2 -text 2 -value 2 -variable RadioVar
radiobutton .rad3 -text 3 -value 3 -variable RadioVar
radiobutton .rad4 -text 4 -value 4 -variable RadioVar
#
# Place the buttons in certain positions, within boxes of
# _ certain sizes; "place" is a Tk function.
place .rad0 -in . -x 10 -y 10 -width 60 -height 25
place .rad1 -in . -x 10 -y 30 -width 60 -height 25
place .rad2 -in . -x 10 -y 50 -width 60 -height 25
place .rad3 -in . -x 10 -y 70 -width 60 -height 25
place .rad4 -in . -x 10 -y 90 -width 60 -height 25
#
# Define a button in order to execute an external application;
# _ "button" is a Tk function; "exec" is a Tcl function which
# _ allows execution in the context of a shell-like environment;
# _ note the use of the ";" shell syntax within the command;
# _ by setting the variable EventVar right before the execution
# _ of the external program we may ensure that an output file
# _ to be read by it will be updated before it runs.
#
# Note the use of "\" for logical line continuation.
button .but0 -text xmess \
	-command "set EventVar 1 ; exec /usr/bin/X11/xmessage -file tcl-test.dat &"
#
# Place the button.
place .but0 -in . -x 10 -y 120 -width 60 -height 25
#
# Define a button to exit; "exit" is a Tcl function.
button .but1 -text exit -command exit
#
# Place the button.
place .but1 -in . -x 10 -y 150 -width 60 -height 25
#
# Define a spinbox to choose an entry from a list; "spinbox"
# _ is a Tk function; we do not have to initialize the text
# _ variable because by default it is automatically set to
# _ the first element of the list of values.
spinbox .spin0 -textvariable SpinVar \
	-values {pow sin cos exp}
#
# Place the spinbox.
place .spin0 -in . -x 10 -y 180 -width 60 -height 25
#
# Define a menu button to choose an entry from a list.
#
# Set a default value for the variable.
set MenuVar "w = ???(z)"
#
# Define the menu button; "menubutton" is a Tk function.
menubutton .menu0 -menu .menu0.menu -textvariable MenuVar \
	-indicatoron 1 -relief raised -direction flush
#
# Place the menu button.
place .menu0 -in . -x 10 -y 210 -width 125 -height 25
#
# Define the menu for the menu button above;
# _ "menu" is a Tk function.
menu .menu0.menu -tearoff 0
#
# Define the entries for the menu; "add command" is a widget
# _ command, that is, an option within the "menu" widget;
# _ note the use of "\" for quoting; note also that we could
# _ set the variable EventVar within these commands, in order
# _ to update the output file when a menu item is chosen.
.menu0.menu add command -label pow \
	-command "set MenuVar \"w = pow(n,z)\""
.menu0.menu add command -label sin \
	-command "set MenuVar \"w = sin(z)\""
.menu0.menu add command -label cos \
	-command "set MenuVar \"w = cos(z)\""
.menu0.menu add command -label exp \
	-command "set MenuVar \"w = exp(z)\""
#
# Define a label for the entry below;
# _ "label" is a Tk function.
label .label0 -relief raised -text "xmin:"
#
# Place the label.
place .label0 -in . -x 10 -y 240 -width 60 -height 25
#
# Define an entry button, in order to insert numbers;
# _ "entry" is a Tk function.
#
# Note that one could use the command validation structure of
# _ the "entry" widget in order to set the variable EventVar
# _ and hence update the output file when the entry is
# _ changed; the native use of the structure would be
# _ to check the format of the numbers entered.
#
# Set a default value for the variable.
set EntryVar "1.0"
#
# Define the entry widget.
entry .entry0 -background white -textvariable EntryVar
#
# Place the entry widget.
place .entry0 -in . -x 75 -y 240 -width 60 -height 25
#
# Set up a refresh button, that just sets the event loop
# _ variable and hence updates the output file.
button .but2 -text refresh -command "set EventVar 1"
#
# Place the button.
place .but2 -in . -x 10 -y 270 -width 60 -height 25
#
# Enter an infinite loop waiting for the variable EventVar
# _ to be set or changed within the main X11 event loop;
# _ "while" is a Tcl function; "vwait" is a Tcl function;
# _ "puts" is a Tcl function; "open" is a Tcl function;
# _ "close" is a Tcl function.
while {1} {
    #
    # Monitor a variable in the main X11 event loop.
    vwait EventVar
    #
    # Write all the relevant variables to stdout.
    puts -nonewline "RadioVar=$RadioVar "
    puts -nonewline "SpinVar=$SpinVar "
    puts -nonewline "MenuVar=\"$MenuVar\" "
    puts -nonewline "EntryVar=$EntryVar "
    puts ""
    #
    # Write all the relevant variables to a file.
    #
    # Open the file, in overwrite mode; note the shell-style
    # _ execution of the commands within the "[]" brackets;
    # _ this results in the file descriptor being attributed
    # _ to the variable FileChannel.
    set FileChannel [open tcl-test.dat w+]
    #
    # Write lines to the file.
    puts $FileChannel "RadioVar = $RadioVar"
    puts $FileChannel "SpinVar  = $SpinVar"
    puts $FileChannel "MenuVar  = \"$MenuVar\""
    puts $FileChannel "EntryVar = $EntryVar"
    #
    # Close the file.
    close $FileChannel
}
