*     JLdL 29Jan12.
*     
*     Copyright (C) 2007-2012 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine is a Fortran extension of the g2 library; all
*     _ the variables have the data types implied by their names
*     _ according to the usual Fortran defaults.
*     
*     This routine draws an arrow from a given point to another
*     _ point given relatively to the first one; one can choose
*     _ the size and angle or the two barbs that constitute the
*     _ arrowhead.
*     
*     The arguments are:
*     _ id_ad: id of the device;
*     _ x_beg: x position of the beginning of the arrow;
*     _ y_beg: y position of the beginning of the arrow;
*     _ x_del: variation in the x position to the end (head);
*     _ y_del: variation in the y position to the end (head);
*     _ a_siz: the length of the barbs of the arrowhead;
*     _        if this value is negative its absolute
*     _        value is interpreted as a fraction of
*     _        the length of the arrow;
*     _ a_ang: the half-angle of the arrowhead, that is,
*     _        the angle between the shaft and one of
*     _        the barbs, in degrees.
*     
      SUBROUTINE G2_ARROW_R
     *     (id_ad
     *     ,x_beg ,y_beg
     *     ,x_del ,y_del
     *     ,a_siz ,a_ang)
*     
*     This entry-point works as an alternate name,
*     _ for compatibility with gfortran.
      ENTRY G2_ARROW_R_
*     
*     Define a parameter for the ratio of radians per degree.
      parameter(rpd = 3.14159274 / 180.0)
*     
*     Save the values of a few variables between consecutive
*     _ calls to this function:
*     _ o_ang: the previous value of the angle;
*     _ a_sin: the corresponding value of the sine;
*     _ a_cos: the corresponding value of the cosine.
      save o_ang, a_sin, a_cos
*     
*     Initialize those variables at some default values.
      data o_ang, a_sin, a_cos / 0.0, 0.0, 1.0 /
*     
*     Calculate the position of the end (head) of the arrow.
      x_end = x_beg + x_del
      y_end = y_beg + y_del
*     
*     If it length of the barbs is zero, then just plot the
*     _ line and return.
      if (a_siz.eq.0.0) then
         call g2_line_ctof
     *        (id_ad
     *        ,x_beg ,y_beg
     *        ,x_end ,y_end)
         return
      end if
*     
*     Calculate the sine and cosine of the half-angle, but
*     _ only if the value of the angle has changed.
      if (a_ang.ne.o_ang) then
         o_ang = a_ang
         a_sin = sin(rpd * a_ang)
         a_cos = cos(rpd * a_ang)
      end if
*     
*     Starting vector arithmetic here.
*     
*     Calculate the components of the vector (beg)-->(end).
      vbe_x = x_del
      vbe_y = y_del
*     
*     Calculate the modulus of the vector (beg)-->(end).
      vbe_m = sqrt(vbe_x**2 + vbe_y**2)
*     
*     If it is the null vector, then just plot the single
*     _ point and return.
      if (vbe_m.eq.0.0) then
         call g2_plot_ctof
     *        (id_ad
     *        ,x_beg ,y_beg)
         return
      end if
*     
*     Define b_siz: if the length of the barbs is negative,
*     _ then interpret its absolute value as a fraction and
*     _ define b_siz as that fraction of the length of the
*     _ vector (beg)-->(end).
      if (a_siz.lt.0.0) then
         b_siz = abs(a_siz) * vbe_m
      else
         b_siz = a_siz
      end if
*     
*     Calculate the components of the versor (beg)-->(end).
      vrbe_x = vbe_x / vbe_m
      vrbe_y = vbe_y / vbe_m
*     
*     Calculate the components of the orthogonal versor.
      urbe_x = -vrbe_y
      urbe_y =  vrbe_x
*     
*     Define now the end-points of the two barbs of the arrow.
*     
*     Calculate the components of the vector (end)-->(barb1).
      vb1_x = -b_siz * (a_cos * vrbe_x + a_sin * urbe_x)
      vb1_y = -b_siz * (a_cos * vrbe_y + a_sin * urbe_y)
*     
*     Calculate the components of the vector (end)-->(barb2).
      vb2_x = -b_siz * (a_cos * vrbe_x - a_sin * urbe_x)
      vb2_y = -b_siz * (a_cos * vrbe_y - a_sin * urbe_y)
*     
*     Calculate the position of the end of the first
*     _ barb with respect to the end of the shaft.
      xp_b1 = x_end + vb1_x
      yp_b1 = y_end + vb1_y
*     
*     Calculate the position of the end of the second
*     _ barb with respect to the end of the shaft.
      xp_b2 = x_end + vb2_x
      yp_b2 = y_end + vb2_y
*     
*     Plot the shaft of the arrow.
      call g2_line_ctof
     *     (id_ad
     *     ,x_beg ,y_beg
     *     ,x_end ,y_end)
*     
*     Plot the two barbs of the arrow.
      call g2_line_ctof
     *     (id_ad
     *     ,x_end ,y_end
     *     ,xp_b1 ,yp_b1)
      call g2_line_ctof
     *     (id_ad
     *     ,x_end ,y_end
     *     ,xp_b2 ,yp_b2)
*     
      return
*     
      END
