/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_image(), which draws a pen image; a pen image
 * _ is given by a pixel-wise description, with the color given
 * _ by a pen or ink color index for each pixel.
 *
 * IMPORTANT BUG NOTE: the original C function g2_image() has a bug
 * _ related to the definition of a coordinate system on the device
 * _ via the function g2_set_coordinate_system(); the bug is that
 * _ when a coordinate system is defined on the device both the
 * _ position and the size of the image become subject to the
 * _ coordinate transformation; the addition of numbers from 0 to
 * _ i(xy)_siz to the position (xy)_pos in order to get the subsequent
 * _ pixels of the image is done in the coordinate units rather than
 * _ in single-pixel units as it should; because in most cases the
 * _ scale of the coordinates is such that 1 in the coordinate system
 * _ scale corresponds to many pixels, the consequence of this is that
 * _ the image has its pixels scattered over a very large region,
 * _ mostly outside the visible region within the window; while this
 * _ bug is not fixed you can only use this function with devices where
 * _ a coordinate system has not been defined, or when it has been
 * _ defined with multiplier factors of 1.0; this bug has been verified
 * _ to exist in versions 0.61 and 0.70 of the g2 library.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_image_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad:   the id of the device;
 * _ x_pos:   the x position of the image;
 * _ y_pos:   the y position of the image;
 * _ ix_siz:  the x size of the image in pixels;
 * _ iy_siz:  the y size of the image in pixels;
 * _ img_pen: pointer to an array containing the pen image
 * _          data, in the form of ix_siz*iy_siz integers.
 */
void g2_image_ctof__(int *id_ad,
		     float *x_pos, float *y_pos,
		     int *ix_siz, int *iy_siz,
		     int *img_pen)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_pos, f_y_pos: float variables to acquire the arguments;
   * _ d_x_pos, d_y_pos: double versions of the variables above;
   * _ i_ix_siz, i_iy_siz: int variables to acquire the arguments;
   * _ i_img_pen: a pointer to an array of i_ix_siz*i_iy_siz int numbers;
   * _            since we do not want to dimension it statically here,
   * _            we declare it simply as a pointer to int.
   */
  int    i_id_ad, i_ix_siz, i_iy_siz;
  float  f_x_pos, f_y_pos;
  double d_x_pos, d_y_pos;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad  = *id_ad;
  f_x_pos  = *x_pos;
  f_y_pos  = *y_pos;
  i_ix_siz = *ix_siz;
  i_iy_siz = *iy_siz;
  /*
   * Pass the float data to the double variables.
   */
  d_x_pos = f_x_pos;
  d_y_pos = f_y_pos;
  /*
   * Call the C function with the required arguments; note
   * _ that the data image pointer is passed directly
   * _ to the function, without any transformation.
   */
  g2_image(i_id_ad,
	   d_x_pos,  d_y_pos,
	   i_ix_siz, i_iy_siz,
	   img_pen);
}
/*
 * Compatibility function for gfortran.
 */
void g2_image_ctof_(int *id_ad,
		    float *x_pos, float *y_pos,
		    int *ix_siz, int *iy_siz,
		    int *img_pen)
{
  g2_image_ctof__(id_ad,
		  x_pos, y_pos,
		  ix_siz, iy_siz,
		  img_pen);
}
