*     JLdL 30Oct07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine calculates the values of a few variables which
*     _ are local to this program, and which depend on the values
*     _ read from the temporary data-transfer file; this includes
*     _ variables related to the internal coordinate system and
*     _ to the geometry of the plotting window.
*     
      SUBROUTINE CALCULATE_PARAMS
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Calculate the coordinate ranges of the plotting window,
*     _ so that we can relate them to the window dimensions.
      del_xr = xr_max - xr_min
      del_yi = yi_max - yi_min
*     
*     Calculate the aspect ratio of the coordinate ranges, so
*     _ that we can create the plotting window with the same
*     _ aspect ratio as the internal coordinate system.
      asp_rt = del_xr / del_yi
*     
*     Define the size of the window, starting with the y size,
*     _ which is defined by the overall window scale.
      iy_siz = iw_scl
*     
*     Set the x size of the window so that we get the correct
*     _ aspect ratio for it.
      ix_siz = int(float(iw_scl) * asp_rt)
*     
*     Set the x position of the window; this is for programs
*     _ which understand negative X11 window positions in the
*     _ raw way, such as theh g2 library; note that this will
*     _ usually exclude the window borders, so we must also
*     _ subtract them here; unfortunately, this means that
*     _ the result will be dependent on the configuration
*     _ of the window manager in use.
      jx_pos
     *     = i_w_rw
     *     - ix_siz
     *     - 5
     *     - 5
     *     + ix_pos
*     
*     Set the y position of the window.
      jy_pos = iy_pos
*     
*     Define the origin of the coordinate system.
      xc_org = -float(ix_siz) * xr_min / del_xr
      yc_org = -float(iy_siz) * yi_min / del_yi
*     
*     Define the multipliers of the coordinate system.
      xc_mul = float(ix_siz) / del_xr
      yc_mul = float(iy_siz) / del_yi
*     
*     Define the inverse multipliers of the coordinate system.
      xc_div = 1.0 / xc_mul
      yc_div = 1.0 / yc_mul
*     
*     Define the integral-curve integration interval.
      del_int = gr_siz / 100.0
*     
*     Define the maximum number of steps in the integration,
*     _ so as to avoid infinite dry loops for closed curves;
*     _ first define the average linear size of the window,
*     _ in terms of coordinate units.
      avr_siz = 0.5 * (del_xr + del_yi)
      max_cnt = int(avr_siz * twopi / del_int)
*     
*     Define the graphics text font size, in pixel units.
      fnt_siz = 20.0
*     
      return
*     
      END
