/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ extension function g2_float_string(), which draws a float
 * _ number as a string.
 *
 * IMPORTANT NOTE: the character string that is to be passed to
 * _ the C function must have been defined in the calling Fortran
 * _ program including the trailing NULL which is needed in the
 * _ C language; this can be done in Fortran with a line such as:
 * _
 * _    character_variable = 'some constant string'//char(0)
 * _
 * _ where the character variable must have been defined with a
 * _ size sufficient to hold all the required data, of course;
 * _ passing a constant string directly in the argument of the
 * _ function will usually also work correctly, many times even
 * _ without the trailing NULL, but it is much safer to add the
 * _ trailing NULL anyway, using as the argument the combination
 * _
 * _    'some constant string'//char(0)
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_float_string_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_pos: the x position of the string;
 * _ y_pos: the y position of the string;
 * _ f_num: the float number to be drawn as a string;
 * _ f_fmt: the C-style format for the float string.
 */
void g2_float_string_ctof__(int *id_ad,
			    float *x_pos, float *y_pos,
			    float *f_num,
			    char *f_fmt)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_pos, f_y_pos: float variables to acquire the arguments;
   * _ d_x_pos, d_y_pos: double versions of the variables above;
   * _ f_f_num: float variable to acquire the argument;
   * _ d_f_num: double version of the variable above.
   */
  int    i_id_ad;
  float  f_x_pos, f_y_pos, f_f_num;
  double d_x_pos, d_y_pos, d_f_num;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_x_pos = *x_pos;
  f_y_pos = *y_pos;
  f_f_num = *f_num;
  /*
   * Pass the float data to the double variables.
   */
  d_x_pos = f_x_pos;
  d_y_pos = f_y_pos;
  d_f_num = f_f_num;
  /*
   * Call the C function with the required arguments; note
   * _ that the format string pointer is passed directly
   * _ to the function, without any transformation.
   */
  g2_float_string(i_id_ad,
		  d_x_pos, d_y_pos,
		  d_f_num,
		  f_fmt);
}
/*
 * Compatibility function for gfortran.
 */
void g2_float_string_ctof_(int *id_ad,
			   float *x_pos, float *y_pos,
			   float *f_num,
			   char *f_fmt)
{
  g2_float_string_ctof__(id_ad,
			 x_pos, y_pos,
			 f_num,
			 f_fmt);
}
