/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_open_EPSF_CLIP(), which creates a physical EPSF
 * _ device with clipping, that is, with a predefined bounding
 * _ box, as well as a file to hold the data.
 *
 * IMPORTANT NOTE: the character string that is to be passed to
 * _ the operating system must have been defined in the calling
 * _ Fortran program including the trailing NULL which is needed
 * _ in C; this can be done in Fortran with a line such as:
 * _
 * _    character_variable = 'some constant string'//char(0)
 * _
 * _ where the character variable must have been defined with a
 * _ size sufficient to hold all the required data, of course;
 * _ passing a constant string directly in the argument of the
 * _ function will usually also work correctly, many times even
 * _ without the trailing NULL, but it is much safer to add the
 * _ trailing NULL anyway, using as the argument the combination
 * _
 * _    'some constant string'//char(0)
 *
 * This is to be called from Fortran as an integer function,
 * _ that is, as "id = g2_open_epsf_clip_ctof(<args>)".
 *
 * Note: this is the only routine of the whole set that has some
 * _ long rather than int arguments: the clipping area sizes.
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ fl_nm: the filename string;
 * _ i_wid: width of the clipping region;
 * _ i_hei: height of the clipping region.
 */
int g2_open_epsf_clip_ctof__(char *fl_nm,
			     int *i_wid, int *i_hei)
{
  /*
   * Local variables:
   * _ i_i_wid, i_i_hei: int variables to acquire the arguments;
   * _ l_i_wid, l_i_hei: long versions of the variables above;
   * _ i_id_xd: int variable to return the device id.
   */
  int  i_i_wid, i_i_hei, i_id_xd;
  long l_i_wid, l_i_hei;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_i_wid = *i_wid;
  i_i_hei = *i_hei;
  /*
   * Pass the int data to the long variables.
   */
  l_i_wid = i_i_wid;
  l_i_hei = i_i_hei;
  /*
   * Call the C function with the required arguments; note
   * _ that the filename string pointer is passed directly
   * _ to the function, without any transformation.
   */
  i_id_xd = g2_open_EPSF_CLIP(fl_nm,
			      l_i_wid, l_i_hei);
  /*
   * Return the id of the physical device created.
   */
  return(i_id_xd);
}
/*
 * Compatibility function for gfortran.
 */
int g2_open_epsf_clip_ctof_(char *fl_nm,
			    int *i_wid, int *i_hei)
{
  return g2_open_epsf_clip_ctof__(fl_nm,
				  i_wid, i_hei);
}
