/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_open_EPSF(), which creates a physical EPSF
 * _ device and a file to hold the data.
 *
 * IMPORTANT NOTE: the character string that is to be passed to
 * _ the operating system must have been defined in the calling
 * _ Fortran program including the trailing NULL which is needed
 * _ in C; this can be done in Fortran with a line such as:
 * _
 * _    character_variable = 'some constant string'//char(0)
 * _
 * _ where the character variable must have been defined with a
 * _ size sufficient to hold all the required data, of course;
 * _ passing a constant string directly in the argument of the
 * _ function will usually also work correctly, many times even
 * _ without the trailing NULL, but it is much safer to add the
 * _ trailing NULL anyway, using as the argument the combination
 * _
 * _    'some constant string'//char(0)
 *
 * This is to be called from Fortran as an integer function,
 * _ that is, as "id = g2_open_epsf_ctof(<arg>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the argument is:
 * _ fl_nm: the filename string.
 */
int g2_open_epsf_ctof__(char *fl_nm)
{
  /*
   * Local variables:
   * _ i_id_xd: int variable to return the device id.
   */
  int i_id_xd;
  /*
   * Call the C function with the required arguments; note
   * _ that the filename string pointer is passed directly
   * _ to the function, without any transformation.
   */
  i_id_xd = g2_open_EPSF(fl_nm);
  /*
   * Return the id of the physical device created.
   */
  return(i_id_xd);
}
/*
 * Compatibility function for gfortran.
 */
int g2_open_epsf_ctof_(char *fl_nm)
{
  return g2_open_epsf_ctof__(fl_nm);
}
