*     JLdL 29Jan12.
*     
*     Copyright (C) 2007-2012 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine draws a single value of the function; it deals
*     _ with true singularities, as well as with other numerical
*     _ overflows, by marking them with red circles; the flag
*     _ variable "sz_flag" brings in the information about the
*     _ existence of a floating-point exception.
*     
      SUBROUTINE DRAW_SINGLE_VALUE
     *     (x_var, y_var, x_fun, y_fun, f_mod, sz_flag)
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     Dealing with singularities, in case we hit one; check for a
*     _ floating-point exception, and in such cases do not plot
*     _ the function, but rather mark the position of the
*     _ singularity with a red circle.
      if (sz_flag .eq. 1) then
*     
*     Choose the color scheme for the contents of this routine
*     _ and for this value of the flag.
         call set_color_scheme(ics_sing)
*     
*     Plot the circle.
         call g2_filled_circle_(id_vd, x_var, y_var, sm_rad)
*     
*     Check for a null vector, in case we hit one; in this case
*     _ do not plot the function, but rather mark the position
*     _ of the root with a green circle.
      else if (sz_flag .eq. -1) then
*     
*     Choose the color scheme for the contents of this routine
*     _ and for this value of the flag.
         call set_color_scheme(ics_root)
*     
*     Plot the circle.
         call g2_filled_circle_(id_vd, x_var, y_var, sm_rad)
*     
      else
*     
*     If all is well, then draw the vector function.
*     
*     Choose the color scheme for the contents of this routine.
         call set_color_scheme(ics_norm)
*     
*     If the vector is small compared to the size of the window,
*     _ use a filled arrow, for better visibility.
         if (f_mod .lt. 0.15 * avr_siz) then
            call g2_filled_arrow_r
     *           (
     *           id_vd,
     *           x_var, y_var,
     *           x_fun, y_fun,
     *           -0.2,
     *           15.0
     *           )
*     
*     Otherwise use a normal arrow.
         else
            call g2_arrow_r
     *           (
     *           id_vd,
     *           x_var, y_var,
     *           x_fun, y_fun,
     *           -0.2,
     *           15.0
     *           )
*     
         end if
*     
      end if
*     
      return
*     
      END
