/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.FacetListIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public class AtomicUserDefinedValue
extends AtomicValue
implements Item {
    AtomicValue primitiveValue;
    AtomicType typeLabel;

    private AtomicUserDefinedValue() {
    }

    public static AtomicUserDefinedValue makeValue(AtomicValue atomicValue, AtomicType atomicType, boolean bl) throws XPathException {
        AtomicUserDefinedValue atomicUserDefinedValue = new AtomicUserDefinedValue();
        atomicUserDefinedValue.primitiveValue = atomicValue;
        atomicUserDefinedValue.typeLabel = atomicType;
        XPathException xPathException = atomicUserDefinedValue.validate();
        if (xPathException != null) {
            if (bl) {
                throw xPathException;
            }
            return null;
        }
        return atomicUserDefinedValue;
    }

    public AtomicValue getPrimitiveValue() {
        return this.primitiveValue;
    }

    private XPathException validate() {
        FacetListIterator facetListIterator = this.typeLabel.getFacets();
        boolean bl = false;
        boolean bl2 = false;
        while (facetListIterator.hasNext()) {
            Facet facet = (Facet)facetListIterator.next();
            boolean bl3 = facet.getName().equals("enumeration");
            if (bl3 && bl) continue;
            boolean bl4 = facet.testAtomicValue(this.primitiveValue);
            if (bl3) {
                bl2 = true;
                if (!bl4) continue;
                bl = true;
                continue;
            }
            if (bl4) continue;
            return new XPathException.Dynamic("Value \u00ab" + this.displayValue() + "\u00bb violates the " + facet.getName() + " facet \u00ab" + facet.getValue() + "\u00bb of the type " + this.typeLabel.getDescription());
        }
        if (bl2 && !bl) {
            return new XPathException.Dynamic("Value \u00ab" + this.displayValue() + "\u00bb is not one of the" + " permitted values for the type " + this.typeLabel.getDescription());
        }
        return null;
    }

    private String displayValue() {
        String string;
        try {
            string = this.primitiveValue.getStringValue();
        }
        catch (XPathException xPathException) {
            string = this.primitiveValue.toString();
        }
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        return string;
    }

    public AtomicValue convert(int n) throws XPathException {
        return this.primitiveValue.convert(n);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this;
    }

    public String getStringValue() throws XPathException {
        return this.primitiveValue.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.primitiveValue.effectiveBooleanValue(xPathContext);
    }

    public int hashCode() {
        return this.primitiveValue.hashCode();
    }

    public Object convertToJava(Class clazz) throws XPathException {
        return this.primitiveValue.convertToJava(clazz);
    }

    public int conversionPreference(Class clazz) {
        return this.primitiveValue.conversionPreference(clazz);
    }

    public ItemType getItemType() {
        return this.typeLabel;
    }

    public void display(int n, NamePool namePool) {
        this.primitiveValue.display(n, namePool);
    }

    public boolean equals(Object object) {
        return this.primitiveValue.equals(object);
    }
}

