/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleReadOnly;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintRenderer;
import java.util.HashMap;
import java.util.Map;

public class BlueprintRendererSample
extends BlueprintRenderer {
    private static final Map<String, String> SAMPLES = new HashMap<String, String>();
    private final Grammar grammar;

    public BlueprintRendererSample(Grammar grammar, Blueprint bp) {
        super(bp);
        this.grammar = grammar;
    }

    @Override
    public Property getProperty(Property entity, TagPath path) {
        MetaProperty meta;
        Property result = super.getProperty(entity, path);
        if (result != null) {
            return result;
        }
        String sample = SAMPLES.get(path.getLast());
        if (sample == null) {
            sample = Gedcom.getName(path.getLast());
        }
        if (PropertyXRef.class.isAssignableFrom((meta = this.grammar.getMeta(path, false)).getType())) {
            sample = "@...@";
        }
        try {
            return meta.create(sample);
        }
        catch (GedcomException e) {
            return new PropertySimpleReadOnly(path.getLast(), sample);
        }
    }

    static {
        SAMPLES.put("NAME", "John /Doe/");
        SAMPLES.put("SEX", "M");
        SAMPLES.put("DATE", "01 JAN 1900");
        SAMPLES.put("PLAC", "Nice Place");
        SAMPLES.put("ADDR", "Long Address");
        SAMPLES.put("CITY", "Big City");
        SAMPLES.put("POST", "12345");
    }
}

