/*
 * Decompiled with CFR 0.152.
 */
package swingx.dnd.tree;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import swingx.dnd.tree.DefaultDnDTreeModel;
import swingx.dnd.tree.DnDTreeModel;

public class DnDTree
extends JTree
implements Autoscroll {
    private static final int DEFAULT_AUTOSCROLL_MARGIN = 12;
    private int autoscrollMargin = 12;
    private DragGestureRecognizer dragGestureRecognizer;
    private DragHandler dragHandler;
    private DropHandler dropHandler;

    public DnDTree() {
        this(DnDTree.getDefaultTreeModel());
    }

    public DnDTree(TreeModel model) {
        super(model);
        this.setDragEnabled(true);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
                TreePath[] paths;
                if (DnDTree.this.hasDnDModel() && (paths = DnDTree.this.getSelectionPaths()) != null && paths.length > 0) {
                    Arrays.sort(paths, DnDTree.this.dragHandler);
                    Object[] nodes = new Object[paths.length];
                    for (int p = 0; p < paths.length; ++p) {
                        if (paths[p].getPathCount() <= 1) continue;
                        nodes[p] = paths[p].getLastPathComponent();
                    }
                    Transferable transferable = DnDTree.this.getDnDModel().createTransferable(nodes);
                    try {
                        DnDTree.this.getDnDModel().drag(transferable, action);
                        clip.setContents(transferable, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                TreePath[] paths = DnDTree.this.getSelectionPaths();
                if (paths != null && paths.length == 1 && paths[0].getPathCount() > 0 && DnDTree.this.hasDnDModel()) {
                    try {
                        DnDTree.this.getDnDModel().drop(t, paths[0].getLastPathComponent(), 0, 2);
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
        this.dragGestureRecognizer = new DragSource().createDefaultDragGestureRecognizer(this, 2, this.getDragSourceListener());
        new DropTarget(this, this.getDropTargetListener());
    }

    protected static TreeModel getDefaultTreeModel() {
        return new DefaultDnDTreeModel((MutableTreeNode)JTree.getDefaultTreeModel().getRoot());
    }

    public boolean hasDnDModel() {
        return this.getModel() instanceof DnDTreeModel;
    }

    public DnDTreeModel getDnDModel() {
        if (this.getModel() instanceof DnDTreeModel) {
            return (DnDTreeModel)this.getModel();
        }
        throw new IllegalStateException("no DnDTreeModel");
    }

    public int getAutoscrollMargin() {
        return this.autoscrollMargin;
    }

    public void setAutoscrollMargin(int margin) {
        this.autoscrollMargin = margin;
    }

    @Override
    public void autoscroll(Point point) {
        Dimension dimension = this.getParent().getSize();
        int row = this.getClosestRowForLocation(point.x, point.y);
        if (row != -1) {
            row = this.getY() + point.y < dimension.height / 2 ? Math.max(0, row - 1) : Math.min(row + 1, this.getRowCount() - 1);
            this.scrollRowToVisible(row);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle bounds = this.getParent().getBounds();
        return new Insets(bounds.y - this.getY() + this.autoscrollMargin, bounds.x - this.getX() + this.autoscrollMargin, this.getHeight() - bounds.height - bounds.y + this.getY() + this.autoscrollMargin, this.getWidth() - bounds.width - bounds.x + this.getX() + this.autoscrollMargin);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.getDropTargetListener().paint(g);
    }

    protected DragHandler getDragSourceListener() {
        if (this.dragHandler == null) {
            this.dragHandler = new DragHandler();
        }
        return this.dragHandler;
    }

    protected DropHandler getDropTargetListener() {
        if (this.dropHandler == null) {
            this.dropHandler = new DropHandler();
        }
        return this.dropHandler;
    }

    protected Image createDragImage(TreePath[] selectionPaths) {
        return this.createImage(1, 1);
    }

    private class DropHandler
    extends DropTargetAdapter
    implements ActionListener,
    TreeModelListener {
        private Timer timer;
        private TreePath parentPath;
        private int childIndex = 0;
        private Rectangle indicator;
        private List<TreePath> insertions = new ArrayList<TreePath>();

        public DropHandler() {
            this.timer = new Timer(1500, this);
            this.timer.setRepeats(false);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.dragOver(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            int action = dtde.getDropAction();
            boolean accepted = false;
            if (DnDTree.this.hasDnDModel()) {
                this.update(dtde.getLocation());
                if (this.parentPath != null) {
                    Transferable transferable = dtde.getTransferable();
                    if (transferable == null) {
                        accepted = true;
                    } else {
                        Object parent = this.parentPath.getLastPathComponent();
                        boolean bl = accepted = (DnDTree.this.getDnDModel().getDropActions(transferable, parent, this.childIndex) & action) != 0;
                    }
                }
            }
            if (accepted) {
                dtde.acceptDrag(action);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.clear();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            int action = dtde.getDropAction();
            boolean complete = false;
            DnDTree.this.getModel().addTreeModelListener(this);
            try {
                Object parent = null;
                if (DnDTree.this.hasDnDModel() && this.parentPath != null) {
                    dtde.acceptDrop(action);
                    parent = this.parentPath.getLastPathComponent();
                    Transferable transferable = dtde.getTransferable();
                    if ((DnDTree.this.getDnDModel().getDropActions(transferable, parent, this.childIndex) & action) != 0) {
                        DnDTree.this.getDnDModel().drop(transferable, parent, this.childIndex, action);
                        complete = true;
                    }
                }
                dtde.dropComplete(complete);
                if (!this.insertions.isEmpty() && parent != null) {
                    DnDTree.this.getSelectionModel().clearSelection();
                    for (int i = 0; i < this.insertions.size(); ++i) {
                        TreePath path = this.insertions.get(i);
                        if (DnDTree.this.getModel().getIndexOfChild(parent, path.getLastPathComponent()) < 0) continue;
                        DnDTree.this.getSelectionModel().addSelectionPath(path);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DnDTree.this.getModel().removeTreeModelListener(this);
            this.clear();
        }

        private void update(Point point) {
            TreePath oldParentPath = this.parentPath;
            TreePath path = DnDTree.this.getClosestPathForLocation(point.x, point.y);
            if (path == null) {
                this.parentPath = null;
                this.childIndex = -1;
                this.indicator = null;
            } else if (path.getPathCount() == 1) {
                this.parentPath = path;
                this.childIndex = 0;
                this.indicator = null;
            } else {
                this.parentPath = path.getParentPath();
                this.childIndex = DnDTree.this.getModel().getIndexOfChild(this.parentPath.getLastPathComponent(), path.getLastPathComponent());
                this.indicator = DnDTree.this.getPathBounds(path);
                if (DnDTree.this.getModel().isLeaf(path.getLastPathComponent()) || point.y < this.indicator.y + this.indicator.height * 1 / 4 || point.y > this.indicator.y + this.indicator.height * 3 / 4 && !DnDTree.this.isExpanded(path)) {
                    if (point.y > this.indicator.y + this.indicator.height / 2) {
                        this.indicator.y += this.indicator.height;
                        ++this.childIndex;
                    }
                    this.indicator.width = DnDTree.this.getWidth() - this.indicator.x - DnDTree.this.getInsets().right;
                    --this.indicator.y;
                    this.indicator.height = 2;
                } else {
                    this.parentPath = path;
                    this.indicator = null;
                    this.childIndex = 0;
                }
            }
            DnDTree.this.repaint();
            if (this.parentPath == null) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.parentPath.equals(oldParentPath)) {
                this.timer.start();
            }
        }

        private void clear() {
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            this.parentPath = null;
            this.childIndex = -1;
            this.indicator = null;
            this.insertions.clear();
            DnDTree.this.repaint();
        }

        public TreePath getParentPath() {
            return this.parentPath;
        }

        public void paint(Graphics g) {
            if (this.indicator != null) {
                this.paintIndicator(g, this.indicator);
            }
        }

        private void paintIndicator(Graphics g, Rectangle rect) {
            g.setColor(DnDTree.this.getForeground());
            g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            g.drawLine(rect.x, rect.y - 2, rect.x + 1, rect.y - 2);
            g.drawLine(rect.x, rect.y - 1, rect.x + 2, rect.y - 1);
            g.drawLine(rect.x, rect.y + rect.height + 0, rect.x + 2, rect.y + rect.height + 0);
            g.drawLine(rect.x, rect.y + rect.height + 1, rect.x + 1, rect.y + rect.height + 1);
            g.drawLine(rect.x + rect.width - 2, rect.y - 2, rect.x + rect.width - 1, rect.y - 2);
            g.drawLine(rect.x + rect.width - 3, rect.y - 1, rect.x + rect.width - 1, rect.y - 1);
            g.drawLine(rect.x + rect.width - 3, rect.y + rect.height + 0, rect.x + rect.width - 1, rect.y + rect.height + 0);
            g.drawLine(rect.x + rect.width - 2, rect.y + rect.height + 1, rect.x + rect.width - 1, rect.y + rect.height + 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.parentPath != null) {
                DnDTree.this.expandPath(this.parentPath);
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            Object[] children = e.getChildren();
            for (int c = 0; c < children.length; ++c) {
                this.insertions.add(e.getTreePath().pathByAddingChild(children[c]));
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.insertions.clear();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.insertions.clear();
            this.insertions.add(e.getTreePath());
        }
    }

    private class DragHandler
    extends DragSourceAdapter
    implements DragGestureListener,
    Comparator<TreePath> {
        private Transferable transferable;

        private DragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            TreePath[] paths;
            if (DnDTree.this.hasDnDModel() && (paths = DnDTree.this.getSelectionPaths()) != null && paths.length > 0) {
                Arrays.sort(paths, this);
                boolean selectionHit = false;
                Object[] nodes = new Object[paths.length];
                for (int p = 0; p < paths.length; ++p) {
                    if (paths[p].getPathCount() <= 0) continue;
                    nodes[p] = paths[p].getLastPathComponent();
                    Rectangle rect = DnDTree.this.getPathBounds(paths[p]);
                    if (!rect.contains(dge.getDragOrigin())) continue;
                    selectionHit = true;
                }
                if (selectionHit) {
                    this.transferable = DnDTree.this.getDnDModel().createTransferable(nodes);
                    DnDTree.this.dragGestureRecognizer.setSourceActions(DnDTree.this.getDnDModel().getDragActions(this.transferable));
                    dge.startDrag(null, DnDTree.this.createDragImage(paths), new Point(), this.transferable, this);
                }
            }
        }

        @Override
        public int compare(TreePath object1, TreePath object2) {
            int row2;
            TreePath path1 = object1;
            TreePath path2 = object2;
            int row1 = DnDTree.this.getRowForPath(path1);
            if (row1 < (row2 = DnDTree.this.getRowForPath(path2))) {
                return -1;
            }
            if (row2 < row1) {
                return 1;
            }
            return 0;
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                try {
                    DnDTree.this.getDnDModel().drag(this.transferable, dsde.getDropAction());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            DnDTree.this.getDnDModel().releaseTransferable(this.transferable);
            this.transferable = null;
            DnDTree.this.dragGestureRecognizer.setSourceActions(2);
        }
    }
}

