/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.eventsbymonths;

import ancestris.core.TextOptions;
import genj.chart.Chart;
import genj.chart.IndexedSeries;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ReportEventsByMonths
extends Report {
    public boolean BirthsChart = true;
    public boolean BaptismsChart = false;
    public boolean AdoptionsChart = false;
    public boolean MarriagesChart = true;
    public boolean DivorcesChart = true;
    public boolean DeathsChart = true;
    public int inferiorYearLimit = 0;
    public int superiorYearLimit = 2100;
    private int calendar;
    public static final Calendar[] CALENDARS = new Calendar[]{PointInTime.GREGORIAN, PointInTime.FRENCHR, PointInTime.JULIAN, PointInTime.HEBREW};

    public int getCalendar() {
        return this.calendar;
    }

    public void setCalendar(int set) {
        this.calendar = Math.max(0, Math.min(CALENDARS.length - 1, set));
    }

    public Calendar[] getCalendars() {
        return CALENDARS;
    }

    public Object start(Gedcom gedcom) {
        HashMap<String, String> labels = new HashMap<String, String>();
        ArrayList<IndexedSeries> series = new ArrayList<IndexedSeries>();
        if (this.BirthsChart) {
            series.add(this.analyze(gedcom.getEntities("INDI"), "BIRT"));
            labels.put("BIRT", this.translate("birt"));
        }
        if (this.BaptismsChart) {
            series.add(this.analyze(gedcom.getEntities("INDI"), "BAPM"));
            labels.put("BAPM", this.translate("bapm"));
        }
        if (this.AdoptionsChart) {
            series.add(this.analyze(gedcom.getEntities("INDI"), "ADOP"));
            labels.put("ADOP", this.translate("adop"));
        }
        if (this.MarriagesChart) {
            series.add(this.analyze(gedcom.getEntities("FAM"), "MARR"));
            labels.put("MARR", this.translate("marr"));
        }
        if (this.DivorcesChart) {
            series.add(this.analyze(gedcom.getEntities("FAM"), "DIV"));
            labels.put("DIV", this.translate("div"));
        }
        if (this.DeathsChart) {
            series.add(this.analyze(gedcom.getEntities("INDI"), "DEAT"));
            labels.put("DEAT", this.translate("deat"));
        }
        String[] categories = CALENDARS[this.calendar].getMonths(false);
        for (int i = 0; i < categories.length; ++i) {
            categories[i] = CALENDARS[this.calendar].getDisplayMonthLocalized(i, false, TextOptions.getInstance().getOutputLocale());
        }
        JTabbedPane charts = new JTabbedPane();
        for (IndexedSeries is : series) {
            String label = (String)labels.get(is.getName());
            Chart chart = new Chart(this.translate("chart.title", new Object[]{label, Integer.toString(this.inferiorYearLimit), Integer.toString(this.superiorYearLimit)}), is, categories, false);
            charts.addTab(label, (Component)chart);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", charts);
        return panel;
    }

    private IndexedSeries analyze(Collection entities, String tag) {
        int months = CALENDARS[this.calendar].getMonths(true).length;
        IndexedSeries series = new IndexedSeries(tag, months);
        for (Entity e : entities) {
            PropertyDate date;
            Property event = e.getProperty(series.getName());
            if (!(event instanceof PropertyEvent) || (date = ((PropertyEvent)event).getDate()) == null) continue;
            try {
                if (date.getStart().getPointInTime(CALENDARS[this.calendar]).getYear() < this.inferiorYearLimit || date.getStart().getPointInTime(CALENDARS[this.calendar]).getYear() > this.superiorYearLimit) continue;
                series.inc(date.getStart().getPointInTime(CALENDARS[this.calendar]).getMonth());
            }
            catch (GedcomException gedcomException) {}
        }
        return series;
    }
}

