/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.calculatrice;

import ancestris.modules.calculatrice.CalculatorEngine;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class Calculator
extends JPanel
implements KeyListener {
    private final Class<?> ENGINE;
    private final CalculatorEngine engine = new CalculatorEngine();
    private final JTextField display = new JTextField();
    private final JTextArea area = new JTextArea();
    private char lastChar = '\u0000';
    private KeyListener mainPanel = this;

    public Calculator() {
        this.ENGINE = this.engine.getClass();
        this.buildGUI();
        this.setFocus();
    }

    boolean executeKeyCommand(char key) {
        switch (key) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.engine.digit(Integer.valueOf(key) - Integer.valueOf(48));
                break;
            }
            case '.': {
                this.engine.digit(key);
                break;
            }
            case '/': {
                this.engine.divide();
                break;
            }
            case '*': {
                this.engine.multiply();
                break;
            }
            case '-': {
                this.engine.subtract();
                break;
            }
            case '+': {
                this.engine.add();
                break;
            }
            case '%': {
                this.engine.percent();
                break;
            }
            case '\n': 
            case '\r': {
                this.engine.equals();
                break;
            }
            case '\b': {
                this.engine.backspace();
                break;
            }
            case '\u001b': {
                if (this.lastChar == '\u001b') {
                    this.engine.clear();
                    break;
                }
                this.engine.clearEntry();
                break;
            }
            default: {
                this.lastChar = key;
                return false;
            }
        }
        this.display.setText(this.engine.display());
        this.lastChar = key;
        return true;
    }

    private void buildGUI() {
        Calculator cp = this;
        cp.setLayout(new BoxLayout(cp, 1));
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
        this.area.setEditable(false);
        this.area.setBackground(Color.LIGHT_GRAY);
        this.display.setMaximumSize(new Dimension(31000, 40));
        this.display.setEditable(false);
        this.display.setText("0");
        this.display.setBackground(Color.WHITE);
        this.display.setFont(new Font("Default", 1, 24));
        this.display.setHorizontalAlignment(4);
        this.display.addKeyListener(this.mainPanel);
        cp.add(this.display);
        cp.add(this.buildControlPanel());
        cp.add(this.buildButtonPanels());
        cp.add(Box.createVerticalGlue());
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        this.executeKeyCommand(key);
    }

    private JPanel buildControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(2, 0)));
        panel.add(new ControlButton(NbBundle.getMessage(Calculator.class, (String)"Key.C"), "clear"));
        panel.add(Box.createRigidArea(new Dimension(2, 0)));
        panel.add(new ControlButton(NbBundle.getMessage(Calculator.class, (String)"Key.CE"), "clearEntry"));
        panel.add(Box.createHorizontalGlue());
        ControlButton bsp = new ControlButton("", "backspace");
        bsp.setIcon((Icon)new ImageIcon((Object)this, "backspace"));
        panel.add(bsp);
        panel.add(Box.createRigidArea(new Dimension(2, 0)));
        panel.addKeyListener(this.mainPanel);
        return panel;
    }

    private JPanel buildButtonPanels() {
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(this.buildDigitPanel());
        buttons.add(this.buildFunctionSimplePanel());
        return buttons;
    }

    private JPanel buildDigitPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 3, 2, 2));
        panel.setMaximumSize(new Dimension(31000, 160));
        panel.add(new DigitButton("7"));
        panel.add(new DigitButton("8"));
        panel.add(new DigitButton("9"));
        panel.add(new DigitButton("4"));
        panel.add(new DigitButton("5"));
        panel.add(new DigitButton("6"));
        panel.add(new DigitButton("1"));
        panel.add(new DigitButton("2"));
        panel.add(new DigitButton("3"));
        panel.add(new DigitButton("0"));
        panel.add(new DigitButton("."));
        panel.add(new UnaryButton(" +/- ", "sign"));
        panel.addKeyListener(this.mainPanel);
        return panel;
    }

    private JPanel buildFunctionSimplePanel() {
        JPanel buttons = new JPanel(new GridLayout(4, 2, 2, 2));
        buttons.setMaximumSize(new Dimension(31000, 160));
        buttons.add(new FunctionButton("/", "divide"));
        buttons.add(new JLabel());
        buttons.add(new FunctionButton("x", "multiply"));
        buttons.add(new UnaryButton("1/x", "reciprocal"));
        buttons.add(new FunctionButton("-", "subtract"));
        buttons.add(new UnaryButton("%", "percent"));
        buttons.add(new FunctionButton("+", "add"));
        buttons.add(new FunctionButton("=", "equals"));
        buttons.addKeyListener(this.mainPanel);
        return buttons;
    }

    public void setFocus() {
        WindowManager.getDefault().invokeWhenUIReady(this.display::requestFocusInWindow);
    }

    private class UnaryButton
    extends CalcButton {
        UnaryButton(String s) {
            this(s, s);
        }

        UnaryButton(String s, String action) {
            super(s, action);
            this.setBackground(new Color(244, 243, 191));
        }
    }

    private class ControlButton
    extends CalcButton {
        ControlButton(String s) {
            this(s, s);
        }

        ControlButton(String s, String action) {
            super(s, action);
            this.setBackground(Color.WHITE);
        }
    }

    private class FunctionButton
    extends CalcButton {
        FunctionButton(String s) {
            this(s, s);
        }

        FunctionButton(String s, String action) {
            super(s, action);
            this.setFont(new Font("Default", 1, 16));
            this.setBackground(new Color(244, 243, 191));
        }
    }

    private class DigitButton
    extends CalcButton {
        DigitButton(String s) {
            super(s, s, s);
            this.setFont(new Font("Default", 1, 16));
            this.setForeground(Color.BLUE);
        }
    }

    private class CalcButton
    extends JButton
    implements ActionListener {
        CalcButton(String s, String action) {
            super(s);
            this.setActionCommand(action);
            this.setMargin(new Insets(2, 2, 2, 2));
            this.setForeground(Color.BLACK);
            this.addActionListener(this);
            this.addKeyListener(Calculator.this.mainPanel);
        }

        CalcButton(String s, String action, String key) {
            this(s, action);
            this.getInputMap().put(KeyStroke.getKeyStroke(key), action);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("clear")) {
                Calculator.this.area.setText("");
            } else if (Calculator.this.area.getRows() > 20) {
                String text = Calculator.this.area.getText();
                int index = text.indexOf("\n");
                Calculator.this.area.setText(text.substring(index != -1 ? index : 0));
            } else {
                Calculator.this.area.append("\n" + Calculator.this.display.getText());
            }
            String methodName = e.getActionCommand();
            Method method = null;
            Calculator.this.lastChar = '\u0000';
            try {
                if (e.getSource() instanceof DigitButton) {
                    method = Calculator.this.ENGINE.getMethod("digit", Integer.TYPE);
                    if (methodName.equals(".")) {
                        method.invoke((Object)Calculator.this.engine, 46);
                    } else {
                        method.invoke((Object)Calculator.this.engine, new Integer(methodName));
                    }
                } else {
                    method = Calculator.this.ENGINE.getMethod(methodName, null);
                    method.invoke((Object)Calculator.this.engine, (Object[])null);
                }
            }
            catch (NoSuchMethodException ex) {
                System.out.println("No such method: " + methodName);
            }
            catch (IllegalAccessException ea) {
                System.out.println("Illegal access" + methodName);
            }
            catch (InvocationTargetException et) {
                System.out.println("Target exception: " + methodName);
            }
            Calculator.this.display.setText(Calculator.this.engine.display());
        }
    }
}

