/*
 * Decompiled with CFR 0.152.
 */
package org.miv.mbox.net;

import java.io.Serializable;

public class MBoxLocator
implements Serializable {
    private static final long serialVersionUID = 145871486067935485L;
    protected String hostname;
    protected int port;
    protected String name;
    protected String hostId;

    public MBoxLocator(String hostname, int port) {
        this(hostname, port, "");
    }

    public MBoxLocator(String hostname, int port, String name) {
        this.hostname = hostname;
        this.port = port;
        this.name = name;
        this.hostId = "//" + hostname + ":" + port;
    }

    public MBoxLocator(String locator_string) throws IllegalArgumentException {
        int n1 = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String s_port = "0";
        n1 = locator_string.indexOf(47);
        if (n1 < 0) {
            throw new IllegalArgumentException("invalid locator string '" + locator_string + "'");
        }
        n2 = locator_string.indexOf(47, n1 + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid locator string '" + locator_string + "'");
        }
        n3 = locator_string.indexOf(58, n2 + 1);
        if (n3 < 0 ? (n3 = locator_string.indexOf(47, n2 + 1)) < 0 : (n4 = locator_string.indexOf(47, n3 + 1)) < 0) {
            throw new IllegalArgumentException("invalid locator string '" + locator_string + "'");
        }
        this.hostname = locator_string.substring(n2 + 1, n3);
        if (n4 >= 0) {
            s_port = locator_string.substring(n3 + 1, n4);
            this.name = n4 < locator_string.length() - 1 ? locator_string.substring(n4 + 1) : "";
        } else {
            this.name = n3 < locator_string.length() - 1 ? locator_string.substring(n3 + 1) : "";
        }
        try {
            this.port = Integer.parseInt(s_port);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid locator string (invalid port) '" + locator_string + "'");
        }
        this.hostId = "//" + this.hostname + ":" + this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String toString() {
        if (this.port > 0) {
            return "//" + this.hostname + ":" + this.port + "/" + this.name;
        }
        return "//" + this.hostname + "/" + this.name;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.hostId = "//" + hostname + ":" + this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.hostId = "//" + this.hostname + ":" + port;
    }

    public void setName(String name) {
        this.name = name;
    }
}

