/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.core.TextOptions;
import ancestris.report.svgtree.ColorManager;
import ancestris.report.svgtree.FamBox;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.graphics.GraphicsUtil;
import ancestris.report.svgtree.output.TreeElements;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.renderer.MediaRenderer;
import genj.report.Translator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;

public class GraphicsTreeElements
implements TreeElements {
    private static final int DEFAULT_INDIBOX_WIDTH = 110;
    private static final int SHRINKED_INDIBOX_WIDTH = 50;
    private static final int DEFAULT_INDIBOX_HEIGHT = 64;
    private static final int DEFAULT_FAMBOX_WIDTH = 100;
    private static final int DEFAULT_FAMBOX_HEIGHT = 27;
    private static final int MAX_IMAGE_WIDTH = 50;
    private static final int DEFAULT_INDIBOX_LINES = 2;
    private static final int DEFAULT_FAMBOX_LINES = 1;
    private static final int TEXT_MARGIN = 5;
    private static final int NAME_LINE_HEIGHT = 12;
    private static final int LINE_HEIGHT = 10;
    private static final TagPath PATH_INDIOCCU;
    private static final TagPath PATH_INDITITL;
    private static final TagPath PATH_FAMMARRPLAC;
    private static final TagPath PATH_FAMDIVPLAC;
    private final double IMAGE_SCALE_FACTOR = 4.0;
    private static final FontRenderContext FONT_RENDER_CONTEXT;
    private static final float STROKE_WIDTH = 2.0f;
    private static final String MALE_SYMBOL = "\u2642";
    private static final String FEMALE_SYMBOL = "\u2640";
    private static final String UNKNOWN_SYMBOL = "?";
    private static final Stroke DASHED_STROKE;
    private static Font sexSymbolFont;
    public int fontNameDetail = 0;
    public String[] fontNameDetails = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    public boolean swap_names = false;
    public int max_names = 0;
    public String[] max_namess = new String[]{"nolimit", "1", "2", "3"};
    public int max_names_per_line = 2;
    public String[] max_names_per_lines = new String[]{"nolimit", "1", "2", "3"};
    public boolean display_titles = false;
    public int number_titles = 1;
    public boolean draw_title = false;
    public boolean draw_name_suffix = false;
    public int font_name_suffix = 3;
    public String[] font_name_suffixs = new String[]{"plain", "bold", "italic", "bolditalic"};
    public boolean draw_indi_ids = false;
    public boolean draw_indi_sosas = false;
    public boolean draw_fam_ids = false;
    public int min_fam_index = 2;
    public boolean draw_sex_symbols = true;
    public boolean draw_dates = true;
    public boolean draw_places = true;
    public String place_display_format = "place_display_format.full";
    public boolean draw_occupation = true;
    public int number_occupation = 1;
    public boolean draw_divorce = true;
    public boolean draw_images = true;
    public boolean high_quality_images = true;
    public boolean shrink_boxes = false;
    public boolean use_colors = true;
    private Font detailsFont;
    private Font nameFont;
    private Font idFont;
    private final Translator translator;
    private ColorManager colorManager;
    private Graphics2D graphics = null;

    public GraphicsTreeElements(Translator translator) {
        this.translator = translator;
        this.max_namess[0] = translator.translate(this.max_namess[0]);
        this.max_names_per_lines[0] = translator.translate(this.max_names_per_lines[0]);
        for (int i = 0; i < this.font_name_suffixs.length; ++i) {
            this.font_name_suffixs[i] = translator.translate(this.font_name_suffixs[i]);
        }
        this.place_display_format = translator.translate(this.place_display_format);
    }

    private void checkFont() {
        if (this.detailsFont != null && this.detailsFont.getFamily().equals(this.fontNameDetails[this.fontNameDetail])) {
            return;
        }
        if (!GraphicsUtil.checkFont(this.fontNameDetails[this.fontNameDetail])) {
            this.fontNameDetails[this.fontNameDetail] = "verdana";
        }
        this.detailsFont = new Font(this.fontNameDetails[this.fontNameDetail], 0, 10);
        this.nameFont = new Font(this.fontNameDetails[this.fontNameDetail], 1, 12);
        this.idFont = new Font(this.fontNameDetails[this.fontNameDetail], 2, 10);
    }

    public void setColorManager(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    @Override
    public void setGraphics(Graphics2D graphics) {
        this.graphics = graphics;
    }

    @Override
    public void drawIndiBox(IndiBox indibox, int x, int y) {
        this.checkFont();
        if (!this.graphics.hitClip(x, y, indibox.width, indibox.height)) {
            return;
        }
        Indi i = indibox.individual;
        int imageWidth = 0;
        int imageHeight = indibox.height;
        if (this.draw_images) {
            Dimension d = MediaRenderer.getSize((Property)i);
            if (d.width > 0 && d.height > 0) {
                imageWidth = d.width * indibox.height / d.height;
            }
            if (imageWidth > 50) {
                imageWidth = 50;
                imageHeight = d.height * imageWidth / d.width;
            }
        }
        int dataWidth = indibox.width - imageWidth;
        Color color = this.getBoxColor(indibox.gen);
        RoundRectangle2D.Double box = new RoundRectangle2D.Double(x, y, indibox.width, indibox.height, 15.0, 15.0);
        this.graphics.setColor(color);
        this.graphics.fill(box);
        this.graphics.setColor(Color.BLACK);
        Shape oldClip = this.graphics.getClip();
        this.graphics.clip(box);
        String nameSuffix = null;
        if (this.draw_name_suffix && (nameSuffix = i.getNameSuffix()) != null && nameSuffix.equals("")) {
            nameSuffix = null;
        }
        int currentY = y + 14;
        String[] firstNames = this.getFirstNames(i);
        String lastName = "";
        PropertyName prop = i.getNameProperty();
        if (prop != null) {
            String[] spfx = prop.getSurnamePrefix();
            if (spfx != null && !spfx.isEmpty()) {
                lastName = prop.getSurnamePrefix() + " ";
            }
            lastName = lastName + prop.getLastName();
        }
        if (this.display_titles && this.draw_title && i.getProperty(PATH_INDITITL) != null) {
            lastName = i.getProperty(PATH_INDITITL).getDisplayValue() + " " + lastName;
        }
        if (this.swap_names) {
            this.graphics.setFont(this.nameFont);
            GraphicsTreeElements.centerString(this.graphics, lastName, x + dataWidth / 2, currentY);
            currentY += 12;
            if (nameSuffix != null) {
                this.graphics.setFont(new Font(this.fontNameDetails[this.fontNameDetail], this.font_name_suffix, 12));
                GraphicsTreeElements.centerString(this.graphics, nameSuffix, x + dataWidth / 2, currentY);
                currentY += 12;
            }
        }
        this.graphics.setFont(this.nameFont);
        for (String firstName : firstNames) {
            GraphicsTreeElements.centerString(this.graphics, firstName, x + dataWidth / 2, currentY);
            currentY += 12;
        }
        if (!this.swap_names) {
            this.graphics.setFont(this.nameFont);
            GraphicsTreeElements.centerString(this.graphics, lastName, x + dataWidth / 2, currentY);
            currentY += 12;
            if (nameSuffix != null) {
                this.graphics.setFont(new Font(this.fontNameDetails[this.fontNameDetail], this.font_name_suffix, 12));
                GraphicsTreeElements.centerString(this.graphics, nameSuffix, x + dataWidth / 2, currentY);
                currentY += 12;
            }
        }
        this.graphics.setFont(this.detailsFont);
        PropertyDate birthDate = null;
        PropertyDate deathDate = null;
        PropertyPlace birthPlace = null;
        PropertyPlace deathPlace = null;
        Property[] occupations = null;
        if (this.display_titles) {
            Property[] titles = i.getProperties(PATH_INDITITL);
            for (int j = 0; j < Math.min(titles.length, this.number_titles); ++j) {
                if (j == 0 && this.draw_title) continue;
                this.graphics.drawString(titles[j].getDisplayValue(), x + 7, currentY);
                currentY += 10;
            }
        }
        if (this.draw_dates) {
            birthDate = i.getBirthDateOption();
            if (birthDate != null && !birthDate.isValid()) {
                birthDate = null;
            }
            if ((deathDate = i.getDeathDateOption()) != null && !deathDate.isValid()) {
                deathDate = null;
            }
        }
        if (this.draw_places) {
            birthPlace = i.getBirthPlaceOption();
            if (birthPlace != null && birthPlace.getDisplayValue().equals("")) {
                birthPlace = null;
            }
            if ((deathPlace = i.getDeathPlaceOption()) != null && deathPlace.getDisplayValue().equals("")) {
                deathPlace = null;
            }
        }
        if (this.draw_occupation) {
            occupations = i.getProperties(PATH_INDIOCCU);
        }
        if (birthDate != null || birthPlace != null) {
            GraphicsTreeElements.centerString(this.graphics, TextOptions.getInstance().getBirthSymbol(), x + 7, currentY);
            if (birthDate != null) {
                this.graphics.drawString(birthDate.getShortReportValue(), x + 13, currentY);
                currentY += 10;
            }
            if (birthPlace != null) {
                this.graphics.drawString(birthPlace.format(this.getPlaceDisplayFormat()).replaceAll("^(,|(, ))*", "").trim(), x + 13, currentY);
                currentY += 10;
            }
        }
        if (deathDate != null || deathPlace != null) {
            GraphicsTreeElements.centerString(this.graphics, TextOptions.getInstance().getDeathSymbol(), x + 7, currentY);
            if (deathDate != null) {
                this.graphics.drawString(deathDate.getShortReportValue(), x + 13, currentY);
                currentY += 10;
            }
            if (deathPlace != null) {
                this.graphics.drawString(deathPlace.format(this.getPlaceDisplayFormat()).replaceAll("^(,|(, ))*", "").trim(), x + 13, currentY);
                currentY += 10;
            }
            if (deathDate == null && deathPlace == null) {
                currentY += 10;
            }
        }
        if (occupations != null && occupations.length > 0) {
            for (int j = 0; j < Math.min(occupations.length, this.number_occupation); ++j) {
                this.graphics.drawString(occupations[j].getDisplayValue(), x + 7, currentY);
                currentY += 10;
            }
        }
        if (this.draw_sex_symbols) {
            int symbolX = x + dataWidth - 14;
            int symbolY = y + indibox.height - 5;
            this.graphics.setFont(sexSymbolFont);
            this.graphics.drawString(GraphicsTreeElements.getSexSymbol(i.getSex()), symbolX, symbolY);
        }
        if (this.draw_indi_ids || this.draw_indi_sosas) {
            this.graphics.setFont(this.idFont);
            this.graphics.drawString(this.getIdString(i), x + 7, y + indibox.height - 4);
        }
        if (imageWidth > 0) {
            AffineTransform transform = null;
            double scale = 1.0;
            if (this.high_quality_images) {
                transform = this.graphics.getTransform();
                this.graphics.scale(0.25, 0.25);
                scale = 4.0;
            }
            MediaRenderer.render((Graphics)this.graphics, (Rectangle)new Rectangle((int)((double)x + (double)dataWidth * scale), y, (int)((double)imageWidth * scale), (int)((double)imageHeight * scale)), (Property)i);
            if (this.high_quality_images) {
                this.graphics.setTransform(transform);
            }
        }
        this.graphics.setClip(oldClip);
        this.graphics.draw(box);
    }

    @Override
    public void drawFamBox(FamBox fambox, int x, int y) {
        this.checkFont();
        if (!this.graphics.hitClip(x, y, fambox.width, fambox.height)) {
            return;
        }
        Fam f = fambox.family;
        Color color = this.getBoxColor(fambox.gen);
        RoundRectangle2D.Double box = new RoundRectangle2D.Double(x, y, fambox.width, fambox.height, 5.0, 5.0);
        this.graphics.setColor(color);
        this.graphics.fill(box);
        this.graphics.setColor(Color.BLACK);
        Shape oldClip = this.graphics.getClip();
        this.graphics.clip(box);
        int currentY = y + 12;
        this.graphics.setFont(this.detailsFont);
        PropertyDate marriageDate = null;
        PropertyDate divorceDate = null;
        PropertyPlace marriagePlace = null;
        PropertyPlace divorcePlace = null;
        if (this.draw_dates) {
            marriageDate = f.getMarriageDate();
            if (marriageDate != null && !marriageDate.isValid()) {
                marriageDate = null;
            }
            if ((divorceDate = f.getDivorceDate()) != null && !divorceDate.isValid()) {
                divorceDate = null;
            }
        }
        if (this.draw_places) {
            marriagePlace = (PropertyPlace)f.getProperty(PATH_FAMMARRPLAC);
            if (marriagePlace != null && marriagePlace.getDisplayValue().equals("")) {
                marriagePlace = null;
            }
            if ((divorcePlace = (PropertyPlace)f.getProperty(PATH_FAMDIVPLAC)) != null && divorcePlace.getDisplayValue().equals("")) {
                divorcePlace = null;
            }
        }
        if (f.getMarriageDate() != null) {
            GraphicsTreeElements.centerString(this.graphics, TextOptions.getInstance().getMarriageSymbol(), x + 13, currentY);
            if (marriageDate != null) {
                this.graphics.drawString(marriageDate.getShortReportValue(), x + 25, currentY);
                currentY += 10;
            }
            if (marriagePlace != null) {
                this.graphics.drawString(marriagePlace.format(this.getPlaceDisplayFormat()).replaceAll("^(,|(, ))*", "").trim(), x + 25, currentY);
                currentY += 10;
            }
            if (marriageDate == null && marriagePlace == null) {
                currentY += 10;
            }
        }
        if (this.draw_divorce && f.getDivorceDate() != null) {
            GraphicsTreeElements.centerString(this.graphics, TextOptions.getInstance().getDivorceSymbol(), x + 13, currentY);
            if (divorceDate != null) {
                this.graphics.drawString(divorceDate.getShortReportValue(), x + 25, currentY);
                currentY += 10;
            }
            if (divorcePlace != null) {
                this.graphics.drawString(divorcePlace.format(this.getPlaceDisplayFormat()).replaceAll("^(,|(, ))*", "").trim(), x + 25, currentY);
                currentY += 10;
            }
            if (divorceDate == null && divorcePlace == null) {
                currentY += 10;
            }
        }
        if (this.draw_fam_ids) {
            this.graphics.setFont(this.idFont);
            this.graphics.drawString(f.getId(), x + 8, y + fambox.height - 4);
        }
        if (fambox.indexTotal >= this.min_fam_index) {
            this.graphics.setFont(this.idFont);
            GraphicsTreeElements.alignRightString(this.graphics, "#" + fambox.index + "/" + fambox.indexTotal, x + fambox.width - 4, y + fambox.height - 4);
        }
        this.graphics.setClip(oldClip);
        this.graphics.draw(box);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawDashedLine(int x1, int y1, int x2, int y2) {
        Stroke oldStroke = this.graphics.getStroke();
        this.graphics.setStroke(DASHED_STROKE);
        this.graphics.drawLine(x1, y1, x2, y2);
        this.graphics.setStroke(oldStroke);
    }

    @Override
    public void header(int width, int height) {
        this.graphics.setStroke(new BasicStroke(2.0f));
        this.graphics.setBackground(Color.WHITE);
        this.graphics.clearRect(0, 0, width, height);
    }

    @Override
    public void footer() {
    }

    public static void centerString(Graphics2D graphics, String text, int x, int y) {
        int width = GraphicsTreeElements.getTextWidth(text, graphics.getFont(), graphics);
        graphics.drawString(text, x - width / 2, y);
    }

    public static void alignRightString(Graphics2D graphics, String text, int x, int y) {
        int width = GraphicsTreeElements.getTextWidth(text, graphics.getFont(), graphics);
        graphics.drawString(text, x - width, y);
    }

    public static int getTextWidth(String text, Font font, Graphics2D graphics) {
        FontRenderContext fontRenderContext = FONT_RENDER_CONTEXT;
        if (graphics != null) {
            fontRenderContext = graphics.getFontRenderContext();
        }
        int width = (int)font.getStringBounds(text, fontRenderContext).getWidth();
        if (!text.isEmpty() && width == 0) {
            width = (int)font.deriveFont(1).getStringBounds(text, fontRenderContext).getWidth();
        }
        return width;
    }

    private static int getTextWidth(String text, Font font) {
        return GraphicsTreeElements.getTextWidth(text, font, null);
    }

    private static String getSexSymbol(int sex) {
        if (sex == 1) {
            return MALE_SYMBOL;
        }
        if (sex == 2) {
            return FEMALE_SYMBOL;
        }
        return UNKNOWN_SYMBOL;
    }

    private Color getBoxColor(int gen) {
        if (!this.use_colors) {
            return Color.WHITE;
        }
        if (gen == 0) {
            return this.colorManager.getBoxColors()[this.colorManager.getColorGenerations()];
        }
        if (gen < 0) {
            return this.colorManager.getBoxColors()[-((-gen - 1) % this.colorManager.getColorGenerations()) + this.colorManager.getColorGenerations() - 1];
        }
        return this.colorManager.getBoxColors()[(gen - 1) % this.colorManager.getColorGenerations() + this.colorManager.getColorGenerations() + 1];
    }

    private String[] getFirstNames(Indi indi) {
        String firstName = indi.getFirstName();
        if (this.max_names <= 0 && this.max_names_per_line <= 0) {
            return new String[]{firstName};
        }
        if (firstName.trim().equals("")) {
            return new String[]{""};
        }
        String[] names = firstName.split("  *");
        int namesCount = names.length;
        if (this.max_names > 0 && this.max_names < namesCount) {
            namesCount = this.max_names;
        }
        int linesCount = 1;
        if (this.max_names_per_line > 0) {
            linesCount = (namesCount - 1) / this.max_names_per_line + 1;
        }
        String[] lines = new String[linesCount];
        for (int j = 0; j < linesCount; ++j) {
            int n;
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < this.max_names_per_line && (n = j * this.max_names_per_line + k) < namesCount; ++k) {
                sb.append(names[n]).append(" ");
            }
            lines[j] = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
        }
        return lines;
    }

    @Override
    public void getIndiBoxSize(IndiBox indibox) {
        int localWidth;
        String[] firstNames;
        PropertyPlace deathPlace;
        this.checkFont();
        Indi i = indibox.individual;
        indibox.height = 64;
        indibox.width = this.shrink_boxes ? 50 : 110;
        int lines = 0;
        if (this.display_titles) {
            Property[] titles = i.getProperties(PATH_INDITITL);
            for (int j = 0; j < Math.min(titles.length, this.number_titles); ++j) {
                if (j == 0 & this.draw_title) continue;
                ++lines;
            }
        }
        if (this.draw_dates && i.getBirthDateOption() != null && i.getBirthDateOption().isValid()) {
            ++lines;
        }
        PropertyPlace birthPlace = i.getBirthPlaceOption();
        if (this.draw_places && birthPlace != null && !birthPlace.getDisplayValue().equals("")) {
            ++lines;
        }
        if ((deathPlace = i.getDeathPlaceOption()) != null && deathPlace.getDisplayValue().equals("")) {
            deathPlace = null;
        }
        if (i.getDeathDateOption() != null || deathPlace != null) {
            ++lines;
            if (this.draw_dates && this.draw_places && i.getDeathDateOption() != null && i.getDeathDateOption().isValid() && deathPlace != null) {
                ++lines;
            }
        }
        if (this.draw_occupation) {
            Property[] occupations = i.getProperties(PATH_INDIOCCU);
            lines = occupations.length > this.number_occupation ? (lines += this.number_occupation) : (lines += occupations.length);
        }
        if (lines - 2 > 0) {
            indibox.height += (lines - 2) * 10;
        }
        int width = 0;
        for (String firstName : firstNames = this.getFirstNames(i)) {
            int w2 = GraphicsTreeElements.getTextWidth(firstName, this.nameFont);
            width = width > w2 ? width : w2;
        }
        indibox.height += (firstNames.length - 1) * 12;
        if (this.draw_name_suffix && i.getNameSuffix() != null && i.getNameSuffix().length() > 0) {
            indibox.height += 12;
        }
        if (width + 10 > indibox.width) {
            indibox.width = width + 10;
        }
        String lastName = "";
        PropertyName prop = i.getNameProperty();
        if (prop != null) {
            if (prop.getSurnamePrefix() != null) {
                lastName = prop.getSurnamePrefix() + " ";
            }
            lastName = lastName + prop.getLastName();
        }
        if ((width = this.display_titles && this.draw_title && i.getProperty(PATH_INDITITL) != null ? GraphicsTreeElements.getTextWidth(i.getProperty(PATH_INDITITL).getDisplayValue() + " " + lastName, this.nameFont) : GraphicsTreeElements.getTextWidth(lastName, this.nameFont)) + 10 > indibox.width) {
            indibox.width = width + 10;
        }
        if ((width = GraphicsTreeElements.getTextWidth(i.getNameSuffix(), this.nameFont)) + 10 > indibox.width) {
            indibox.width = width + 10;
        }
        if (this.display_titles) {
            Property[] titles = i.getProperties(PATH_INDITITL);
            width = 0;
            for (int j = 0; j < Math.min(titles.length, this.number_titles); ++j) {
                if (j == 0 && this.draw_title || (localWidth = GraphicsTreeElements.getTextWidth(titles[j].getDisplayValue(), this.nameFont)) <= width) continue;
                width = localWidth;
            }
            if (width + 14 + 10 > indibox.width) {
                indibox.width = width + 14 + 10;
            }
        }
        if (i.getBirthDateOption() != null && (width = GraphicsTreeElements.getTextWidth(i.getBirthDateOption().getDisplayValue(), this.detailsFont)) + 13 + 10 > indibox.width) {
            indibox.width = width + 13 + 10;
        }
        if (i.getDeathDateOption() != null && (width = GraphicsTreeElements.getTextWidth(i.getDeathDateOption().getDisplayValue(), this.detailsFont)) + 13 + 10 > indibox.width) {
            indibox.width = width + 13 + 10;
        }
        if (this.draw_places) {
            if (birthPlace != null && (width = GraphicsTreeElements.getTextWidth(birthPlace.format(this.getPlaceDisplayFormat()).replaceAll("^(,|(, ))*", "").trim(), this.detailsFont)) + 13 + 10 > indibox.width) {
                indibox.width = width + 13 + 10;
            }
            if (deathPlace != null && (width = GraphicsTreeElements.getTextWidth(deathPlace.format(this.getPlaceDisplayFormat()).replaceAll("^(,|(, ))*", "").trim(), this.detailsFont)) + 13 + 10 > indibox.width) {
                indibox.width = width + 13 + 10;
            }
        }
        if (this.draw_occupation) {
            Property[] occupations = i.getProperties(PATH_INDIOCCU);
            width = 0;
            for (int j = 0; j < Math.min(occupations.length, this.number_occupation); ++j) {
                localWidth = GraphicsTreeElements.getTextWidth(occupations[j].getDisplayValue(), this.detailsFont);
                if (localWidth <= width) continue;
                width = localWidth;
            }
            if (width + 14 + 10 > indibox.width) {
                indibox.width = width + 14 + 10;
            }
        }
        if (this.draw_indi_ids || this.draw_indi_sosas) {
            width = GraphicsTreeElements.getTextWidth(this.getIdString(i), this.idFont);
            if (this.draw_sex_symbols) {
                width += 24;
            }
            if (width + 8 + 10 > indibox.width) {
                indibox.width = width + 7 + 10;
            }
        }
        if (this.draw_images) {
            Dimension d = MediaRenderer.getSize((Property)i);
            if (d.width > 0 && d.height > 0) {
                int newWidth = d.width * 64 / d.height;
                indibox.width = newWidth < 50 ? (indibox.width += newWidth) : (indibox.width += 50);
            }
        }
    }

    @Override
    public void getFamBoxSize(FamBox fambox) {
        int width;
        this.checkFont();
        Fam f = fambox.family;
        fambox.width = 100;
        fambox.height = 27;
        int lines = 0;
        PropertyPlace marriagePlace = (PropertyPlace)f.getProperty(PATH_FAMMARRPLAC);
        if (f.getMarriageDate() != null) {
            ++lines;
            if (this.draw_dates && this.draw_places && f.getMarriageDate().isValid() && marriagePlace != null && !marriagePlace.getDisplayValue().equals("")) {
                ++lines;
            }
        }
        PropertyPlace divorcePlace = (PropertyPlace)f.getProperty(PATH_FAMDIVPLAC);
        if (this.draw_divorce && f.getDivorceDate() != null) {
            ++lines;
            if (this.draw_dates && this.draw_places && f.getDivorceDate().isValid() && divorcePlace != null && !divorcePlace.getDisplayValue().equals("")) {
                ++lines;
            }
        }
        if (lines - 1 > 0) {
            fambox.height += (lines - 1) * 10;
        }
        if (f.getMarriageDate() != null && (width = GraphicsTreeElements.getTextWidth(f.getMarriageDate().getDisplayValue(), this.detailsFont)) + 25 + 10 > fambox.width) {
            fambox.width = width + 25 + 10;
        }
        if (this.draw_divorce && f.getDivorceDate() != null && (width = GraphicsTreeElements.getTextWidth(f.getDivorceDate().getDisplayValue(), this.detailsFont)) + 25 + 10 > fambox.width) {
            fambox.width = width + 25 + 10;
        }
        if (this.draw_places) {
            if (marriagePlace != null && (width = GraphicsTreeElements.getTextWidth(marriagePlace.format(this.getPlaceDisplayFormat()).replaceAll("^(,|(, ))*", "").trim(), this.detailsFont)) + 35 + 10 > fambox.width) {
                fambox.width = width + 35 + 10;
            }
            if (this.draw_divorce && divorcePlace != null && (width = GraphicsTreeElements.getTextWidth(divorcePlace.format(this.getPlaceDisplayFormat()).replaceAll("^(,|(, ))*", "").trim(), this.detailsFont)) + 35 + 10 > fambox.width) {
                fambox.width = width + 35 + 10;
            }
        }
    }

    private String getIdString(Indi i) {
        return (this.draw_indi_ids ? i.getId() : "") + (this.draw_indi_ids && this.draw_indi_sosas ? " / " : "") + (this.draw_indi_sosas ? i.getSosaString() : "");
    }

    private String getPlaceDisplayFormat() {
        if (this.place_display_format.equals(this.translator.translate("place_display_format.full"))) {
            return "all";
        }
        return this.place_display_format;
    }

    static {
        String[] candidateFontNames;
        PATH_INDIOCCU = new TagPath("INDI:OCCU");
        PATH_INDITITL = new TagPath("INDI:TITL");
        PATH_FAMMARRPLAC = new TagPath("FAM:MARR:PLAC");
        PATH_FAMDIVPLAC = new TagPath("FAM:DIV:PLAC");
        FONT_RENDER_CONTEXT = new FontRenderContext(null, false, false);
        DASHED_STROKE = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{3.0f, 6.0f}, 0.0f);
        sexSymbolFont = new Font("SansSerif", 0, 10);
        for (String candidateFontName : candidateFontNames = new String[]{"sansserif", "apple symbol", "symbol"}) {
            Font candidateFont = new Font(candidateFontName, 0, 10);
            if (!candidateFont.canDisplay(MALE_SYMBOL.charAt(0))) continue;
            sexSymbolFont = candidateFont;
            break;
        }
    }
}

