/*
 * Decompiled with CFR 0.152.
 */
package gj.layout.tree;

import gj.layout.tree.Contour;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Orientation {
    private AffineTransform transform;
    private AffineTransform inverse;

    protected Orientation(double theta) {
        theta = theta * 2.0 * Math.PI / 360.0;
        try {
            this.transform = AffineTransform.getRotateInstance(theta);
            this.inverse = this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    protected Rectangle getBounds(Contour c) {
        GeneralPath gp = new GeneralPath(new Rectangle(c.west, c.north, c.east - c.west, c.south - c.north));
        gp.transform(this.transform);
        return gp.getBounds();
    }

    protected Contour getContour(Rectangle2D r2d) {
        GeneralPath gp = new GeneralPath(r2d);
        gp.transform(this.inverse);
        Rectangle r = gp.getBounds();
        return new Contour(r.y, r.x, r.x + r.width, r.y + r.height);
    }

    public Point getPoint(int lat, int lon) {
        Point result = new Point(lon, lat);
        this.transform.transform(result, result);
        return result;
    }

    public int getLatitude(Point2D p) {
        Point result = new Point();
        this.inverse.transform(p, result);
        return result.y;
    }

    public int getLongitude(Point2D p) {
        Point result = new Point();
        this.inverse.transform(p, result);
        return result.x;
    }
}

