/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.console.Console;
import ancestris.modules.gedcomcompare.GedcomComparePlugin;
import ancestris.modules.gedcomcompare.SearchUsers;
import ancestris.modules.gedcomcompare.communication.Comm;
import ancestris.modules.gedcomcompare.communication.UserProfile;
import ancestris.modules.gedcomcompare.options.GedcomCompareOptionsPanel;
import ancestris.modules.gedcomcompare.tools.AssistanceAction;
import ancestris.modules.gedcomcompare.tools.ComparedGedcom;
import ancestris.modules.gedcomcompare.tools.ComparisonFrame;
import ancestris.modules.gedcomcompare.tools.ConnectedGedcomsPopup;
import ancestris.modules.gedcomcompare.tools.ConnectedUserFrame;
import ancestris.modules.gedcomcompare.tools.DataFrame;
import ancestris.modules.gedcomcompare.tools.DialogAssistant;
import ancestris.modules.gedcomcompare.tools.DisplayStatsAction;
import ancestris.modules.gedcomcompare.tools.GedcomComparePanel;
import ancestris.modules.gedcomcompare.tools.LocalGedcomFrame;
import ancestris.modules.gedcomcompare.tools.LocalGedcomsPopup;
import ancestris.modules.gedcomcompare.tools.RearrangeAction;
import ancestris.modules.gedcomcompare.tools.STFactory;
import ancestris.modules.gedcomcompare.tools.STMapCapsule;
import ancestris.modules.gedcomcompare.tools.STMapEventsCapsule;
import ancestris.modules.gedcomcompare.tools.SearchAction;
import ancestris.modules.gedcomcompare.tools.SettingsAction;
import ancestris.modules.gedcomcompare.tools.StartSharingAllToggle;
import ancestris.modules.gedcomcompare.tools.StatsPanel;
import ancestris.modules.gedcomcompare.tools.StopSharingAllToggle;
import ancestris.swing.ToolBar;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.util.EnvironmentChecker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.awt.DropDownButtonFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class GedcomCompareTopComponent
extends TopComponent {
    private static final String PREFERRED_ID = "GedcomCompareTopComponent";
    private static final Logger LOG = Logger.getLogger("ancestris.gedcomcompare");
    private static Console console;
    private static GedcomComparePlugin gedcomComparePlugin;
    private static GedcomCompareTopComponent instance;
    private static final String ICON_PATH = "ancestris/modules/gedcomcompare/resources/comparegedcom.png";
    private static final String ICON_PATH_ON = "ancestris/modules/gedcomcompare/resources/comparegedcomON.png";
    public final ImageIcon ROTATING_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/rotating16.gif"));
    public final ImageIcon SELECTEDON_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/selected.png"));
    public final ImageIcon PRIVATEON_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/private.png"));
    private final ImageIcon INDI_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/indi.png"));
    private final ImageIcon FAM_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/fam.png"));
    private final ImageIcon GEOST_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/geost.png"));
    private final ImageIcon STAR_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/star.png"));
    private final ImageIcon CONM_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/connm.png"));
    private final ImageIcon CONU_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/connu.png"));
    private final ImageIcon CONOVERLAP_ICON = new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/connoverlap.png"));
    private List<LocalGedcomFrame> localGedcomFrames = null;
    private List<ComparisonFrame> comparisonFrames = null;
    private List<ConnectedUserFrame> connectedUserFrames = null;
    private final String TOOLBAR_SPACE = "  ";
    private String titleComponent = "";
    private boolean isComponentCreated = false;
    private JToolBar toolbar = null;
    private GedcomComparePanel desktopPanel = null;
    private StartSharingAllToggle startSharingToggle;
    private StopSharingAllToggle stopSharingToggle;
    private SearchAction searchButton = null;
    private JLabel memberInProgress = null;
    private DisplayStatsAction statsButton = null;
    private SettingsAction settings = null;
    private LocalGedcomsPopup localGedcomsPopup = null;
    private JButton gedcomsButton = null;
    private ConnectedGedcomsPopup connectedUsersPopup = null;
    private Comm commHandler = null;
    private boolean isBusy = false;
    private boolean sharing = false;
    private String commPseudo = "";
    private String[] commMyInfo = new String[Comm.COMM_PREF + Comm.COMM_NBST];
    private Timer swingTimer;
    private final int REFRESH_DELAY = 50;
    private SearchUsers searchThread;
    private StatsPanel stats = null;
    private JLabel statsConnectedUsers = null;
    private JLabel statsIndis = null;
    private JLabel statsFams = null;
    private JLabel statsSTs = null;
    private JLabel statsAreas = null;
    private JLabel statsReceivedConnections = null;
    private JLabel statsReceivedUniqueUsers = null;
    private JLabel statsUniqueOverlaps = null;
    private DialogManager dialogManager = null;
    private DialogAssistant dialogAssistant = null;

    public static synchronized GedcomCompareTopComponent getDefault() {
        if (instance == null) {
            instance = new GedcomCompareTopComponent();
        }
        return instance;
    }

    public int getPersistenceType() {
        return 1;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void open() {
        Mode mode = WindowManager.getDefault().findMode("ancestris-output");
        if (mode != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    public GedcomCompareTopComponent() {
        if (instance == null) {
            instance = this;
        }
        if (gedcomComparePlugin == null) {
            gedcomComparePlugin = new GedcomComparePlugin();
        }
        this.titleComponent = NbBundle.getMessage(GedcomCompareTopComponent.class, (String)"CTL_GedcomCompareTopComponent");
        this.setName(this.titleComponent);
        this.setToolTipText(NbBundle.getMessage(GedcomCompareTopComponent.class, (String)"HINT_GedcomCompareTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.setLayout(new BorderLayout());
        this.statsConnectedUsers = new JLabel("");
        this.statsIndis = new JLabel("", this.INDI_ICON, 11);
        this.statsFams = new JLabel("", this.FAM_ICON, 11);
        this.statsSTs = new JLabel("", this.GEOST_ICON, 11);
        this.statsAreas = new JLabel("", this.STAR_ICON, 11);
        this.statsReceivedConnections = new JLabel("", this.CONM_ICON, 11);
        this.statsReceivedUniqueUsers = new JLabel("", this.CONU_ICON, 11);
        this.statsUniqueOverlaps = new JLabel("", this.CONOVERLAP_ICON, 11);
        this.putClientProperty("print.printable", Boolean.TRUE);
    }

    public void componentOpened() {
        AncestrisPlugin.register((Object)gedcomComparePlugin);
        if (!this.isComponentCreated) {
            this.initMainPanel();
            this.initLocalGedcoms();
            this.initConnectedUsers();
            this.initToolbar();
            this.initSwingTimerRefreshUsers();
            this.createDialogManager();
        }
        this.isComponentCreated = true;
        if (this.dialogAssistant.getShowAssistant()) {
            this.updateDialogManager(true);
        }
    }

    public boolean canClose() {
        this.isComponentCreated = false;
        if (this.sharing) {
            LOG.log(Level.FINE, "Closing component connection.");
            this.stopSharing();
        }
        if (this.swingTimer != null) {
            this.swingTimer.stop();
            this.swingTimer = null;
        }
        this.updateIcon();
        if (this.desktopPanel != null) {
            this.desktopPanel.removeAll();
            this.remove(this.desktopPanel);
            this.desktopPanel = null;
        }
        AncestrisPlugin.unregister((Object)gedcomComparePlugin);
        return super.canClose();
    }

    private void initMainPanel() {
        if (console == null) {
            console = new Console(NbBundle.getMessage(GedcomCompareTopComponent.class, (String)"CTL_GedcomCompareTopComponent"));
        }
        if (this.desktopPanel == null) {
            this.desktopPanel = new GedcomComparePanel();
            this.add(this.desktopPanel);
            this.desktopPanel.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    GedcomCompareTopComponent.this.rearrangeWindows(false);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }
    }

    private void initLocalGedcoms() {
        LOG.log(Level.FINE, "Initializing gedcoms panels.");
        this.localGedcomFrames = new ArrayList<LocalGedcomFrame>();
        boolean isFirst = true;
        for (Context context : GedcomDirectory.getDefault().getContexts()) {
            this.localGedcomFrames.add(new LocalGedcomFrame(this, context.getGedcom(), isFirst ? DataFrame.GEDCOM_TYPE_LOCAL_MAIN : DataFrame.GEDCOM_TYPE_LOCAL_OTHER));
            isFirst = false;
        }
    }

    private void initConnectedUsers() {
        LOG.log(Level.FINE, "Creating communication handler.");
        this.commHandler = new Comm(this);
        this.connectedUserFrames = new ArrayList<ConnectedUserFrame>();
        this.updateConnectedUsers(false);
        NbPreferences.forModule(GedcomCompareOptionsPanel.class).addPreferenceChangeListener(evt -> {
            if (evt.getKey().equals("Photo")) {
                this.resetProfile();
            }
        });
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.toolbar != null && comp == this.toolbar) {
            int orientation = 0;
            if ("West".equals(constraints) || "East".equals(constraints)) {
                orientation = 1;
            }
            NbPreferences.forModule(GedcomCompareTopComponent.class).put("ToolbarBorderLayout", (String)constraints);
            this.toolbar.setOrientation(orientation);
        }
        super.addImpl(comp, constraints, index);
    }

    private void initToolbar() {
        LOG.log(Level.FINE, "Initializing main panel.");
        if (this.toolbar == null) {
            this.toolbar = new ToolBar();
            this.localGedcomsPopup = new LocalGedcomsPopup(this.localGedcomFrames);
            this.gedcomsButton = DropDownButtonFactory.createDropDownButton((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/gedcom.png")), (JPopupMenu)this.localGedcomsPopup);
            this.gedcomsButton.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_GedcomsList"));
            this.gedcomsButton.setEnabled(!this.localGedcomFrames.isEmpty());
            this.toolbar.add(this.gedcomsButton);
            this.toolbar.add(new JLabel("  "));
            this.toolbar.addSeparator();
            this.toolbar.add(new JLabel("  "));
            this.connectedUsersPopup = new ConnectedGedcomsPopup(this.connectedUserFrames);
            JButton membersButton = DropDownButtonFactory.createDropDownButton((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/gedcomcompare/resources/friend16.png")), (JPopupMenu)this.connectedUsersPopup);
            membersButton.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_UsersList"));
            membersButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean ret = GedcomCompareTopComponent.this.updateConnectedUsers(false);
                    if (ret) {
                        GedcomCompareTopComponent.this.updateStatsDisplay();
                        if (GedcomCompareTopComponent.this.commHandler != null) {
                            GedcomCompareTopComponent.this.commHandler.sendPing();
                        }
                    }
                }
            });
            this.toolbar.add(membersButton);
            this.toolbar.add(this.statsConnectedUsers);
            this.toolbar.add(new JLabel("  "));
            this.startSharingToggle = new StartSharingAllToggle(this, this.sharing);
            this.toolbar.add(this.startSharingToggle);
            this.stopSharingToggle = new StopSharingAllToggle(this, !this.sharing);
            this.toolbar.add(this.stopSharingToggle);
            this.toolbar.add(new JLabel("  "));
            this.toolbar.addSeparator();
            this.toolbar.add(new JLabel("  "));
            this.searchButton = new SearchAction(this);
            this.searchButton.setOff();
            this.toolbar.add((Action)((Object)this.searchButton));
            this.toolbar.add(new JLabel("  "));
            this.memberInProgress = new JLabel("");
            this.memberInProgress.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_UserInProgress"));
            this.toolbar.add(this.memberInProgress);
            this.toolbar.add(new JLabel("  "));
            this.toolbar.add(new JLabel("  "));
            this.toolbar.addSeparator();
            this.toolbar.add(new JLabel("  "));
            this.statsButton = new DisplayStatsAction(this);
            this.statsButton.setEnabled(true);
            this.toolbar.add((Action)((Object)this.statsButton));
            this.toolbar.add(new JLabel("  "));
            this.statsIndis.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_statsIndis"));
            this.toolbar.add(this.statsIndis);
            this.toolbar.add(new JLabel("  "));
            this.statsFams.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_statsFams"));
            this.toolbar.add(this.statsFams);
            this.toolbar.add(new JLabel("  "));
            this.statsSTs.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_statsSTs"));
            this.toolbar.add(this.statsSTs);
            this.toolbar.add(new JLabel("  "));
            this.statsAreas.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_statsAreas"));
            this.toolbar.add(this.statsAreas);
            this.toolbar.add(new JLabel("  "));
            this.toolbar.add(new JLabel("  "));
            this.toolbar.add(this.statsReceivedConnections);
            this.toolbar.add(new JLabel("  "));
            this.statsReceivedConnections.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_statsReceivedConnections"));
            this.toolbar.add(this.statsReceivedUniqueUsers);
            this.toolbar.add(new JLabel("  "));
            this.statsReceivedUniqueUsers.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_statsReceivedUniqueUsers"));
            this.toolbar.add(this.statsUniqueOverlaps);
            this.toolbar.add(new JLabel("  "));
            this.statsUniqueOverlaps.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_statsUniqueOverlaps"));
            this.toolbar.add((Component)new Box.Filler(null, null, null), "growx, pushx, center");
            this.toolbar.addSeparator();
            this.toolbar.add((Action)((Object)new AssistanceAction(this)));
            this.toolbar.add((Action)((Object)new RearrangeAction(this)));
            this.settings = new SettingsAction();
            this.toolbar.add((Action)((Object)this.settings));
            this.add(this.toolbar, NbPreferences.forModule(GedcomCompareTopComponent.class).get("ToolbarBorderLayout", "North"));
        }
        this.updateStatsDisplay();
        this.createComparisonFrames();
        this.rearrangeWindows(true);
    }

    private void initSwingTimerRefreshUsers() {
        LOG.log(Level.FINE, "Creating refreshing toolbar swing timer.");
        this.swingTimer = new Timer(50000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ok = GedcomCompareTopComponent.this.updateConnectedUsers(true);
                if (!ok && GedcomCompareTopComponent.this.isSharingOn()) {
                    GedcomCompareTopComponent.this.stopSharing();
                }
            }
        });
        this.swingTimer.setInitialDelay(50000);
        this.swingTimer.start();
    }

    public void rearrangeWindows(final boolean create) {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                GedcomCompareTopComponent.this.desktopPanel.placeFrames(GedcomCompareTopComponent.this.getComparedFrames(), GedcomCompareTopComponent.this.comparisonFrames, create);
            }
        });
    }

    public void createComparisonFrames() {
        if (this.comparisonFrames == null) {
            this.comparisonFrames = new ArrayList<ComparisonFrame>();
        }
        if (this.localGedcomFrames.size() == 0 || this.localGedcomFrames.size() + this.connectedUserFrames.size() < 2) {
            return;
        }
        LocalGedcomFrame mainGedcom = this.getMain();
        if (mainGedcom != null) {
            for (DataFrame dataFrame : this.getComparedFrames()) {
                if (dataFrame == mainGedcom) continue;
                ComparisonFrame cf = this.getComparisonFrame(mainGedcom, (ComparedGedcom)((Object)dataFrame));
                if (cf == null) {
                    cf = new ComparisonFrame(this, mainGedcom, (ComparedGedcom)((Object)dataFrame));
                    this.comparisonFrames.add(cf);
                    this.desktopPanel.addFrame(cf);
                    continue;
                }
                cf.updateMain(mainGedcom);
            }
        }
    }

    public List<LocalGedcomFrame> getLocalGedcoms() {
        return this.localGedcomFrames;
    }

    private List<? extends DataFrame> getComparedFrames() {
        ArrayList<DataFrame> ret = new ArrayList<DataFrame>();
        if (this.localGedcomFrames != null) {
            ret.addAll(this.localGedcomFrames);
        }
        if (this.connectedUserFrames != null) {
            ret.addAll(this.connectedUserFrames);
        }
        return ret;
    }

    public void gedcomOpened(Gedcom gedcom) {
        LOG.log(Level.FINE, "Gedcom opened... (" + gedcom.getName() + ")");
        if (!this.isComponentCreated) {
            return;
        }
        LocalGedcomFrame newGedcomFrame = new LocalGedcomFrame(this, gedcom, DataFrame.GEDCOM_TYPE_LOCAL_OTHER);
        this.localGedcomFrames.add(newGedcomFrame);
        if (this.localGedcomFrames.size() == 1) {
            newGedcomFrame.setMain(true);
        }
        this.createComparisonFrames();
        this.desktopPanel.addFrame(newGedcomFrame);
        this.rearrangeWindows(false);
        this.gedcomsButton.setEnabled(!this.localGedcomFrames.isEmpty());
        this.localGedcomsPopup.updateItems();
        this.updateIcon();
        this.updateStatsDisplay();
    }

    public void gedcomClosed(Gedcom gedcom) {
        LOG.log(Level.FINE, "Gedcom closed... (" + gedcom.getName() + ")");
        if (!this.isComponentCreated) {
            return;
        }
        for (LocalGedcomFrame sg : this.localGedcomFrames) {
            if (sg.getGedcom() != gedcom) continue;
            this.removeGedcom(sg);
            break;
        }
        this.gedcomsButton.setEnabled(!this.localGedcomFrames.isEmpty());
        this.localGedcomsPopup.updateItems();
        this.updateIcon();
        this.updateStatsDisplay();
        if (this.sharing && this.localGedcomFrames.isEmpty()) {
            LOG.log(Level.FINE, "Closing connection, no more gedcom to share.");
            this.stopSharing();
        }
    }

    private void removeGedcom(LocalGedcomFrame sg) {
        sg.close();
        this.desktopPanel.removeFrame(sg);
        this.desktopPanel.removeLink(sg);
        this.localGedcomFrames.remove(sg);
        if (this.comparisonFrames == null) {
            return;
        }
        ArrayList<ComparisonFrame> removedComparison = new ArrayList<ComparisonFrame>();
        for (ComparisonFrame frame : this.comparisonFrames) {
            if (!frame.contains(sg)) continue;
            removedComparison.add(frame);
        }
        for (ComparisonFrame frame : removedComparison) {
            this.desktopPanel.removeFrame(frame);
            this.desktopPanel.removeLink(frame);
            this.comparisonFrames.remove(frame);
        }
    }

    public void showUserFrame(ConnectedUserFrame user, boolean show) {
        if (show) {
            this.desktopPanel.showFrame(user, true);
            this.rearrangeWindows(false);
        } else {
            this.desktopPanel.showFrame(user, false);
            this.desktopPanel.removeLink(user);
            if (this.comparisonFrames == null) {
                return;
            }
            ArrayList<ComparisonFrame> removedComparison = new ArrayList<ComparisonFrame>();
            for (ComparisonFrame frame : this.comparisonFrames) {
                if (!frame.contains(user)) continue;
                removedComparison.add(frame);
            }
            for (ComparisonFrame frame : removedComparison) {
                this.desktopPanel.showFrame(frame, false);
                this.desktopPanel.removeLink(frame);
            }
            this.updateConnectedUsers(true);
        }
    }

    public LocalGedcomFrame getMain() {
        for (LocalGedcomFrame f : this.localGedcomFrames) {
            if (!f.isMain()) continue;
            return f;
        }
        return null;
    }

    public LocalGedcomFrame getOther() {
        for (LocalGedcomFrame f : this.localGedcomFrames) {
            if (f.isMain()) continue;
            return f;
        }
        return null;
    }

    private boolean getPrivacy() {
        LocalGedcomFrame gf = this.getMain();
        return gf != null ? gf.isPrivate() : false;
    }

    private ComparisonFrame getComparisonFrame(LocalGedcomFrame mainGedcom, ComparedGedcom frame) {
        for (ComparisonFrame f : this.comparisonFrames) {
            if (!f.contains(mainGedcom, frame)) continue;
            return f;
        }
        return null;
    }

    public void setFocusToComparisonFrame(DataFrame frame) {
        LocalGedcomFrame main = this.getMain();
        for (ComparisonFrame f : this.comparisonFrames) {
            if (!f.contains(main, (ComparedGedcom)((Object)frame))) continue;
            f.moveToFront();
            return;
        }
    }

    public ComparisonFrame getComparisonFrame(DataFrame frame) {
        LocalGedcomFrame main = this.getMain();
        for (ComparisonFrame f : this.comparisonFrames) {
            if (!f.contains(main, (ComparedGedcom)((Object)frame))) continue;
            return f;
        }
        return null;
    }

    private boolean existConnectedGedcomReady() {
        for (ConnectedUserFrame u : this.connectedUserFrames) {
            if (!u.isActive()) continue;
            return true;
        }
        return false;
    }

    private boolean existConnectedGedcomViewed() {
        for (ConnectedUserFrame u : this.connectedUserFrames) {
            if (!u.isActive() || !u.isViewed()) continue;
            return true;
        }
        return false;
    }

    private boolean existConnectedGedcomComplete() {
        for (ConnectedUserFrame u : this.connectedUserFrames) {
            if (!u.isActive() || !u.isComplete()) continue;
            return true;
        }
        return false;
    }

    public Comm getCommHandler() {
        return this.commHandler;
    }

    public List<ConnectedUserFrame> getConnectedUsers() {
        return this.connectedUserFrames;
    }

    public ConnectedUserFrame getUser(String memberToFind) {
        for (ConnectedUserFrame user : this.connectedUserFrames) {
            if (!user.getName().equals(memberToFind)) continue;
            return user;
        }
        return null;
    }

    public boolean updateConnectedUsers(boolean quiet) {
        List<Comm.User> newUsersList = this.commHandler.getConnectedUsers(quiet);
        if (newUsersList != null) {
            HashSet<ConnectedUserFrame> usedFrames = new HashSet<ConnectedUserFrame>();
            for (Comm.User newUser : newUsersList) {
                ConnectedUserFrame frame = null;
                for (ConnectedUserFrame currentUser : this.connectedUserFrames) {
                    if (!newUser.userProfile.pseudo.equals(currentUser.getUserProfile().pseudo)) continue;
                    frame = currentUser;
                }
                if (frame == null) {
                    frame = new ConnectedUserFrame(this, newUser);
                    this.connectedUserFrames.add(frame);
                    this.createComparisonFrames();
                    if (this.desktopPanel != null) {
                        this.desktopPanel.addFrame(frame);
                        this.showUserFrame(frame, frame.isIncluded());
                        this.rearrangeWindows(false);
                    }
                } else {
                    frame.updateInfo(newUser);
                }
                usedFrames.add(frame);
            }
            for (ConnectedUserFrame currentUser : this.connectedUserFrames) {
                if (usedFrames.contains(currentUser)) continue;
                currentUser.setActive(false);
            }
            this.updateConnectedUsersDisplay();
            this.updateStatsDisplay();
        }
        return newUsersList != null;
    }

    private void updateConnectedUsersDisplay() {
        String name;
        String nb;
        int n = this.connectedUserFrames.size();
        this.statsConnectedUsers.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TIP_UsersNumber", (Object)n));
        if (n > 0) {
            nb = " " + n + " ";
            name = this.titleComponent + " (" + n + ")";
        } else {
            nb = " ";
            name = this.titleComponent;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GedcomCompareTopComponent.this.statsConnectedUsers.setText(nb);
                instance.setDisplayName(name);
            }
        });
        if (this.connectedUsersPopup != null) {
            this.connectedUsersPopup.updateTable(this.connectedUserFrames);
        }
    }

    public boolean startSharing() {
        if (!this.isMyProfileOK(false)) {
            return false;
        }
        this.commPseudo = this.getPreferredPseudo();
        if (!this.isGedcomReady()) {
            return false;
        }
        this.commMyInfo = this.getMain().getSummary(this.commMyInfo.length);
        this.updateConnectedUsers(false);
        if (!this.commHandler.registerMe(this.commPseudo, this.commMyInfo)) {
            this.toggleOff();
            return false;
        }
        this.toggleOn();
        this.updateIcon();
        this.updateDialogManager();
        Utilities.playSound(((Object)((Object)this)).getClass(), (String)"resources/soundopen.wav");
        return true;
    }

    public boolean stopSharing() {
        this.stopMapsSearch();
        this.commHandler.unregisterMe(this.commPseudo);
        this.updateIcon();
        this.updateConnectedUsers(false);
        this.toggleOff();
        this.updateDialogManager();
        Utilities.playSound(((Object)((Object)this)).getClass(), (String)"resources/soundclose.wav");
        return true;
    }

    private void toggleOn() {
        this.isBusy = true;
        this.sharing = true;
        this.startSharingToggle.setToolTipText(true);
        this.stopSharingToggle.setToolTipText(false);
        this.dispatchShare(true);
        this.searchButton.setOn();
        this.isBusy = false;
    }

    private void toggleOff() {
        this.isBusy = true;
        this.sharing = false;
        this.startSharingToggle.setToolTipText(false);
        this.stopSharingToggle.setToolTipText(true);
        this.dispatchShare(false);
        this.searchButton.setOff();
        this.isBusy = false;
    }

    public void updateIcon() {
        SwingUtilities.invokeLater(() -> instance.setIcon(ImageUtilities.loadImage((String)(this.isSharingOn() ? ICON_PATH_ON : ICON_PATH), (boolean)true)));
    }

    private boolean isMyProfileOK(boolean quiet) {
        String error = "";
        error = this.getPreferredPseudo().equals("") ? NbBundle.getMessage(GedcomCompareOptionsPanel.class, (String)"ERR_NullPseudo") : GedcomCompareOptionsPanel.getProfileError();
        if (!error.isEmpty()) {
            if (!quiet) {
                DialogManager.create((String)"", (String)error).setOptionType(10).setMessageType(0).show();
                this.settings.displayOptionsPanel();
            }
            return false;
        }
        return true;
    }

    public UserProfile getMyProfile() {
        return GedcomCompareOptionsPanel.getProfile();
    }

    public void resetProfile() {
        if (this.commHandler != null) {
            this.commHandler.resetProfile();
        }
        if (this.isSharingOn()) {
            for (LocalGedcomFrame sg : this.localGedcomFrames) {
                sg.updatePhoto(true);
            }
        }
    }

    private boolean isGedcomReady() {
        if (this.localGedcomFrames != null && !this.localGedcomFrames.isEmpty()) {
            for (LocalGedcomFrame sg : this.localGedcomFrames) {
                if (!sg.isMain() || !sg.isReady()) continue;
                return true;
            }
        }
        DialogManager.create((String)"", (String)NbBundle.getMessage(GedcomCompareTopComponent.class, (String)"MSG_NoGedcomLoaded")).setOptionType(10).setMessageType(0).show();
        return false;
    }

    private void dispatchShare(boolean b) {
        if (this.localGedcomFrames == null) {
            return;
        }
        for (LocalGedcomFrame sg : this.localGedcomFrames) {
            sg.setOpen(b);
        }
        for (ConnectedUserFrame user : this.connectedUserFrames) {
            user.setOpen(b);
        }
    }

    public boolean isSharingOn() {
        return this.sharing;
    }

    public void checkSharingisOff() {
        if (this.sharing) {
            this.stopSharing();
            DialogManager.create((String)"", (String)NbBundle.getMessage(GedcomCompareTopComponent.class, (String)"MSG_CannotPerformWhileSharing")).setOptionType(10).setMessageType(1).show();
        }
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void launchMapsSearch() {
        this.searchThread = new SearchUsers(this, SearchUsers.SEARCH_TYPE_MAPS, null);
        this.searchThread.start();
    }

    public void launchMapsSearch(String user) {
        this.searchThread = new SearchUsers(this, SearchUsers.SEARCH_TYPE_MAPS, this.getUser(user));
        this.searchThread.start();
    }

    public void launchEventsSearch(String user) {
        this.searchThread = new SearchUsers(this, SearchUsers.SEARCH_TYPE_EVENTS, this.getUser(user));
        this.searchThread.start();
    }

    private void stopMapsSearch() {
        if (this.searchThread != null) {
            this.searchThread.stopGracefully();
        }
    }

    public void setRotatingIcon(boolean search) {
        if (search) {
            this.searchButton.setSearching();
        } else {
            this.searchButton.setOn();
        }
    }

    public void displaySearchedUser(String memberName) {
        Font font = this.memberInProgress.getFont();
        this.memberInProgress.setFont(font.deriveFont(2));
        this.memberInProgress.setText(memberName + (memberName.isEmpty() ? "" : "..."));
        this.updateStatsDisplay();
    }

    public String getPreferredPseudo() {
        return GedcomCompareOptionsPanel.getPseudo();
    }

    public String getRegisteredPseudo() {
        return this.getRegisteredPseudo(true);
    }

    public String getRegisteredPseudo(boolean escape) {
        return escape ? StringEscapeUtils.escapeHtml((String)this.commPseudo) : this.commPseudo;
    }

    public String getRegisteredIPAddress() {
        return this.getUser(this.commPseudo).getIPAddress();
    }

    public String getRegisteredPortAddress() {
        return this.getUser(this.commPseudo).getPortAddress();
    }

    public STMapCapsule getMapCapsule() {
        return STFactory.getSerializedSTMap(this.getMain().getMap());
    }

    public STMapEventsCapsule getMapEventsCapsule(ConnectedUserFrame user) {
        ComparisonFrame cf = this.getComparisonFrame(this.getMain(), user);
        Set<String> keys = cf.getIntersectionKeys();
        if (keys == null) {
            return new STMapEventsCapsule();
        }
        return STFactory.getSerializedSTMapEvents(this.getMain().getMap(), keys, this.getPrivacy());
    }

    public void updateUser(ConnectedUserFrame user, STMapCapsule mapCapsule) {
        LOG.log(Level.FINE, "Update user map - " + user.getTitle());
        user.setMap(STFactory.getUnserializedSTMap(mapCapsule));
    }

    public void updateUser(ConnectedUserFrame user, STMapEventsCapsule mapEventsCapsule) {
        LOG.log(Level.FINE, "Update user events - " + user.getTitle());
        user.updateMap(mapEventsCapsule);
    }

    public void updateUser(ConnectedUserFrame user, UserProfile userProfile) {
        LOG.log(Level.FINE, "Update user profile - " + user.getTitle());
        user.updateProfileInfo(userProfile);
    }

    public void addConnection() {
        LocalGedcomFrame mgf = this.getMain();
        mgf.addConnection();
    }

    public void mainHasChanged(Gedcom gedcom) {
        LOG.log(Level.FINE, "Main has changed");
        this.commHandler.resetMap();
        this.localGedcomFrames.forEach(lgf -> {
            if (lgf.isReady()) {
                lgf.setReady(true);
            }
        });
        LocalGedcomFrame mgf = this.getMain();
        if (mgf != null && mgf.getGedcom() == gedcom) {
            this.connectedUserFrames.forEach(user -> user.reset());
        }
    }

    public void activateMain() {
        this.requestActive();
        this.getMain().prepareGedcom();
    }

    public void updateStatsDisplay() {
        if (this.stats == null) {
            this.stats = new StatsPanel(this);
        } else {
            this.stats.calcValues();
        }
        this.statsIndis.setText("" + this.stats.getNbIndis());
        this.statsFams.setText("" + this.stats.getNbFams());
        this.statsSTs.setText("" + this.stats.getNbSTs());
        this.statsAreas.setText(this.stats.getMaxArea());
        this.statsReceivedConnections.setText("" + this.stats.getNbConnections());
        this.statsReceivedUniqueUsers.setText("" + this.stats.getNbUniqueUsers());
        this.statsUniqueOverlaps.setText("" + this.stats.getNbOverlaps());
        this.revalidate();
        this.repaint();
        this.updateDialogManager();
    }

    public void displayStats() {
        this.updateStatsDisplay();
        if (this.commHandler != null) {
            this.commHandler.sendStats(this.stats.getValues());
        }
        DialogManager.create((String)NbBundle.getMessage(StatsPanel.class, (String)"TITL_StatsPanel"), (JComponent)this.stats).setMessageType(-1).setDialogId(StatsPanel.class).setOptionType(10).show();
    }

    public Console getConsole() {
        return console;
    }

    private void createDialogManager() {
        if (this.dialogManager != null) {
            return;
        }
        this.dialogAssistant = new DialogAssistant(this);
        String title = NbBundle.getMessage(DialogAssistant.class, (String)"TITL_CompareAssistant");
        this.dialogManager = DialogManager.create((String)title, (JComponent)this.dialogAssistant, (boolean)false).setDialogId("GedcomCompareDialogl").setOptionType(10).setMessageType(1);
    }

    public void updateDialogManager() {
        this.updateDialogManager(false);
    }

    public void updateDialogManager(boolean force) {
        if (!this.isComponentCreated || this.dialogAssistant == null) {
            return;
        }
        boolean existMainLocal = false;
        boolean isMainLocalReady = false;
        boolean existOtherLocal = false;
        boolean isOtherLocalReady = false;
        boolean isConnected = false;
        boolean isProfileComplete = false;
        boolean isSharing = false;
        boolean isMainLocalPrivate = false;
        boolean existConnectedGedcom = false;
        boolean existConnectedOverlap = false;
        boolean existConnectedCompared = false;
        existMainLocal = this.localGedcomFrames != null && this.localGedcomFrames.size() >= 1;
        LocalGedcomFrame tempMain = this.getMain();
        isMainLocalReady = existMainLocal && tempMain != null && tempMain.isReady();
        isMainLocalPrivate = existMainLocal && tempMain != null && tempMain.isOpen() && tempMain.isPrivate();
        existOtherLocal = this.localGedcomFrames != null && this.localGedcomFrames.size() >= 2;
        LocalGedcomFrame tempOther = this.getOther();
        isOtherLocalReady = existOtherLocal && tempOther != null && tempOther.isReady();
        isConnected = EnvironmentChecker.isConnected((boolean)true);
        isProfileComplete = this.isMyProfileOK(true);
        isSharing = this.sharing;
        existConnectedGedcom = this.connectedUserFrames != null && this.connectedUserFrames.size() >= 1 && this.existConnectedGedcomReady();
        existConnectedOverlap = this.connectedUserFrames != null && this.connectedUserFrames.size() >= 1 && this.existConnectedGedcomViewed();
        existConnectedCompared = this.connectedUserFrames != null && this.connectedUserFrames.size() >= 1 && this.existConnectedGedcomComplete();
        this.dialogAssistant.setIndications(existMainLocal, isMainLocalReady, existOtherLocal, isOtherLocalReady, isConnected, isProfileComplete, isSharing, isMainLocalPrivate, existConnectedGedcom, existConnectedOverlap, existConnectedCompared);
        if (!force || this.dialogAssistant.isShowing()) {
            return;
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                GedcomCompareTopComponent.this.dialogManager.show();
            }
        });
    }
}

