/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.openide.util.ImageUtilities;

class TabContentPane
extends JPanel {
    private final Image leftShadow;
    private final Image rightShadow;
    private final Image bottomShadow;
    private final Image bottomLeftCorner;
    private final Image bottomRightCorner;
    private static final Insets insets = new Insets(0, 19, 85, 22);

    public TabContentPane() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 23, 6));
        this.setMinimumSize(new Dimension(41, 85));
        this.leftShadow = ImageUtilities.loadImage((String)"ancestris/welcome/resources/left_shadow.png");
        this.rightShadow = ImageUtilities.loadImage((String)"ancestris/welcome/resources/right_shadow.png");
        this.bottomShadow = ImageUtilities.loadImage((String)"ancestris/welcome/resources/bottom_shadow.png");
        this.bottomLeftCorner = ImageUtilities.loadImage((String)"ancestris/welcome/resources/bottom_left_corner.png");
        this.bottomRightCorner = ImageUtilities.loadImage((String)"ancestris/welcome/resources/bottom_right_corner.png");
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        g2d.drawImage(this.bottomLeftCorner, 0, height - TabContentPane.insets.bottom, this);
        g2d.drawImage(this.bottomRightCorner, width - TabContentPane.insets.right, height - TabContentPane.insets.bottom, this);
        g2d.drawImage(this.bottomShadow, TabContentPane.insets.left, height - TabContentPane.insets.bottom, width - TabContentPane.insets.left - TabContentPane.insets.right, TabContentPane.insets.bottom, this);
        g2d.drawImage(this.leftShadow, 0, 0, TabContentPane.insets.left, height - TabContentPane.insets.bottom, this);
        g2d.drawImage(this.rightShadow, width - TabContentPane.insets.right, 0, TabContentPane.insets.right, height - TabContentPane.insets.bottom, this);
        g2d.setColor(Color.white);
        g2d.fillRect(TabContentPane.insets.left, 0, width - TabContentPane.insets.left - TabContentPane.insets.right, height - TabContentPane.insets.bottom);
    }
}

