/***************************************************************
 * Name:      calendarpopup.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef CALENDARPOPUP_H
#define CALENDARPOPUP_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/minifram.h>
#include "widgets/dxcalendarctrl.h"

class CalendarPopup : public wxMiniFrame
{
    DECLARE_DYNAMIC_CLASS(CalendarPopup)
    DECLARE_EVENT_TABLE()
public:
    CalendarPopup(wxWindow *parent);

    bool shown() const;
    void setShown(bool shown);
    void updateCalendar();
    void markDays(bool showhidden);
    void setPosition(const wxPoint &pos);
    void setValue(const wxDateTime &date);
private:
    wxBoxSizer *m_mainSizer;
    dxCalendarCtrl *m_calendar;
    bool m_shown;
    wxPoint m_calpos;
    bool m_showhidden;

    void OnCalendar(wxCalendarEvent& event);
    void OnKeyUp(wxKeyEvent& event);
    void OnClose(wxCloseEvent& event);
};

#endif // CALENDARPOPUP_H
