/***************************************************************
 * Name:      dxreminders.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2013
 * License:   GPL3
 **************************************************************/

#ifndef DXREMINDERS_H
#define DXREMINDERS_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/snglinst.h>
#include <wx/taskbar.h>
#include <wx/socket.h>
#include <wx/listctrl.h>
#include "data/engine.h"
#include "widgets/dxcalendarctrl.h"
#include "widgets/dxlistctrl.h"
#include "eventmsgdialog.h"
#include "filters/filter.h"
#include "widgets/dxtoolbar.h"

class dxremindersApp : public wxApp
{
public:
    virtual bool OnInit();
    virtual int OnExit();
protected:
    wxSingleInstanceChecker *m_checker;
    wxLocale *m_Locale;
};

class dxTaskBarIcon: public wxTaskBarIcon
{
    DECLARE_EVENT_TABLE()
public:
#if defined(__WXCOCOA__)
    dxTaskBarIcon(wxTaskBarIconType iconType = DEFAULT_TYPE) : wxTaskBarIcon(iconType)
#else
    dxTaskBarIcon()
#endif
    {}
    ~dxTaskBarIcon() {}

    void OnLeftButtonDClick(wxTaskBarIconEvent&);
    virtual wxMenu *CreatePopupMenu();
private:
    void OnRestore(wxCommandEvent& event);
    void OnQuit(wxCommandEvent& event);
    void OnNewEvent(wxCommandEvent& event);
    void OnAbout(wxCommandEvent& event);
    void OnHelp(wxCommandEvent& event);
    void OnPreferences(wxCommandEvent& event);
    void OnLoadDB(wxCommandEvent& event);
    void OnSaveDB(wxCommandEvent& event);
    void OnTestEvents(wxCommandEvent& event);
    void OnHolidays(wxCommandEvent& event);
    void OnShowHideNote(wxCommandEvent& event);
    void OnRemoveEvents(wxCommandEvent& event);
    void OnCheckVersion(wxCommandEvent& event);
};

class dxTaskBarEvents: public wxTaskBarIcon
{
    DECLARE_EVENT_TABLE()
public:
    dxTaskBarEvents()
    {}
    ~dxTaskBarEvents() {}

    void OnLeftButtonDClick(wxTaskBarIconEvent&);
    virtual wxMenu *CreatePopupMenu();
private:
    void OnShowEvents(wxCommandEvent& event);
};

class EventListCtrl: public wxListView
{
public:
    EventListCtrl(wxWindow *parent, const wxWindowID id)
        : wxListView(parent, id, wxDefaultPosition, wxDefaultSize, wxLC_REPORT | wxLC_HRULES | wxLC_VRULES | wxLC_VIRTUAL | wxLC_EDIT_LABELS) {}

    void SetColumnHeaderFiltered(int column, bool filtered);
    void ClearSelection();
private:
    virtual wxString OnGetItemText(long item, long column) const;
    virtual int OnGetItemImage(long item) const;
    virtual wxListItemAttr *OnGetItemAttr(long item) const;
};

class dxremindersFrame: public wxFrame
{
    DECLARE_EVENT_TABLE()
public:
    dxremindersFrame(wxFrame *frame, const wxString& title, bool ipc=false);
    ~dxremindersFrame();

    void hideShowTrayIcon();
    void applyPreference(bool resize);
    void applyFilter(const dxFilterArray &filters);
    void refreshFrame();
    bool noteShown();
    wxString getItemText(long item, long column) const;
    wxListItemAttr *getItemAttr(long item) const;
    void showEvents();
private:
    dxTaskBarIcon *m_taskBarIcon;
    dxTaskBarEvents *m_taskBarEvents;
    EventListCtrl *m_eventsList;
    Engine *m_data;
    long m_selectedIndex;
    wxTimer m_timer;
    dxCalendar *m_calendar;
    wxBoxSizer *m_sizer;
    wxPanel *m_events;
    dxToolBar *m_bar;
    wxTextCtrl *m_note;
    wxSocketServer *m_server;
    bool m_ipc;
    std::vector<EventView> m_eventViews;
    wxListItemAttr *m_evenMonth;
    wxListItemAttr *m_oddMonth;
    wxListItemAttr *m_eventFont;
    wxListItemAttr *m_highlight1;
    wxListItemAttr *m_highlight2;
    wxListItemAttr *m_highlight3;
    wxListItemAttr *m_highlight4;
    wxListItemAttr *m_highlight5;
    wxMenuItem *m_showHiddenEvents;
    wxMenuItem *m_showDonotDelete;
    wxMenuItem *m_clearHiddenList;
    wxMenuItem *m_clearHighlightList;
    wxSocketBase *m_sock;
    EventMsgDialog *m_msgDialog;
    wxString m_ipcString;
    wxMenuItem *m_removeEvents;
    bool m_filter;
    /**
     * @brief m_hidden
     * true = Hidden events shown on EventsList
     */
    bool m_hidden;
    dxFilterArray m_filters;
    wxMenuItem *m_filterMenuItem;
    wxMenuItem *m_clearfilterMenuItem;
    bool m_hideDonotdelete;

    void OnClose(wxCloseEvent& event);
    void OnAbout(wxCommandEvent& event);
    void OnHelp(wxCommandEvent& event);
    void OnQuit(wxCommandEvent& event);
    void OnNewEvent(wxCommandEvent& event);
    void OnEditEvent(wxCommandEvent& event);
    void OnEditDate(wxCommandEvent& event);
    void OnAdvance(wxCommandEvent& event);
    void OnRemoveEvent(wxCommandEvent& event);
    void OnItemRightClick(wxListEvent& event);
    void OnItemActivated(wxListEvent& event);
    void OnItemSelected(wxListEvent& event);
    void OnItemDeselected(wxListEvent& event);
    void OnItemEditEnd(wxListEvent& event);
    void OnTimer(wxTimerEvent& event);
    void OnCalendar(wxCalendarEvent& event);
    void OnCalendarChanged(wxCalendarEvent& event);
    void OnPreferences(wxCommandEvent& event);
    void OnKeyUp(wxKeyEvent& event);
    void OnLoadDB(wxCommandEvent& event);
    void OnSaveDB(wxCommandEvent& event);
    void OnTestEvents(wxCommandEvent& event);
    void OnServerEvent(wxSocketEvent& event);
    void OnSocketEvent(wxSocketEvent& event);
    void OnHolidays(wxCommandEvent& event);
    void OnShowHideNote(wxCommandEvent& event);
    void OnHideEvent(wxCommandEvent& event);
    void OnHideEventsOnList(wxCommandEvent& event);
    void OnShowEventsMenu(wxCommandEvent& event);
    void OnShowEventsBtn(wxCommandEvent& event);
    void OnShowEventsRightclick(wxCommandEvent& event);
    void OnEngineUpdated(wxCommandEvent& event);
    void OnEngineMsg(wxCommandEvent& event);
    void OnClearHiddenList(wxCommandEvent& event);
    void OnRemoveFromHiddenList(wxCommandEvent& event);
    void OnFullscreen(wxCommandEvent& event);
    void OnAlwaysShow(wxCommandEvent& event);
    void OnHighlightEvent(wxCommandEvent& event);
    void OnUnHighlightEvent(wxCommandEvent& event);
    void OnClearHighlightList(wxCommandEvent& event);
    void OnFilter(wxCommandEvent& event);
    void OnClearFilter(wxCommandEvent& event);
    void OnShowDonotdelete(wxCommandEvent& event);
    void OnCalendarFocus(wxCommandEvent& event);
    void OnEventlistFocus(wxCommandEvent& event);
    /**
     * @brief fireEvents - fire events which have to be reminded
     * @return true if some fired
     */
    bool fireEvents();
    void markDays();
    void loadDatabase();
    void reLayout(bool resize=true);
    void recreateColumns();
    void enableTools();
    /**
     * @brief selectDate for event selected at events list
     */
    void selectDate();
    void saveColumnSize();
    void fireHoliday();
    void updateEventsList();
    void sendTooltip();
    void sendSilentmode();
    void parseReceived(const wxString &text);
    void OnRemoveEvents(wxCommandEvent& event);
    wxBitmap drawColorBitmap(int color);
    void eventslistMarkFiltered();
    void OnCheckVersion(wxCommandEvent& event);
};


#endif // DXREMINDERS_H
