; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefixes=X86,X86-FAST
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+slow-shld | FileCheck %s --check-prefixes=X86,X86-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefixes=X64,X64-FAST
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+slow-shld | FileCheck %s --check-prefixes=X64,X64-SLOW

declare i8 @llvm.fshl.i8(i8, i8, i8) nounwind readnone
declare i16 @llvm.fshl.i16(i16, i16, i16) nounwind readnone
declare i32 @llvm.fshl.i32(i32, i32, i32) nounwind readnone
declare i64 @llvm.fshl.i64(i64, i64, i64) nounwind readnone
declare i128 @llvm.fshl.i128(i128, i128, i128) nounwind readnone

;
; Variable Funnel Shift
;

define i8 @var_shift_i8(i8 %x, i8 %y, i8 %z) nounwind {
; X86-LABEL: var_shift_i8:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    orl %edx, %eax
; X86-NEXT:    andb $7, %cl
; X86-NEXT:    shll %cl, %eax
; X86-NEXT:    movb %ah, %al
; X86-NEXT:    retl
;
; X64-LABEL: var_shift_i8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edx, %ecx
; X64-NEXT:    shll $8, %edi
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    orl %edi, %eax
; X64-NEXT:    andb $7, %cl
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shll %cl, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %tmp = tail call i8 @llvm.fshl.i8(i8 %x, i8 %y, i8 %z)
  ret i8 %tmp
}

define i16 @var_shift_i16(i16 %x, i16 %y, i16 %z) nounwind {
; X86-FAST-LABEL: var_shift_i16:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; X86-FAST-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-FAST-NEXT:    andb $15, %cl
; X86-FAST-NEXT:    shldw %cl, %dx, %ax
; X86-FAST-NEXT:    retl
;
; X86-SLOW-LABEL: var_shift_i16:
; X86-SLOW:       # %bb.0:
; X86-SLOW-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-SLOW-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    shll $16, %eax
; X86-SLOW-NEXT:    orl %edx, %eax
; X86-SLOW-NEXT:    andb $15, %cl
; X86-SLOW-NEXT:    shll %cl, %eax
; X86-SLOW-NEXT:    shrl $16, %eax
; X86-SLOW-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-SLOW-NEXT:    retl
;
; X64-FAST-LABEL: var_shift_i16:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    movl %edx, %ecx
; X64-FAST-NEXT:    movl %edi, %eax
; X64-FAST-NEXT:    andb $15, %cl
; X64-FAST-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-FAST-NEXT:    shldw %cl, %si, %ax
; X64-FAST-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-FAST-NEXT:    retq
;
; X64-SLOW-LABEL: var_shift_i16:
; X64-SLOW:       # %bb.0:
; X64-SLOW-NEXT:    movl %edx, %ecx
; X64-SLOW-NEXT:    shll $16, %edi
; X64-SLOW-NEXT:    movzwl %si, %eax
; X64-SLOW-NEXT:    orl %edi, %eax
; X64-SLOW-NEXT:    andb $15, %cl
; X64-SLOW-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-SLOW-NEXT:    shll %cl, %eax
; X64-SLOW-NEXT:    shrl $16, %eax
; X64-SLOW-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-SLOW-NEXT:    retq
  %tmp = tail call i16 @llvm.fshl.i16(i16 %x, i16 %y, i16 %z)
  ret i16 %tmp
}

define i32 @var_shift_i32(i32 %x, i32 %y, i32 %z) nounwind {
; X86-FAST-LABEL: var_shift_i32:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    shldl %cl, %edx, %eax
; X86-FAST-NEXT:    retl
;
; X86-SLOW-LABEL: var_shift_i32:
; X86-SLOW:       # %bb.0:
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SLOW-NEXT:    shll %cl, %edx
; X86-SLOW-NEXT:    notb %cl
; X86-SLOW-NEXT:    shrl %eax
; X86-SLOW-NEXT:    shrl %cl, %eax
; X86-SLOW-NEXT:    orl %edx, %eax
; X86-SLOW-NEXT:    retl
;
; X64-FAST-LABEL: var_shift_i32:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    movl %edx, %ecx
; X64-FAST-NEXT:    movl %edi, %eax
; X64-FAST-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-FAST-NEXT:    shldl %cl, %esi, %eax
; X64-FAST-NEXT:    retq
;
; X64-SLOW-LABEL: var_shift_i32:
; X64-SLOW:       # %bb.0:
; X64-SLOW-NEXT:    movl %edx, %ecx
; X64-SLOW-NEXT:    movl %esi, %eax
; X64-SLOW-NEXT:    shll %cl, %edi
; X64-SLOW-NEXT:    shrl %eax
; X64-SLOW-NEXT:    notb %cl
; X64-SLOW-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-SLOW-NEXT:    shrl %cl, %eax
; X64-SLOW-NEXT:    orl %edi, %eax
; X64-SLOW-NEXT:    retq
  %tmp = tail call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %z)
  ret i32 %tmp
}

define i32 @var_shift_i32_optsize(i32 %x, i32 %y, i32 %z) nounwind optsize {
; X86-LABEL: var_shift_i32_optsize:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shldl %cl, %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: var_shift_i32_optsize:
; X64:       # %bb.0:
; X64-NEXT:    movl %edx, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shldl %cl, %esi, %eax
; X64-NEXT:    retq
  %tmp = tail call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %z)
  ret i32 %tmp
}

define i32 @var_shift_i32_pgso(i32 %x, i32 %y, i32 %z) nounwind !prof !14 {
; X86-LABEL: var_shift_i32_pgso:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shldl %cl, %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: var_shift_i32_pgso:
; X64:       # %bb.0:
; X64-NEXT:    movl %edx, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shldl %cl, %esi, %eax
; X64-NEXT:    retq
  %tmp = tail call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %z)
  ret i32 %tmp
}

define i64 @var_shift_i64(i64 %x, i64 %y, i64 %z) nounwind {
; X86-FAST-LABEL: var_shift_i64:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    pushl %edi
; X86-FAST-NEXT:    pushl %esi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-FAST-NEXT:    testb $32, %cl
; X86-FAST-NEXT:    jne .LBB5_1
; X86-FAST-NEXT:  # %bb.2:
; X86-FAST-NEXT:    movl %edx, %edi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-FAST-NEXT:    jmp .LBB5_3
; X86-FAST-NEXT:  .LBB5_1:
; X86-FAST-NEXT:    movl %esi, %edi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-FAST-NEXT:  .LBB5_3:
; X86-FAST-NEXT:    movl %edi, %eax
; X86-FAST-NEXT:    shldl %cl, %esi, %eax
; X86-FAST-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-FAST-NEXT:    shldl %cl, %edi, %edx
; X86-FAST-NEXT:    popl %esi
; X86-FAST-NEXT:    popl %edi
; X86-FAST-NEXT:    retl
;
; X86-SLOW-LABEL: var_shift_i64:
; X86-SLOW:       # %bb.0:
; X86-SLOW-NEXT:    pushl %ebx
; X86-SLOW-NEXT:    pushl %edi
; X86-SLOW-NEXT:    pushl %esi
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-SLOW-NEXT:    testb $32, %bl
; X86-SLOW-NEXT:    jne .LBB5_1
; X86-SLOW-NEXT:  # %bb.2:
; X86-SLOW-NEXT:    movl %edx, %esi
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SLOW-NEXT:    jmp .LBB5_3
; X86-SLOW-NEXT:  .LBB5_1:
; X86-SLOW-NEXT:    movl %eax, %esi
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:  .LBB5_3:
; X86-SLOW-NEXT:    movl %esi, %edi
; X86-SLOW-NEXT:    movl %ebx, %ecx
; X86-SLOW-NEXT:    shll %cl, %edi
; X86-SLOW-NEXT:    shrl %eax
; X86-SLOW-NEXT:    notb %cl
; X86-SLOW-NEXT:    shrl %cl, %eax
; X86-SLOW-NEXT:    orl %edi, %eax
; X86-SLOW-NEXT:    shrl %esi
; X86-SLOW-NEXT:    shrl %cl, %esi
; X86-SLOW-NEXT:    movl %ebx, %ecx
; X86-SLOW-NEXT:    shll %cl, %edx
; X86-SLOW-NEXT:    orl %esi, %edx
; X86-SLOW-NEXT:    popl %esi
; X86-SLOW-NEXT:    popl %edi
; X86-SLOW-NEXT:    popl %ebx
; X86-SLOW-NEXT:    retl
;
; X64-FAST-LABEL: var_shift_i64:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    movq %rdx, %rcx
; X64-FAST-NEXT:    movq %rdi, %rax
; X64-FAST-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-FAST-NEXT:    shldq %cl, %rsi, %rax
; X64-FAST-NEXT:    retq
;
; X64-SLOW-LABEL: var_shift_i64:
; X64-SLOW:       # %bb.0:
; X64-SLOW-NEXT:    movq %rdx, %rcx
; X64-SLOW-NEXT:    movq %rsi, %rax
; X64-SLOW-NEXT:    shlq %cl, %rdi
; X64-SLOW-NEXT:    shrq %rax
; X64-SLOW-NEXT:    notb %cl
; X64-SLOW-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-SLOW-NEXT:    shrq %cl, %rax
; X64-SLOW-NEXT:    orq %rdi, %rax
; X64-SLOW-NEXT:    retq
  %tmp = tail call i64 @llvm.fshl.i64(i64 %x, i64 %y, i64 %z)
  ret i64 %tmp
}

define i128 @var_shift_i128(i128 %x, i128 %y, i128 %z) nounwind {
; X86-FAST-LABEL: var_shift_i128:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    pushl %ebp
; X86-FAST-NEXT:    pushl %ebx
; X86-FAST-NEXT:    pushl %edi
; X86-FAST-NEXT:    pushl %esi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-FAST-NEXT:    testb $64, %cl
; X86-FAST-NEXT:    jne .LBB6_1
; X86-FAST-NEXT:  # %bb.2:
; X86-FAST-NEXT:    movl %edi, %eax
; X86-FAST-NEXT:    movl %esi, %edi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-FAST-NEXT:    movl %ebx, %ebp
; X86-FAST-NEXT:    movl %edx, %ebx
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-FAST-NEXT:    testb $32, %cl
; X86-FAST-NEXT:    je .LBB6_5
; X86-FAST-NEXT:  .LBB6_4:
; X86-FAST-NEXT:    movl %edx, %esi
; X86-FAST-NEXT:    movl %edi, %edx
; X86-FAST-NEXT:    movl %ebx, %edi
; X86-FAST-NEXT:    movl %eax, %ebx
; X86-FAST-NEXT:    jmp .LBB6_6
; X86-FAST-NEXT:  .LBB6_1:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    testb $32, %cl
; X86-FAST-NEXT:    jne .LBB6_4
; X86-FAST-NEXT:  .LBB6_5:
; X86-FAST-NEXT:    movl %eax, %ebp
; X86-FAST-NEXT:  .LBB6_6:
; X86-FAST-NEXT:    movl %ebx, %eax
; X86-FAST-NEXT:    shldl %cl, %ebp, %eax
; X86-FAST-NEXT:    movl %edi, %ebp
; X86-FAST-NEXT:    shldl %cl, %ebx, %ebp
; X86-FAST-NEXT:    movl %edx, %ebx
; X86-FAST-NEXT:    shldl %cl, %edi, %ebx
; X86-FAST-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-FAST-NEXT:    shldl %cl, %edx, %esi
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-FAST-NEXT:    movl %esi, 12(%ecx)
; X86-FAST-NEXT:    movl %ebx, 8(%ecx)
; X86-FAST-NEXT:    movl %ebp, 4(%ecx)
; X86-FAST-NEXT:    movl %eax, (%ecx)
; X86-FAST-NEXT:    movl %ecx, %eax
; X86-FAST-NEXT:    popl %esi
; X86-FAST-NEXT:    popl %edi
; X86-FAST-NEXT:    popl %ebx
; X86-FAST-NEXT:    popl %ebp
; X86-FAST-NEXT:    retl $4
;
; X86-SLOW-LABEL: var_shift_i128:
; X86-SLOW:       # %bb.0:
; X86-SLOW-NEXT:    pushl %ebp
; X86-SLOW-NEXT:    pushl %ebx
; X86-SLOW-NEXT:    pushl %edi
; X86-SLOW-NEXT:    pushl %esi
; X86-SLOW-NEXT:    pushl %eax
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    testb $64, %al
; X86-SLOW-NEXT:    jne .LBB6_1
; X86-SLOW-NEXT:  # %bb.2:
; X86-SLOW-NEXT:    movl %ebp, %ecx
; X86-SLOW-NEXT:    movl %edi, %ebp
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-SLOW-NEXT:    movl %edx, %ebx
; X86-SLOW-NEXT:    movl %esi, %edx
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-SLOW-NEXT:    jmp .LBB6_3
; X86-SLOW-NEXT:  .LBB6_1:
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SLOW-NEXT:  .LBB6_3:
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    testb $32, %al
; X86-SLOW-NEXT:    jne .LBB6_4
; X86-SLOW-NEXT:  # %bb.5:
; X86-SLOW-NEXT:    movl %ecx, %ebx
; X86-SLOW-NEXT:    movl %edi, (%esp) # 4-byte Spill
; X86-SLOW-NEXT:    jmp .LBB6_6
; X86-SLOW-NEXT:  .LBB6_4:
; X86-SLOW-NEXT:    movl %esi, (%esp) # 4-byte Spill
; X86-SLOW-NEXT:    movl %ebp, %esi
; X86-SLOW-NEXT:    movl %edx, %ebp
; X86-SLOW-NEXT:    movl %ecx, %edx
; X86-SLOW-NEXT:  .LBB6_6:
; X86-SLOW-NEXT:    movl %edx, %edi
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    movl %eax, %ecx
; X86-SLOW-NEXT:    shll %cl, %edi
; X86-SLOW-NEXT:    shrl %ebx
; X86-SLOW-NEXT:    movb %al, %ch
; X86-SLOW-NEXT:    notb %ch
; X86-SLOW-NEXT:    movb %ch, %cl
; X86-SLOW-NEXT:    shrl %cl, %ebx
; X86-SLOW-NEXT:    orl %edi, %ebx
; X86-SLOW-NEXT:    movl %ebp, %edi
; X86-SLOW-NEXT:    movb %al, %cl
; X86-SLOW-NEXT:    shll %cl, %edi
; X86-SLOW-NEXT:    shrl %edx
; X86-SLOW-NEXT:    movb %ch, %cl
; X86-SLOW-NEXT:    shrl %cl, %edx
; X86-SLOW-NEXT:    orl %edi, %edx
; X86-SLOW-NEXT:    movl %esi, %edi
; X86-SLOW-NEXT:    movb %al, %cl
; X86-SLOW-NEXT:    shll %cl, %edi
; X86-SLOW-NEXT:    shrl %ebp
; X86-SLOW-NEXT:    movb %ch, %cl
; X86-SLOW-NEXT:    shrl %cl, %ebp
; X86-SLOW-NEXT:    orl %edi, %ebp
; X86-SLOW-NEXT:    movb %al, %cl
; X86-SLOW-NEXT:    movl (%esp), %eax # 4-byte Reload
; X86-SLOW-NEXT:    shll %cl, %eax
; X86-SLOW-NEXT:    shrl %esi
; X86-SLOW-NEXT:    movb %ch, %cl
; X86-SLOW-NEXT:    shrl %cl, %esi
; X86-SLOW-NEXT:    orl %eax, %esi
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    movl %esi, 12(%eax)
; X86-SLOW-NEXT:    movl %ebp, 8(%eax)
; X86-SLOW-NEXT:    movl %edx, 4(%eax)
; X86-SLOW-NEXT:    movl %ebx, (%eax)
; X86-SLOW-NEXT:    addl $4, %esp
; X86-SLOW-NEXT:    popl %esi
; X86-SLOW-NEXT:    popl %edi
; X86-SLOW-NEXT:    popl %ebx
; X86-SLOW-NEXT:    popl %ebp
; X86-SLOW-NEXT:    retl $4
;
; X64-FAST-LABEL: var_shift_i128:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    testb $64, %r8b
; X64-FAST-NEXT:    cmovneq %rdi, %rsi
; X64-FAST-NEXT:    cmoveq %rcx, %rdx
; X64-FAST-NEXT:    cmovneq %rcx, %rdi
; X64-FAST-NEXT:    movq %rdi, %rax
; X64-FAST-NEXT:    movl %r8d, %ecx
; X64-FAST-NEXT:    shldq %cl, %rdx, %rax
; X64-FAST-NEXT:    shldq %cl, %rdi, %rsi
; X64-FAST-NEXT:    movq %rsi, %rdx
; X64-FAST-NEXT:    retq
;
; X64-SLOW-LABEL: var_shift_i128:
; X64-SLOW:       # %bb.0:
; X64-SLOW-NEXT:    testb $64, %r8b
; X64-SLOW-NEXT:    cmovneq %rdi, %rsi
; X64-SLOW-NEXT:    cmoveq %rcx, %rdx
; X64-SLOW-NEXT:    cmovneq %rcx, %rdi
; X64-SLOW-NEXT:    movq %rdi, %rax
; X64-SLOW-NEXT:    movl %r8d, %ecx
; X64-SLOW-NEXT:    shlq %cl, %rax
; X64-SLOW-NEXT:    shrq %rdx
; X64-SLOW-NEXT:    movl %r8d, %r9d
; X64-SLOW-NEXT:    notb %r9b
; X64-SLOW-NEXT:    movl %r9d, %ecx
; X64-SLOW-NEXT:    shrq %cl, %rdx
; X64-SLOW-NEXT:    orq %rdx, %rax
; X64-SLOW-NEXT:    movl %r8d, %ecx
; X64-SLOW-NEXT:    shlq %cl, %rsi
; X64-SLOW-NEXT:    shrq %rdi
; X64-SLOW-NEXT:    movl %r9d, %ecx
; X64-SLOW-NEXT:    shrq %cl, %rdi
; X64-SLOW-NEXT:    orq %rsi, %rdi
; X64-SLOW-NEXT:    movq %rdi, %rdx
; X64-SLOW-NEXT:    retq
  %tmp = tail call i128 @llvm.fshl.i128(i128 %x, i128 %y, i128 %z)
  ret i128 %tmp
}

;
; Const Funnel Shift
;

define i8 @const_shift_i8(i8 %x, i8 %y) nounwind {
; X86-LABEL: const_shift_i8:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    shrb %cl
; X86-NEXT:    shlb $7, %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: const_shift_i8:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    shrb %sil
; X64-NEXT:    shlb $7, %dil
; X64-NEXT:    leal (%rdi,%rsi), %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %tmp = tail call i8 @llvm.fshl.i8(i8 %x, i8 %y, i8 7)
  ret i8 %tmp
}

define i16 @const_shift_i16(i16 %x, i16 %y) nounwind {
; X86-FAST-LABEL: const_shift_i16:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-FAST-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    shldw $7, %cx, %ax
; X86-FAST-NEXT:    retl
;
; X86-SLOW-LABEL: const_shift_i16:
; X86-SLOW:       # %bb.0:
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-SLOW-NEXT:    shrl $9, %ecx
; X86-SLOW-NEXT:    shll $7, %eax
; X86-SLOW-NEXT:    orl %ecx, %eax
; X86-SLOW-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-SLOW-NEXT:    retl
;
; X64-FAST-LABEL: const_shift_i16:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    movl %edi, %eax
; X64-FAST-NEXT:    shldw $7, %si, %ax
; X64-FAST-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-FAST-NEXT:    retq
;
; X64-SLOW-LABEL: const_shift_i16:
; X64-SLOW:       # %bb.0:
; X64-SLOW-NEXT:    movzwl %si, %eax
; X64-SLOW-NEXT:    shll $7, %edi
; X64-SLOW-NEXT:    shrl $9, %eax
; X64-SLOW-NEXT:    orl %edi, %eax
; X64-SLOW-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-SLOW-NEXT:    retq
  %tmp = tail call i16 @llvm.fshl.i16(i16 %x, i16 %y, i16 7)
  ret i16 %tmp
}

define i32 @const_shift_i32(i32 %x, i32 %y) nounwind {
; X86-FAST-LABEL: const_shift_i32:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    shldl $7, %ecx, %eax
; X86-FAST-NEXT:    retl
;
; X86-SLOW-LABEL: const_shift_i32:
; X86-SLOW:       # %bb.0:
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SLOW-NEXT:    shrl $25, %ecx
; X86-SLOW-NEXT:    shll $7, %eax
; X86-SLOW-NEXT:    orl %ecx, %eax
; X86-SLOW-NEXT:    retl
;
; X64-FAST-LABEL: const_shift_i32:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    movl %edi, %eax
; X64-FAST-NEXT:    shldl $7, %esi, %eax
; X64-FAST-NEXT:    retq
;
; X64-SLOW-LABEL: const_shift_i32:
; X64-SLOW:       # %bb.0:
; X64-SLOW-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-SLOW-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-SLOW-NEXT:    shrl $25, %esi
; X64-SLOW-NEXT:    shll $7, %edi
; X64-SLOW-NEXT:    leal (%rdi,%rsi), %eax
; X64-SLOW-NEXT:    retq
  %tmp = tail call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 7)
  ret i32 %tmp
}

define i64 @const_shift_i64(i64 %x, i64 %y) nounwind {
; X86-FAST-LABEL: const_shift_i64:
; X86-FAST:       # %bb.0:
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-FAST-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-FAST-NEXT:    shrdl $25, %ecx, %eax
; X86-FAST-NEXT:    shldl $7, %ecx, %edx
; X86-FAST-NEXT:    retl
;
; X86-SLOW-LABEL: const_shift_i64:
; X86-SLOW:       # %bb.0:
; X86-SLOW-NEXT:    pushl %esi
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-SLOW-NEXT:    shrl $25, %esi
; X86-SLOW-NEXT:    movl %ecx, %eax
; X86-SLOW-NEXT:    shll $7, %eax
; X86-SLOW-NEXT:    orl %esi, %eax
; X86-SLOW-NEXT:    shrl $25, %ecx
; X86-SLOW-NEXT:    shll $7, %edx
; X86-SLOW-NEXT:    orl %ecx, %edx
; X86-SLOW-NEXT:    popl %esi
; X86-SLOW-NEXT:    retl
;
; X64-FAST-LABEL: const_shift_i64:
; X64-FAST:       # %bb.0:
; X64-FAST-NEXT:    movq %rdi, %rax
; X64-FAST-NEXT:    shldq $7, %rsi, %rax
; X64-FAST-NEXT:    retq
;
; X64-SLOW-LABEL: const_shift_i64:
; X64-SLOW:       # %bb.0:
; X64-SLOW-NEXT:    shrq $57, %rsi
; X64-SLOW-NEXT:    shlq $7, %rdi
; X64-SLOW-NEXT:    leaq (%rdi,%rsi), %rax
; X64-SLOW-NEXT:    retq
  %tmp = tail call i64 @llvm.fshl.i64(i64 %x, i64 %y, i64 7)
  ret i64 %tmp
}

;
; Combine Consecutive Loads
;

define i8 @combine_fshl_load_i8(i8* %p) nounwind {
; X86-LABEL: combine_fshl_load_i8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb 1(%eax), %al
; X86-NEXT:    retl
;
; X64-LABEL: combine_fshl_load_i8:
; X64:       # %bb.0:
; X64-NEXT:    movb 1(%rdi), %al
; X64-NEXT:    retq
  %p1 = getelementptr i8, i8* %p, i32 1
  %ld0 = load i8, i8 *%p
  %ld1 = load i8, i8 *%p1
  %res = call i8 @llvm.fshl.i8(i8 %ld1, i8 %ld0, i8 8)
  ret i8 %res
}

define i16 @combine_fshl_load_i16(i16* %p) nounwind {
; X86-LABEL: combine_fshl_load_i16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl 1(%eax), %eax
; X86-NEXT:    retl
;
; X64-LABEL: combine_fshl_load_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl 1(%rdi), %eax
; X64-NEXT:    retq
  %p0 = getelementptr i16, i16* %p, i32 0
  %p1 = getelementptr i16, i16* %p, i32 1
  %ld0 = load i16, i16 *%p0
  %ld1 = load i16, i16 *%p1
  %res = call i16 @llvm.fshl.i16(i16 %ld1, i16 %ld0, i16 8)
  ret i16 %res
}

define i32 @combine_fshl_load_i32(i32* %p) nounwind {
; X86-LABEL: combine_fshl_load_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl 11(%eax), %eax
; X86-NEXT:    retl
;
; X64-LABEL: combine_fshl_load_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl 11(%rdi), %eax
; X64-NEXT:    retq
  %p0 = getelementptr i32, i32* %p, i32 2
  %p1 = getelementptr i32, i32* %p, i32 3
  %ld0 = load i32, i32 *%p0
  %ld1 = load i32, i32 *%p1
  %res = call i32 @llvm.fshl.i32(i32 %ld1, i32 %ld0, i32 8)
  ret i32 %res
}

define i64 @combine_fshl_load_i64(i64* %p) nounwind {
; X86-LABEL: combine_fshl_load_i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl 13(%ecx), %eax
; X86-NEXT:    movl 17(%ecx), %edx
; X86-NEXT:    retl
;
; X64-LABEL: combine_fshl_load_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq 13(%rdi), %rax
; X64-NEXT:    retq
  %p0 = getelementptr i64, i64* %p, i64 1
  %p1 = getelementptr i64, i64* %p, i64 2
  %ld0 = load i64, i64 *%p0
  %ld1 = load i64, i64 *%p1
  %res = call i64 @llvm.fshl.i64(i64 %ld1, i64 %ld0, i64 24)
  ret i64 %res
}

!llvm.module.flags = !{!0}
!0 = !{i32 1, !"ProfileSummary", !1}
!1 = !{!2, !3, !4, !5, !6, !7, !8, !9}
!2 = !{!"ProfileFormat", !"InstrProf"}
!3 = !{!"TotalCount", i64 10000}
!4 = !{!"MaxCount", i64 10}
!5 = !{!"MaxInternalCount", i64 1}
!6 = !{!"MaxFunctionCount", i64 1000}
!7 = !{!"NumCounts", i64 3}
!8 = !{!"NumFunctions", i64 3}
!9 = !{!"DetailedSummary", !10}
!10 = !{!11, !12, !13}
!11 = !{i32 10000, i64 100, i32 1}
!12 = !{i32 999000, i64 100, i32 1}
!13 = !{i32 999999, i64 1, i32 2}
!14 = !{!"function_entry_count", i64 0}
