#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/grinternal.h>

void
gr_log_signal(const int sig, const struct task_struct *t)
{
#ifdef CONFIG_GRKERNSEC_SIGNAL
	if (grsec_enable_signal && ((sig == SIGSEGV) || (sig == SIGILL) ||
				    (sig == SIGABRT) || (sig == SIGBUS))) {
		if (t->pid == current->pid) {
			security_alert_good(GR_UNISIGLOG_MSG, sig,
					    DEFAULTSECARGS);
		} else {
			security_alert_good(GR_DUALSIGLOG_MSG,
					    sig, t->comm, t->pid, t->uid,
					    t->euid, t->p_pptr->comm,
					    t->p_pptr->pid, t->p_pptr->uid,
					    t->p_pptr->euid, DEFAULTSECARGS);
		}
	}
#endif
	return;
}

int
gr_handle_signal(const struct task_struct *p, const int sig)
{
#ifdef CONFIG_GRKERNSEC
	if (current->pid > 1 && gr_check_protected_task(p)) {
		security_alert(GR_SIG_ACL_MSG, sig, p->comm, p->pid, p->uid,
			       p->euid, p->p_pptr->comm, p->p_pptr->pid,
			       p->p_pptr->uid, p->p_pptr->euid, DEFAULTSECARGS);
		return -EPERM;
	} else if (gr_pid_is_chrooted(p)) {
		return -EPERM;
	}
#endif
	return 0;
}
