/******************************* */
/* Rule Set Based Access Control */
/* Author and (c) 1999-2001:     */
/*   Amon Ott <ao@rsbac.org>     */
/* API: Data structures          */
/* and functions for Access      */
/* Control Information / RC      */
/* Last modified: 22/Nov/2001    */
/******************************* */

#ifndef __RSBAC_RC_H
#define __RSBAC_RC_H

#include <linux/init.h>
#include <rsbac/rc_types.h>

/***************************************************/
/*               General Prototypes                */
/***************************************************/

/* All functions return 0, if no error occurred, and a negative error code  */
/* otherwise. The error codes are defined in rsbac_error.h.                 */

/****************************************************************************/
/* Initialization, including ACI restoration for all mounted devices from   */
/* disk. After this call, all ACI is kept in memory for performance reasons.*/

#ifdef CONFIG_RSBAC_INIT_DELAY
extern int rsbac_init_rc(void);
#else
extern int rsbac_init_rc(void) __init;
#endif

/* Some information about the current status is also available              */

extern int rsbac_stats_rc(void);

/************************************************* */
/*               Access functions                  */
/************************************************* */

/* All these procedures handle the spinlocks to protect the targets during  */
/* access.                                                                  */

/* All roles are always there, so instead of creation, we supply a copy for */
/* initialization. There is always the well-defined role general to copy    */
extern int rsbac_rc_copy_role (rsbac_rc_role_id_t from_role,
                               rsbac_rc_role_id_t to_role);

/* Getting item values */
extern int rsbac_rc_get_item (enum  rsbac_rc_target_t       target,
                              union rsbac_rc_target_id_t    tid,
                              union rsbac_rc_target_id_t    subtid,
                              enum  rsbac_rc_item_t         item,
                              union rsbac_rc_item_value_t * value_p,
                                    rsbac_time_t          * ttl_p);

/* Setting item values */
extern int rsbac_rc_set_item (enum  rsbac_rc_target_t       target,
                              union rsbac_rc_target_id_t    tid,
                              union rsbac_rc_target_id_t    subtid,
                              enum  rsbac_rc_item_t         item,
                              union rsbac_rc_item_value_t   value,
                                    rsbac_time_t            ttl);

/* Checking role's compatibility */
extern boolean rsbac_rc_check_comp(rsbac_rc_role_id_t              role,
                                   union rsbac_rc_target_id_t      subtid,
                                   enum  rsbac_rc_item_t           item,
                                   enum  rsbac_rc_special_rights_t right);

/* Get list of defined items. Returns number or negative error.
 * Allocates array via vmalloc, if number > 0 - vfree after use! */
int rsbac_rc_get_list(enum  rsbac_rc_target_t       target,
                      union rsbac_rc_target_id_t    tid,
                      enum  rsbac_rc_item_t         item,
                            __u32  ** array_pp,
                            rsbac_time_t ** ttl_array_pp);

#endif
