/*
 * Interface handling module
 *
 * Interfaces are uniquely indentified by their corresponding interface
 * index (ifindex). This index may change after reloading a device driver
 * or it may be assigned to another device after renaming a device's name etc.
 *
 * Moreover the user is allowed to use non-existing device names as matches 
 * so we have to maintain a unique assignment from device names to interface
 * indexes.
 *
 * Authors: Michael Bellion and Thomas Heinz
 * (c) 2002-2003 by the hipac core team <nf@hipac.org>:
 *      +-----------------------+----------------------+
 *      |   Michael Bellion     |     Thomas Heinz     |
 *      | <mbellion@hipac.org>  |  <creatix@hipac.org> |
 *      +-----------------------+----------------------+
 * Licenced under the GNU General Public Licence, version >= 2.
 */


#ifndef _NFHP_DEV_H
#define _NFHP_DEV_H

/* call init during module initialization; if something fails a negative 
   errno is returned, otherwise 0 is returned */
int
hpdev_init(void);

/* call exit during module finalization */
void
hpdev_exit(void);

/* copies the device name corresponding to ifindex to ifname which should
   be at least IFNAMSIZ bytes large and return 0;
   if ifindex cannot be found a value < 0 is returned */
int
hpdev_get_name(int ifindex, char ifname[]);

/* return the corresponding interface index if the interface exists either
   as known non-existing device or as existing device;
   otherwise the interface is added to the list of known non-existing
   interfaces and a new interface index is returned;
   if something fails a nfhipac_error is returned */
int
hpdev_get_index(const char *ifname);

#endif
