/*
 * (llc_s_ev.c)- Defines SAP component events
 * 
 * The followed event functions are SAP component events which are described
 * in 802.2 LLC protocol standard document.
 *
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 

#define LLC_S_EV_C

#include <net/cm_types.h>
#include <net/cm_mm.h>
#include <net/cm_dll.h>
#include <net/cm_frame.h>
#include <net/llc_if.h>
#include <net/llc_sap.h>
#include <net/llc_conn.h>
#include <net/llc_main.h>
#include <net/llc_s_ev.h>
#include <net/llc_s_ac.h>
#include <net/llc_glob.h>
#include <net/llc_pdu.h>
#include <net/llc_dbg.h>

#ifdef LLC_S_EV_DBG
  #define  DBG_MSG(body) { printk body; }
#else
  #define  DBG_MSG(body)  ;
#endif


us16 
sap_ev_activation_request (void *sap, sap_state_event_t *event)
{
	return ((event->type == SAP_EV_TYPE_SIMPLE) &&
		(event->data.a.event == SAP_EV_ACTIVATION_REQUEST) ? 0 : 1);
}


us16 
sap_ev_rx_ui (void *sap, sap_state_event_t *event)
{
	pdu_un_t *pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == SAP_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_CMD(pdu)) &&    
		(!LLC_PDU_TYPE_IS_U(pdu)) &&  
		(LLC_U_PDU_CMD(pdu) == LLC_1_PDU_CMD_UI)) ? 0 : 1);

}


us16 
sap_ev_unitdata_request (void *sap, sap_state_event_t *event)
{

	return ((event->type == SAP_EV_TYPE_PRIM) &&
		(event->data.prim.prim == DATAUNIT_PRIM) &&
		(event->data.prim.type == PRIM_TYPE_REQUEST) ? 0 :1);

}

us16 
sap_ev_xid_request (void *sap, sap_state_event_t *event)
{

	return ((event->type == SAP_EV_TYPE_PRIM) &&
		(event->data.prim.prim == XID_PRIM) &&
		(event->data.prim.type == PRIM_TYPE_REQUEST) ? 0 : 1);
}


us16 
sap_ev_rx_xid_c (void *sap, sap_state_event_t *event)
{
	pdu_un_t *pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == SAP_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_CMD(pdu)) &&      
		(!LLC_PDU_TYPE_IS_U(pdu)) &&  
		(LLC_U_PDU_CMD(pdu) == LLC_1_PDU_CMD_XID)) ? 0 : 1);
		
}


us16 
sap_ev_rx_xid_r (void *sap, sap_state_event_t *event)
{
	pdu_un_t *pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == SAP_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_RSP(pdu)) &&  
		(!LLC_PDU_TYPE_IS_U(pdu)) &&      
		(LLC_U_PDU_RSP(pdu) == LLC_1_PDU_CMD_XID)) ? 0 : 1);

}


us16 
sap_ev_test_request (void *sap, sap_state_event_t *event)
{
	return ((event->type == SAP_EV_TYPE_PRIM) &&
		(event->data.prim.prim == TEST_PRIM) &&
		(event->data.prim.type == PRIM_TYPE_REQUEST) ? 0 : 1);
}


us16 
sap_ev_rx_test_c (void *sap, sap_state_event_t *event)
{
	pdu_un_t *pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == SAP_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_CMD(pdu)) &&   
		(!LLC_PDU_TYPE_IS_U(pdu)) &&    
		(LLC_U_PDU_CMD(pdu) == LLC_1_PDU_CMD_TEST)) ? 0 : 1);
		
}


us16 
sap_ev_rx_test_r (void *sap, sap_state_event_t *event)
{
	pdu_un_t *pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == SAP_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_RSP(pdu)) &&   
		(!LLC_PDU_TYPE_IS_U(pdu)) &&  
		(LLC_U_PDU_RSP(pdu) == LLC_1_PDU_CMD_TEST)) ? 0 : 1);

}


us16 
sap_ev_deactivation_request (void *sap, sap_state_event_t *event)
{
	return ((event->type == SAP_EV_TYPE_SIMPLE) &&
		(event->data.a.event == SAP_EV_DEACTIVATION_REQUEST) ? 0 : 1);
}


