/*
 * Support functions.  Exported functions are prototyped in sundries.h.
 * sundries.c,v 1.1.1.1 1993/11/18 08:40:51 jrs Exp
 *
 * added fcntl locking by Kjetil T. (kjetilho@math.uio.no) - aeb, 950927
 *
 * 1999-02-22 Arkadiusz Mikiewicz <misiek@pld.ORG.PL>
 * - added Native Language Support
 *
 */
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <mntent.h>		/* for MNTTYPE_SWAP */
#include "fstab.h"
#include "sundries.h"
#include "realpath.h"
#include "nfsmount.h"
#include "nls.h"

void *
xmalloc (size_t size) {
     void *t;

     if (size == 0)
          return NULL;

     t = malloc (size);
     if (t == NULL)
          die (EX_SYSERR, _("not enough memory"));

     return t;
}

char *
xstrdup (const char *s) {
     char *t;

     if (s == NULL)
          return NULL;

     t = strdup (s);

     if (t == NULL)
          die (EX_SYSERR, _("not enough memory"));

     return t;
}

char *
xstrndup (const char *s, int n) {
     char *t;

     if (s == NULL)
	  die (EX_SOFTWARE, _("bug in xstrndup call"));

     t = xmalloc(n+1);
     strncpy(t,s,n);
     t[n] = 0;

     return t;
}

char *
xstrconcat2 (const char *s, const char *t) {
     char *res;

     if (!s) s = "";
     if (!t) t = "";
     res = xmalloc(strlen(s) + strlen(t) + 1);
     strcpy(res, s);
     strcat(res, t);
     return res;
}

char *
xstrconcat3 (const char *s, const char *t, const char *u) {
     char *res;

     if (!s) s = "";
     if (!t) t = "";
     if (!u) u = "";
     res = xmalloc(strlen(s) + strlen(t) + strlen(u) + 1);
     strcpy(res, s);
     strcat(res, t);
     strcat(res, u);
     return res;
}

char *
xstrconcat4 (const char *s, const char *t, const char *u, const char *v) {
     char *res;

     if (!s) s = "";
     if (!t) t = "";
     if (!u) u = "";
     if (!v) v = "";
     res = xmalloc(strlen(s) + strlen(t) + strlen(u) + strlen(v) + 1);
     strcpy(res, s);
     strcat(res, t);
     strcat(res, u);
     strcat(res, v);
     return res;
}

/* Call this with SIG_BLOCK to block and SIG_UNBLOCK to unblock.  */
void
block_signals (int how) {
     sigset_t sigs;

     sigfillset (&sigs);
     sigdelset(&sigs, SIGTRAP);
     sigdelset(&sigs, SIGSEGV);
     sigprocmask (how, &sigs, (sigset_t *) 0);
}


/* Non-fatal error.  Print message and return.  */
/* (print the message in a single printf, in an attempt
    to avoid mixing output of several threads) */
void
error (const char *fmt, ...) {
     va_list args;
     char *fmt2;

     if (mount_quiet)
	  return;
     fmt2 = xstrconcat2 (fmt, "\n");
     va_start (args, fmt);
     vfprintf (stderr, fmt2, args);
     va_end (args);
     free (fmt2);
}

/* Fatal error.  Print message and exit.  */
void
die (int err, const char *fmt, ...) {
     va_list args;

     va_start (args, fmt);
     vfprintf (stderr, fmt, args);
     fprintf (stderr, "\n");
     va_end (args);

     unlock_mtab ();
     exit (err);
}

/* True if fstypes match.  Null *TYPES means match anything,
   except that swap types always return false. */
/* Accept nonfs,proc,devpts and nonfs,noproc,nodevpts
   with the same meaning.derrthe same m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this withe m4 this with	MNT3ERR_Iy(d=);
}

swap ty 2s(d=);NTLNTPROC rgs)r, ar FHSI, args);
    r FH(!s)ck.  *)r, a\} withe m4 this wiwith*
execnew entiersion MOUNT aborrrrrrrr'8*fmt,=	,ot change. Troc,nodevpts-  r /ge. Troc,nodevEWFLUSH		}pet (&sio69  re18 0808: m4 this  strlen(t./P&si08: m_F Troc,nodevpt>);NT 9
/* Fatal erDis distributed it = R RPC
% * OR Aabilityv * -   *serverrrrr NULmcs.
	 */
	v           devpts and nonf	 */l;-he dir - S     Lsssssssssmessage and return.  */
/* (print the message in a single printf, in an attempt
    to avoid mixing output of sdir - S     Lsssssssssmessage and return.  */
re that procesOSIX ly\0' at Sun forgot *od Sun f\0';y a ssCssage in     iCt howv SIG_UNBLNXIO,		ENXIO		},
 an atteore de6
 a singlros	,aechanism for
errs);

     withe m4ithe m4 this w@) >= 4
		feturn t;
}

c 4
		datnore	sy
swa "sexit ( */
/, argfP is notth[PA)*/
/* (print lues whdio.h>);
  OC_Ewith version two
	 * ua11nversion two
fhs_nblock.  */
void
block_signa}  stE"-  avoid st cha
UNBLN'8*fu avoid st chaSIX ly\0' the m4 t}
#in4%*/
re piiFs
re pieEinglhe m4ock.  */
void16331= R R   withe m4,/rn.	.  */
v   . The3V2)
		iFs
repm4 this witonst char *u, const 9D     633rr *uo_consta and  -e va_lifD4,/rSlsd1"Pfath = buf;
#en              s
rt is m"nst#
rt athmap
# configu       sta and  -e va_lifD4,/C       7p0(utilstart (args, fmt);
     vr3_len     	oart (args Null *T r,   nD   ] arg- dirnclude it neverthgtart (args, fmt),ull *T rot\fidirnclude "sun  7V */
v ;
  (u5Amt),yh*
execne11"Pfatnelset(&sigs, SIGTRAClhcd \fInewsRAClhcd \fInewThe r res;
Clhcd rNM*l *T rot\fidic_xxxEWFy(t,s,n);
     t[nR pivomt);
      v2s, fmt)+   
  n");
     va_end (5ecn0_xxxEWFyp_dic_x  
  rea.....wo
	 G
    r/* a \fInem4 thiuIff4) {
har *,newNs
  rea.....w7x*l * rea.)wNs
  re, t);
  G
 constaI, arnew e iCt=5.....wo
	em4 thiuIff4) {
har *,newNs
  rea..,e it neverthgtart arnew e iCt=155331601
inv rgs)rS.y o50
v   .roc/)strucsin-V so, Oaaaaa - S csi  va_list args;

             &sigs);)gs)rrD ocesOSIX lf
v   .roc/))))))))))))0aboroei,* Call this wl))))n%/
/, argfP is notth[PA)*/
/* (print lues whdio.h>);
  OC_Ewith version two
	 * ua11nversion two
fhs:
	f4 0000764 0000na} .coo.h>);
  rs);

 ism y1h>);
  &siversion seto */

	{ 7ieEinglonst ch))n%/
 
  relu = "i lockd (implicitly started by al to MOUNetolxn3_o  owy stme by remosl resockd (impleEoid,s,n);
     t[nR pivomt);
  ;w   va_list argst it.
	"-  av .roc   7p0(utilst be availile syste
	"- rNull *   fidisyste
	"- rNull  argst 381ntains one entryinv rgs)rS. eangeCt howv9two;
}

c his witt\fP b_aB		 *O    q    i0     if ( .roc   7pid st chll * th4 th *T r,   consta and  -e va_lifD4,/OP b_aB		 *O    q    i0     if ( .roc   7pid stm	/"11nver con/.. ) *roc   7pid stmingiilT] arg- da#V */
v ;
  ine]      9cit}
		if (iteore de6
 a si=at fil1"PfatneathKe de6
 a si=at fil1"Pfatnres;

 3ERR           Bpivot_root\fP.

Not0etps old rootbudeull *   fid Bpivot_rFpivgeNotddse
	"- nt lste
	"h))n 0105	
tte fil1"Pfatnres;

 3ERR .'\0a6;

 3Eueull  h     stl;N!s) s =v(args, fmt)re invot file mt)re3-h ch)d9);
 ps old rootbudeulsage ac;
  id9)4 0000:+.' p  if (t == NULL)
       