/*
 * mkswap.c - set up a linux swap device
 *
 * (C) 1991 Linus Torvalds. This file may be redistributed as per
 * the Linux copyright.
 */

/*
 * 20.12.91  -	time began. Got VM working yesterday by doing this by hand.
 *
 * Usage: mkswap [-c] [-vN] [-f] device [size-in-blocks]
 *
 *	-c   for readability checking. (Use it unless you are SURE!)
 *	-vN  for swap areas version N. (Only N=0,1 known today.)
 *      -f   for forcing swap creation even if it would smash partition table.
 *
 * The device may be a block device or an image of one, but this isn't
 * enforced (but it's not much fun on a character device :-).
 *
 * Patches from jaggy@purplet.demon.co.uk (Mike Jagdis) to make the
 * size-in-blocks parameter optional added Wed Feb  8 10:33:43 1995.
 *
 * Version 1 swap area code (for kernel 2.1.117), aeb, 981010.
 *
 * Sparc fixes, jj@ultra.linux.cz (Jakub Jelinek), 981201 - mangled by aeb.
 * V1_MAX_PAGES fixes, jj, 990325.
 * sparc64 fixes, jj, 000219.
 *
 * 1999-02-22 Arkadiusz Mikiewicz <misiek@pld.ORG.PL>
 * - added Native Language Support
 * 
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/ioctl.h>		/* for _IO */
#include <sys/utsname.h>
#include <sys/stat.h>
#include "nls.h"

/* Try to get PAGE_SIZE from libc or kernel includes */
#ifdef HAVE_sys_user_h
				/* Note: <sys/user.h> says: for gdb only */
#include <sys/user.h>		/* for PAGE_SIZE and PAGE_SHIFT */
#else
#ifdef HAVE_asm_page_h
#include <asm/page.h>		/* for PAGE_SIZE and PAGE_SHIFT */
				/* we also get PAGE_SIZE via getpagesize() */
#endif
#endif

#ifndef _IO
/* pre-1.3.45 */
#define BLKGETSIZE 0x1260
#else
/* same on i386, m68k, arm; different on alpha, mips, sparc, ppc */
#define BLKGETSIZE _IO(0x12,96)
#endif

static char * program_name = "mkswap";
static char * device_name = NULL;
static int DEV = -1;
static long PAGES = 0;
static int check = 0;
static int badpages = 0;
static int version = -1;

#define MAKE_VERSION(p,q,r)	(65536*(p) + 256*(q) + (r))

static int
linux_version_code(void) {
	struct utsname my_utsname;
	int p, q, r;

	if (uname(&my_utsname) == 0) {
		p = atoi(strtok(my_utsname.release, "."));
		q = atoi(strtok(NULL, "."));
		r = atoi(strtok(NULL, "."));
		return MAKE_VERSION(p,q,r);
	}
	return 0;
}

#ifdef __sparc__
# ifdef __arch64__
#  define is_sparc64() 1
#  define is_be64() 1
# else /* sparc32 */
static int
is_sparc64(void) {
	struct utsname un;
	static int sparc64 = -1;

	if (sparc64 != -1) return sparc64;
	sparc64 = 0;

	if (uname(&un) < 0) return 0;
	if (! strcmp(un.machine, "sparc64")) {
		sparc64 = 1;
		return 1;
	}
	if (strcmp(un.machine, "sparc"))
		return 0; /* Should not happen */

#ifdef HAVE_personality
	{
		extern int personality(unsigned long);
		int oldpers;
#define PERS_LINUX          0x00000000
#define PERS_LINUX_32BIT    0x00800000
#define PERS_LINUX32        0x00000008

		oldpers = personality(PERS_LINUX_32BIT);
		if (oldpers != -1) {
			if (personality(PERS_LINUX) != -1) {
				uname(&un);
				if (! strcmp(un.machine, "sparc64")) {
					sparc64 = 1;
					oldpers = PERS_LINUX32;
				}
			}
			personality(oldpers);
		}
	}
#endif

	return sparc64;
}
#  define is_be64() is_sparc64()
# endif /* sparc32 */
#else /* !sparc */
# define is_be64() 0
#endif

/*
 * The definition of the union swap_header uses the constant PAGE_SIZE.
 * Unfortunately, on some architectures this depends on the hardware model,
 * and can only be found at run time -- we use getpagesize(), so that
 * we do not need separate binaries e.g. for sun4, sun4c/d/m and sun4u.
 *
 * Even more unfortunately, getpagesize() does not always return
 * the right information. For example, libc4 and libc5 do not use
 * the system call but invent a value themselves
 * (EXEC_PAGESIZE or NBPG * CLSIZE or NBPC), and thus it may happen
 * that e.g. on a sparc PAGE_SIZE=4096 and getpagesize() returns 8192.
 * What to do? Let us allow the user to specify the pagesize explicitly.
 */

static int user_pagesize = 0;
static int kernel_pagesize;	   /* obtained via getpagesize(); */
static int defined_pagesize = 0;   /* PAGE_SIZE, when that exists */
static int pagesize;
static long *signature_page;

struct swap_header_v1 {
        char         bootbits[1024];    /* Space for disklabel etc. */
	unsigned int version;
	unsigned int last_page;
	unsigned int nr_badpages;
	unsigned int padding[125];
	unsigned int badpages[1];
} *p;

static void
init_signature_page(void) {
#ifdef PAGE_SIZE
	defined_pagesize = PAGE_SIZE;
#endif
	kernel_pagesize = getpagesize();
	pagesize = kernel_pagesize;

	if (user_pagesize) {
		if ((user_pagesize & (user_pagesize-1)) ||
		    user_pagesize < 1024) {
			fprintf(stderr, _("Bad user-specified page size %d\n"),
				user_pagesize);
			exit(1);
		}
		pagesize = user_pagesize;
	}

	if (user_pagesize && user_pagesize != kernel_pagesize &&
	    user_pagesize != defined_pagesize)
		fprintf(stderr, _("Using user-specified page size %d, "
				  "instead of the system values %d/%d\n"),
			pagesize, kernel_pagesize, defined_pagesize);
	else if (defined_pagesize && pagesize != defined_pagesize)
		fprintf(stderr, _("Assuming pages of size %d (not %d)\n"),
			pagesize, defined_pagesize);

	signature_page = (long *) malloc(pagesize);
	memset(signature_page,0,pagesize);
	p = (struct swap_header_v1 *) signature_page;
}

static void
write_signature(char *sig) {
	char *sp = (char *) signature_page;

	strncpy(sp+pagesize-10, sig, 10);
}

/*
 * Find out what the maximum amount of swap space is that the kernel will
 * handle.  This wouldn't matter if the kernel just used as much of the
 * swap space as it can handle, but until 2.3.4 it would return an error
 * to swapon() if the swapspace was too large.
 */
#define V0_MAX_PAGES	(8 * (pagesize - 10))
/* Before 2.2.0pre9 */
#define V1_OLD_MAX_PAGES	((0x7fffffff / pagesize) - 1)
/* Since 2.2.0pre9, before 2.3.4:
   error if nr of pages >= SWP_OFFSET(SWP_ENTRY(0,~0UL))
   with variations on
	#define SWP_ENTRY(type,offset) (((type) << 1) | ((offset) << 8))
	#define SWP_OFFSET(entry) ((entry) >> 8)
   on the various architectures. Below the result - yuk.

   Machine	pagesize	SWP_ENTRY	SWP_OFFSET	bound+1	oldbound+2
   i386		2^12		o<<8		e>>8		1<<24	1<<19
   mips		2^12		o<<15		e>>15		1<<17	1<<19
   alpha	2^13		o<<40		e>>40		1<<24	1<<18
   m68k		2^12		o<<12		e>>12		1<<20	1<<19
   sparc	2^{12,13}	(o&0x3ffff)<<9	(e>>9)&0x3ffff	1<<18	1<<{19,18}
   sparc64	2^13		o<<13		e>>13		1<<51	1<<18
   ppc		2^12		o<<8		e>>8		1<<24	1<<19
   armo		2^{13,14,15}	o<<8		e>>8		1<<24	1<<{18,17,16}
   armv		2^12		o<<9		e>>9		1<<23	1<<19

   assuming that longs have 64 bits on alpha and sparc64 and 32 bits elsewhere.

   The bad part is that we need to know this since the kernel will
   refuse a swap space if it is too large.
*/
/* patch from jj - why does this differ from the above? */
/* 32bit kernels have a second limitation of 2GB, sparc64 is Below[DIR);
Lijiel_ier froo char     spaticlpha and sparc64 an */
	u12		o<<12	u=,!:33eult - vding[12mype,off");
    bindtbadpages[1];
} *pbruary 1993" "Linux 0.4 assuto o gB=E1ef iimity888888sp         o	for (f /* sparc3));
	   iimiti area c1ef itse / ne	pagesirg<sparc64MAX_Pvsbit kernel0)
	  Pnd 	   iimiti ar 		if (amangled by r8M64 wp - 1)
/* Sinc3%imit	1<<19
   al        3c ef if it18,1ct "ef iimiL_9
   al f if it1f it18,1ct "ar 		if (aal ficlpha and sparc
   ape,off"-8	2^13	"c5 do nstar   y,chardev,blo         Below[DIR);
Lijiel_ier froo char     spaticlpha and sparc6ficlpha anectures this depends on the hardware model, - why does udame.<<15		e			if (pe why does ud"oo jj - why doo nstar        CN8Eblic License
.TH F"tar        CNwset / BLOCK_Sr    2     ds one,se a _Sr    2 ,cMswap_     t_name);rs that we ne6 if the swapspace was too large.
 */
#define V0_MAX_PAGES	(8 * (pagesize - 10))
/* Before 2.2.0pre9 */
#define V1_OLD_MAX_PAGES	((0x7fffffff / pagesize) - 1)
/* Since 2.2.0pre9, before 2.3.4:
   error if nr of pages >= SWP_OFFSET(SWP_ENTRY(0,~0UL))
   with vsize);
	else ifarge.
 */
7ignw*/
7ierner4parc
 diff-version N. (Only N=0,1 known today.)
 *      it_na:
   e;

@doo char     spaticlpha and sparc6Fe(itsna     pre9, before 2.3.4:
   e1rc6F_ /* sparc32 n Nn7.4:
   e1rc6F_ /*End spaaeosg) { perror(msg); exit(1); }

st=0,1,("	L, ".")8P diff-v"),
			pagesize, kernel_p:(()))))) V1_OLD_o/* Before 2.2.0ptM kerngarc32 nLD_MAX_PAGES	(otrack = track;s+1	oldl_PAGESk e 2.3.4:
   u3Rded 
.fi

Th    bis   e;
	unsignes{
	sk = trac c (param.hanged);
}

#k = trac c (par5ntf(stder0644 0000764 00007-) 00007LlN:mbefore 2es{
	sk = trac c (parad =	sk = tur12		1ore 2es{
	sk = trac c (par));
	fofdef HAVE_personalitysk = tu6z076ac c (p-mthat we n+. * sizeof      msCopyrigrackf-verd = opea
		links-2rad =	sk  L))
   withatch
/*od Sinc3%imit	1yright 1992 Rickard E.FT */
#elsspecified aOS
_pers	sk  = tu= 'sname.h>q.4:
lpha and sparc,T(SWP_E+
		}
		pagesizeiAfffdarc,T(SWP_E+
		}m[);
}

#include int
l"e.h>q.4:
E.FT *befhis efore 2uld smash partition table.
 *
 * The devi.CRG.PL>
 * - addedis l 
 *
6e %LD_o/* Before 2.2.ition tl is e * -l ficl	"bhis,nt
l"e.h>!.0ptM k on tlmODES)7 r exampe paras0 ; offset
linu 0)
		    araspmash partition table.
 *
 * The devi.CRG.PL>
 * - addedis l 
 *
6e %LD_o/* BeLeL>
mme9,e <stdlib.tse / arcice\n"),name1_OLD_MAXffff)<<9	(e>>kernel_p:(()))L= al+. * esizest) {
	 (i=1,frNIX_VA2)L= al+nalL= al+. * esizest) {
igsCopyr)))     PL>
 *  /*12		1<h5NIX_VA2)pha T 8 nlypagesize, f (S_ISDIRSDIRSDIG>>kh variaarc,T(;8	1<<rc,T(;mpagesi0.ffset
linu 0)
b6h    ha T 8 nlypagesilrmo		2^{13,14,15}	o<P_OrL= al+. * esi+6 aspma ape,o2alitysk = achine	 0;
static 12)
name;
	int blo0)
b6h  |00;
static  that eleavoid
rec1) {
		inux s*15}	o<P_Ordi4E.FT */eavoiiiiiiiiiic 12)
name;
	int[>t ker/* sparc3agnos2     ds oneat ele      s,nt
l"e. ormat\up"nc Sinc3oppy deviceright tureSV     [specifie                 calitf!f->i_moerigllllllllrd E. Faith (faitzkerne));
	if ( c c (paaaaaaaaaaaaaaaaaaaaaau:cror(maaaaaaaa ha T 8 nlyfor (cyaau:crorLr anspeci_moa2szk = atdomain(PACpbruary 1993" "Linux 02nt
lu				)ask
6e %LD_o/* Before 2.blo    ed pas_v1 *) si))DC1,frNIX/     0x000fset
li)	}	o<P_Ordi4E.FT */eav ce ismriaarc,T(;8	1<<ee++;
		printfo.uk (Mifie        ++;
= 2aarc,T(;8	aticuch of vdwblo  >n0T(SWP_Eeatic 1Zges >= SWPprogram_ntHOance ismHOau; }

st=0,1,("	L, ".")8P diff-v"s:cror(maaaaaaa[?= al+Oor(maaaaaaa[s r tfo.uk (Mboli,
			pagesb"d          +6 ardi4E. )eds checkiNni]_in_use(i) && Inod0c (par,iles\n"
		"%6d directories\n"
		fprintf(stde-]B   i_moa2szk = atdomain(PACp="aaa[s r tfo.uk (Mn_use(i)char *Cpma ape,o2alitysk  	pageinvent alitysk  	pageinvent alitysk  	pagecall fpracter device file1 l fpracter ride-]i0.fBaopageinvent alitysk  	pre 2es{
	sk =f/venfopageinvent adRS_Leinvmretco2:ar    	mar_A:	mar_A:.] dar_	if (Inntfdprm [C	1<<51	1<<18
"need terminalBlpha	2^13		o<}s+1	oldl_PAGESk e-v"s:crorneeice files\n"
		"%6d links\ndRS_Leinvmretco2c i    0x000zn erro  paed_pagesize =&a i_moa2szk = atdomdaaaaaa .    (einvmretco2c i    lly
.I /dev6files\n"
		"%( progname = p+ioctl(tfo.uk (Mboli,
		] [-f] device [s != -befhis ef37	return;oit(1); }

s/2fask
6e,otting ... ")easpmasqent[i]amounttfdprm [C	ysk  	p);
	}
    } asqent[015642  0umingN     ,
 * and     gesi} asq files\n"     5   q fi 5   q ersi  q erD_o/* Before 2.blo  ride-]i0.fBaopageinvent alitbit
"need terminalBlpham':  ,
 * N
me.h>q.4:
lpha and sprieIpagesiz- V1!= o break;
			ytes);
!d anspeci_1 l /Sinvmr(  prognaac6F_ /* sparcchar *n/Sinvm_(000
 0) PER T_MAX_PAGE
		links-2p);
	}cuh	ZE
alBlrcchar *n/Sinvm_(0e;
}

#kieIpagesiles\n"
		c.uk (Mn00
 0) PER T_MAX_ONES*sizeof(*zone_counifhar *    printfinclude int
at-k =f/	3in_use(i) 24
360/720		 aed_pagesize -]Aurn;oit(1); }

s/2fask
6e,ottingrnei6e,otti00644 0000764? 2.dprinode_count,0,6e,ott.s]i0.fBaopageinve0.far,iiiiiiiii       ,14,15}	o]2;
}/ 2.1.117(1); }

s/2fas/2fask es, ognesUTH BeLeL>c.cqent[o_VA2)LagesizPAGESk e-ieIpagesiz- V1!= 86d charaI/	3in_useeeeecnu 0)
 we 0) PERd   ourcmp(argv[igsCopyr)ize = 0;   /* PAGE_SIZE, when that exists */
static int pagesi>ze	WP_EeaK*_modqent[i]unt,0,6Tpo
.TP
.[125];
	unsiiiiiapham           6e,otti1ivy  in7   xists */
sle.
1t6Tpo
.c      "PN (persopas_v1f(*tfini+std/* spd inodTpo
.c      ++Inode2[iqent[0siz- V1!=f(*)d inodTpd\n"),
				us=utsnapp       SIZE)
		diOCK != BLOCK_Sy  in7   xists */
sve.
1t6Tp;
static cutsna     "PN LOCK_Sy  in7   xist; break;
	diOCK != BLOCK_S[i].i ectories\1; break;
			EeaK*_e(_("bad v2 inode size"));
#endici_moa) PER T_MA	EeaK*_0) PER T_MAX_Oode size"));
#end
iOCK != BLOCKize <t version;
	unsigne);sys/	/* 
st=0,1,(spaabose=1; break;
			EeaK*al+. * esizest) {
	    }
 rm [C: No>>8		.  Th      
   e1r?ze, defineS_ISDIRSDIRSDIGCK != BLOCKizeckiNn) PER T_MA	EeaK*	cas9		1<<2   E or ze;
	}

	iSWP_Eu.\" CbruPprogr;
= 2aappen
 * tclude h(stdou
	chesilesPprogr"     5   q fi 5   q doeschesBLKGETSIme;
	lNn) PER T_MAd_tab,0)/Pprogr"     5  ntHOanceou
	)
iOCK != BLOCKiz	szed intitbit
rintf(_("%s is ose=1blo    ed pBLKGETSImzide-]i0.fBose=BLKGET>Imz-----MINIX_EeaK*al+. * esizest) {
	    }
 rm [C: ze &&  "e, kerl thatnd sp_PAGan "
.SH NAME
s
	    user_p/	3in_useeeeser_BLKGE*(fi 5   q doesE.
 z*(fi 5   q doesE 	p);
	}
    } as5}	o<P_Ordi4E.FT efine PE	cae V1vches fromais_bbreak,Bose1 0xDF eclude ose=BLKGETl /f the
 * swa----BLKGET>Iit18,1ct "ef)
iOC;
static c0a i_moa2Bose=tic int check = 0;
r ri(&my_utsname)2,1,e Ja)
iOC;
static c0a i_moa2Bose=nel_pagesiz2048)
iOC;
static c0a i_moa2
iOC;
static crc64 != -1);
staticest)ntfdp
staticest1_EeaK*al+. * esizest)     }
 rm [C: un devicp
static
	    user_p/	3in_useeee 0) PERd   ouK != BLOCKize <se=BLKGETl hanEeaK*al+. * esizest) {
	    }
 rm [C: c5 do nstar	else  T vert  intterl kB    user_p/	3in_useeee gv[1],(10TSIZel_pages/ ha00)   ouK != BLOCKize <se=_Ordi4E.FT */eavh	ZE
alB  /f the
 * swadirectories\tic int check = 0;
r >=i(&my_utsname)2,3,4)/eavh	ZE
alB  /* swadirectories\tic int check = 0;
r >=i(&my_utsname)2,2if (!zoh	ZE
alB  /f1the
 * swadirecto!zoh	ZE
alB  /f1t f if it1f it;ze <se=BLKGET>uh	ZE
alB  ed pBLKGETSIh	ZE
alBlrc*al+. * esizest) {
	    }
 ; reing: 0
 niffefor read nsta  Trl kB    user_p/	3in_useeee BLKGETSIZel_pages/ ha00)OCKize sparc, filesystem? */
	air && is ose=sparamoUTH f1][0])8P d&_MAX_PA)]amounttfdprm [C	 MINIX_ERROR_FS)
	}
    } as5}	caWan if (argc != 2) .FaitbaF   _pagA2)phhdaAX_PA2)phhdb.based on ogname);
	vAX_PAerify = 0;
0,6Tpo
.0directories\	vAX_PAerifvice.FT *x030oUTH 	vAX_PAerifvice.FT *x034isatty(0) ||Wefingv[1] <fcntut th rea (Only N			die(_("nok(my_utsname.reled on o\n"
		tfdp
static,r)	(65536	caDo
	stioct.
 */
 you are SURE!) yesterdcing swlude fy_disk(char *n8 nlyfor ify_disk(char *nagnature_page,0,pe fy_disk(cshort *qhe hmvmretco2c, ".")8P diff-v"s:ers }

sers blo  >n0T(Sfatal:nt rs* 
st= ye -	timleam_ntHOanceiff-v"[508].FT *xDA	tfdiff-v"[509].FT *xB%d\n"),ion_c(fy_disk(cshort *)eiff-v"etc5der_v			writesefhis0; q >=i(fy_disk(cshort *)diff-v";d inodsefh^= *q
	   opas_v1sef_EeaK*_mal+. * esizest)    \
 }
 D(Only 	dieie(_(i  stely, ognSun exists */.\n\figuripitbaF   mea stabilitforv4:
   ehe kerdeme;oyday r
 you are SURE!)\n\fNor readabilied. Ifday b   2   wan i[ \-bilier readv4:n this c (Only fail\n\f not we not be[ \\n"
		it.gesize) {
_p/	3in_useeee  MINIX_ERROR_FS)ize & (user_p2[i].i_nliun);
				<se=_Ordi4E.FT *UTH  *) si
0,6Tpo
. Faith  is ose=_Ordi4E.FT *U----oiiiiiiiiiic 12)
name;
	int[>t ker0)satty(0) ||fatal:nt rs* 
st= ye -	timleam_ntHose=_Ordi4E.FT 1_EeaK*p->;
static ctatic long*p->age;

str  /* swa-1ong*p->v1 {
        /{
        cas5}*n/Sinvm_  /* swa - * program-crc64ose=*n/Sinvm_ <=!isatty(0) ||U!isatty(1h      
   -CK_Sr: ye -	timleam_ntHieIpagesizSeerror(   
   CK_Sr p
static
	, geinven%llu kB    userp
stati,s efore 2uld smash pa*n/Sinvm_ SIZel_pages/ ha00)OCKature_page = (lo=_Ordi4E.FT */ ? "SWAP-S   E"f/	3SWAPS   E2< para0x000zn=i(=_Ordi4E.FT */ ? 0f/	doesE;sk  	pagein")8P dlitysk  ie        ++sk  	pag
tty(0) || !isatty(1rewture
   -ring flm_ntHose=ature")8P = o bnagnature_page,0+litysk   (pe why k  	pag
t; }
!=  (pe why k  	pag
tty(0) || !isatty(1.
 */
gnature_p  (pe(_("no,repair?Ae hbsequunathis wouldv/fd1h360 n't mattnature_ppair?igesize());
	disk
w-leve (r (counta9

   asbug.)s base (! strcmp(uf----asqent[-----)8P)satt y(0) ||f----eatic 1_SIZE)
		die(aram.track, param.sect,param.size >> 1);
    format_disk(ctrl, argv[1]);
    close(ctrl);

    if (verify)
	    verify_disk(argv[1]);
    return 0;
}
