/* 
  ricmp.h - Reboot ICMP public functions.  
            v 1.2 Nail (nail@itapac.net)

  Not so much of public.
  All the 'reception and reboot' work is made by ricmp_try .
  
  Interaction with the user regarding ACLs is made thru
  /dev/ricmp and handled by ricmp.c static functions so no
  need to define them here.
*/
   

#ifndef _NET_RICMP_H_
#define _NET_RICMP_H_

#ifdef __KERNEL__
#include <linux/types.h>
#include <net/ip.h>
#include <net/icmp.h>
#else
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#endif /* kernel  */




/***** ACL part ******/
/* Possible actions */

#define RICMP_ACT_IGNORE	0x000
#define RICMP_ACT_ACCEPT	0x010

#define RICMP_ACT_LOG		0x100

/* Possible reboots */
#define RICMP_COLD		0x00 /* cold reboot */
#define RICMP_WARM		0x01 /* warm reboot */

#define RICMP_HARD		0x00 /* like a 'reset' button press */
#define RICMP_SOFT		0x10 /* like a 'shutdown -r now' */


/* The structure of an RICMP acl */
struct ricmp_acl {
	/* set src or dst to INADDR_ANY to consider any host */
	struct in_addr src;
	struct in_addr dst;
	int action; /* action to do on acl match */
	int type; /* type of reboot if RICMP_ACT_ACCEPT is set and match */
};
	
#ifdef __KERNEL__
/* 0 = ok, -1 = error, 1 = already set */
int ricmp_setacl(struct ricmp_acl *);

/* 0 = ok, -1 = error, 1 = not present */
int ricmp_rmacl(struct ricmp_acl *);

/* Called from icmp_echo, to analyze ICMP echos against ACLs and password */
void ricmp_try(struct icmphdr *, struct iphdr *, int);

/* Used to set the password */
void ricmp_setpwd(char *, int);
#endif /* kernel */

#endif  /* header inclusion */
