/*************************************************** */
/* Rule Set Based Access Control                     */
/* Author and (c) 1999-2001: Amon Ott <ao@rsbac.org> */
/* Memory allocation                                 */
/* Last modified: 12/Apr/2001                        */
/*************************************************** */

#ifndef __RSBAC_RKMEM_H
#define __RSBAC_RKMEM_H

#include <linux/init.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#ifdef CONFIG_RSBAC_INIT_DELAY
void rsbac_kmem_cache_sizes_init(void);
#else
void __init rsbac_kmem_cache_sizes_init(void);
#endif
#endif

/* if you might need more than this, use rsbac_vkmalloc! */
#define RSBAC_MAX_KMALLOC 8192

extern void * rsbac_kmalloc (size_t size);

/* Allocate memory. This function decides which alloc type (kmalloc or vmalloc) */
/* to use and returns the decision as boolean value (TRUE = vmalloc), */
/* if vmalloc_used_p is not NULL (what it should rather be...) */
extern void * rsbac_vkmalloc (size_t size, boolean * vmalloc_used_p);

extern void rsbac_kfree (const void *objp);

/* Free the allocated mem. Needs old returned mem type value, */
/* or FALSE, if no type stored (kmalloc type assumed) */
extern void rsbac_vkfree (void *objp, boolean vmalloc_used);

#endif
