/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.HyperlinkActivatedListener;

public class JHtmlLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -2146502207121434264L;
    private static final Log log = LogFactory.getLog(JHtmlLabel.class);
    private HyperlinkActivatedListener listener = null;

    public JHtmlLabel(HyperlinkActivatedListener listener) {
        this(null, listener);
    }

    public JHtmlLabel(String htmlText, HyperlinkActivatedListener listener) {
        if (htmlText != null) {
            this.setText(htmlText);
        }
        if (listener != null) {
            this.setHyperlinkeActivatedListener(listener);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setHyperlinkeActivatedListener(HyperlinkActivatedListener listener) {
        this.listener = listener;
    }

    public void mouseClicked(MouseEvent e) {
        JLabel.AccessibleJLabel acc = (JLabel.AccessibleJLabel)this.getAccessibleContext();
        int stringIndexAtPoint = acc.getIndexAtPoint(e.getPoint());
        if (stringIndexAtPoint < 0) {
            return;
        }
        AttributeSet attr = (AttributeSet)acc.getCharacterAttribute(acc.getIndexAtPoint(e.getPoint())).getAttribute(HTML.Tag.A);
        if (attr != null) {
            String href = (String)attr.getAttribute(HTML.Attribute.HREF);
            String target = (String)attr.getAttribute(HTML.Attribute.TARGET);
            try {
                if (this.listener == null) {
                    log.warn((Object)("No HyperlinkActivatedListener available to follow HTML link for label: " + this.getText()));
                } else {
                    this.listener.followHyperlink(new URL(href), target);
                }
            }
            catch (Exception ex) {
                log.error((Object)("Unable to load URL: " + href), (Throwable)ex);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        JLabel.AccessibleJLabel acc = (JLabel.AccessibleJLabel)this.getAccessibleContext();
        int stringIndexAtPoint = acc.getIndexAtPoint(e.getPoint());
        if (stringIndexAtPoint < 0) {
            return;
        }
        AttributeSet attr = acc.getCharacterAttribute(stringIndexAtPoint);
        if (attr.getAttribute(HTML.Tag.A) == null) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

